/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.GetPostAction;
import org.zhiqim.httpd.validate.ones.IsByteLen;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.dao.ZmrParamDao;
import org.zhiqim.manager.dbo.ZmrParam;

/**
 * 修改参数页面和处理
 *
 * @version v1.0.0 @author zouzhigang 2015-5-28 新建与整理
 * @version v1.4.1 @author zouzhigang 2015-5-4 删除刷新缓存标志，移到缓存管理功能
 */
public class ParamAction extends GetPostAction
{
    protected void validate(HttpRequest request)
    {
        request.addValidate(new IsNotEmpty("paramGroup", "参数组编码未获取到,请重试"));
        request.addValidate(new IsNotEmpty("paramKey", "参数编码未获取到,请重试"));
        request.addValidate(new IsByteLen("paramValue", "参数值可以为空且不能超过2000个字符", 0, 2000));
    }
    
    protected void doGet(HttpRequest request) throws Exception
    {
        request.setValidateConfirm("修改系统参数后会对系统产生影响，确定要修改参数吗？");
        request.setAttribute("groupMap", ZmrParamDao.getGroupMap(request.getContext()));
    }

    protected void doPost(HttpRequest request) throws Exception
    {
        String paramGroup = request.getParameter("paramGroup");
        String paramKey = request.getParameter("paramKey");
        String paramValue = request.getParameterNoFilter("paramValue");
        
        ZmrParam param = ZmrParamDao.getParam(request.getContext(), paramGroup, paramKey);
        if (param == null)
        {
            request.returnHistory("您选择的参数不存在，请选择有效的参数进行修改");
            return;
        }
        
        if (Validates.isEqual(param.getParamValue(), paramValue))
        {
            request.setRedirect("param.htm");
            return;
        }
        
        ZmrParamDao.doUpdate(request.getContext(), paramGroup, paramKey, paramValue);
        request.setRedirectTop("param.htm");
    }
}
