/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import java.util.List;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.StdSwitchAction;
import org.zhiqim.httpd.validate.ones.IsIntegerValue;
import org.zhiqim.httpd.validate.ones.IsLen;
import org.zhiqim.httpd.validate.onex.IsInteger;
import org.zhiqim.kernel.util.Ids;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dao.ZmrOrgDao;
import org.zhiqim.manager.dbo.ZmrDept;
import org.zhiqim.manager.dbo.ZmrDeptRule;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.manager.dbo.ZmrOrg;
import org.zhiqim.manager.dbo.ZmrRole;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;

/**
 * 组织管理
 *
 * @version v1.0.0 @author zzy 2018-5-30 新建与整理
 */
public class OrgAction extends StdSwitchAction implements ZmrConstants
{

    @Override
    protected void validateId(HttpRequest request)
    {
        request.addValidate(new IsInteger("orgId", "请选择一个选项"));
    }

    @Override
    protected void validateForm(HttpRequest request)
    {
        request.addValidate(new IsLen("orgName", "组织名称不能为空且不能超过32个汉字", 1, 32));
        request.addValidate(new IsIntegerValue("orgSeq", "组织排序必须是[0, 999999]范围的非负整数", 0, 999999));
        request.addValidate(new IsLen("orgDesc", "组织描述可为空或不能超过100个汉字", 0, 100));
    }

    @Override
    protected void list(HttpRequest request) throws Exception
    {
        List<ZmrOrg> list = ZmrOrgDao.list(request);
        request.setAttribute("list", list);
    }
    
    @Override
    protected void add(HttpRequest request) throws Exception
    {
        ZmrOrg parent = ZmrBootstrap.tableOpr(request).item(ZmrOrg.class, new Selector("orgLevel", 0));
        if (parent == null)
        {
            request.returnHistory("上级组织不存在，请选择正确的组织");
            return;
        }
        
        request.setAttribute("parent", parent);
    }

    @Override
    protected void modify(HttpRequest request) throws Exception
    {
        long orgId = request.getParameterLong("orgId");
        ZmrOrg org = ZmrBootstrap.tableOpr(request).item(ZmrOrg.class, orgId);
        if (org == null)
        {
            request.returnHistory("组织不存在，请选择正确的组织");
            return;
        }
        
        request.setAttribute("org", org);
    }

    @Override
    protected void insert(HttpRequest request) throws Exception
    {
        ZmrOrg org = request.getParameter(ZmrOrg.class);
        

        org.setOrgId(Ids.longId13());
        org.setOrgLevel(1);
        ZmrBootstrap.table(request).insert(org);
        
        //插入部门
        ZmrDept dept = new ZmrDept();
        dept.setOrgId(org.getOrgId());
        dept.setParentId(0);
        dept.setDeptId(org.getOrgId());
        dept.setDeptName(org.getOrgName());
        dept.setDeptStatus(0);
        dept.setDeptLevel(0);
        dept.setDeptParentAll("0");
        
        ZmrBootstrap.table(request).insert(dept);
    }

    @Override
    protected void update(HttpRequest request) throws Exception
    {
        long orgId = request.getParameterLong("orgId");
        ZmrOrg org = ZmrBootstrap.tableOpr(request).item(ZmrOrg.class, new Selector("orgId", orgId));
        String orgName = request.getParameter("orgName");
        int orgStatus = request.getParameterInt("orgStatus");
        int orgSeq = request.getParameterInt("orgSeq");
        String orgManager = request.getParameter("orgManager");
        String orgDesc = request.getParameter("orgDesc");
        int needCoordinate = request.getParameterInt("needCoordinate");
        
        Updater updater = new Updater();
        updater.addMust("orgId", orgId);
        updater.addField("orgName", orgName);
        updater.addField("orgStatus", orgStatus);
        updater.addField("orgSeq", orgSeq);
        updater.addField("orgManager", orgManager);
        updater.addField("orgDesc", orgDesc);
        updater.addField("needCoordinate", needCoordinate);
        
        ZmrBootstrap.tableOpr(request).update(ZmrOrg.class, updater);
        
        //将组织负责人的级别提升为管理员
        if(Validates.isNotEmpty(orgManager))
        {
            Updater operatorUpdater = new Updater();
            operatorUpdater.addMust("operatorCode", orgManager);
            operatorUpdater.addField("operatorType", 1);
            ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, operatorUpdater);
        }
        
        //更换负责人，将原来负责人的权限降为操作员
        String oldOrgManager = org.getOrgManager();
        if(Validates.isNotEmpty(oldOrgManager))
        {
            if(!oldOrgManager.equals(orgManager)){
                Updater operatorUpdater = new Updater();
                operatorUpdater.addMust("operatorCode", oldOrgManager);
                operatorUpdater.addField("operatorType", 2);
                ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, operatorUpdater);
            }
        }
    }

    @Override
    protected void delete(HttpRequest request) throws Exception
    {
        ZmrSessionUser sessionUser = request.getSessionUser(ZmrSessionUser.class);
        long orgId = request.getParameterLong("orgId");
        
        if (sessionUser.getSelectedOrgId() == orgId)
        {
            request.returnHistory("当前选中组织不能删除，请先切换组织");
            return;
        }
        
        ZmrOrg org = ZmrBootstrap.tableOpr(request).item(ZmrOrg.class, orgId);
        if (org == null)
        {
            request.returnHistory("组织不存在，请选择正确的组织");
            return;
        }
        
        if (org.getOrgLevel() == 0)
        {
            request.returnHistory("顶级组织不能删除，只允许修改");
            return;
        }
        
        if (ZmrBootstrap.table(request).count(ZmrDept.class, new Selector("orgId", orgId)) > 1)
        {
            request.returnHistory("该组织已有部门，要先删除部门（根部门除外）才能删除本组织");
            return;
        }
        
        if (ZmrBootstrap.table(request).count(ZmrRole.class, new Selector("orgId", orgId)) > 0)
        {
            request.returnHistory("该组织已有角色，要先删除角色才能删除本组织");
            return;
        }
        
        if (ZmrBootstrap.tableOpr(request).count(ZmrOperator.class, new Selector().addMust("orgId", orgId)) > 0)
        {
            request.returnHistory("该组织已有操作员，请删除组织成员后再删除本组织");
            return;
        }
        
        //清除根部门、根部门权限
        ZmrDept dept = ZmrBootstrap.table(request).item(ZmrDept.class, new Selector("orgId", orgId).addMust("deptLevel", 0));
        if (dept != null)
        {
            long deptId = dept.getDeptId();
            ZmrBootstrap.table(request).delete(ZmrDeptRule.class, new Selector("deptId", deptId));
            ZmrBootstrap.table(request).delete(ZmrDept.class, deptId);
        }
        
        ZmrBootstrap.tableOpr(request).delete(ZmrOrg.class, orgId);
    }
}