/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import java.util.List;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.ValidateAction;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.kernel.tree.Tree;
import org.zhiqim.kernel.tree.TreeBuilder;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.dao.ZmrOperatorDao;
import org.zhiqim.manager.dbo.ZmrMenu;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.orm.dbo.Selector;

/**
 * 操作员权限显示
 *
 * @version v1.0.0 @author zouzhigang 2015-5-28 新建与整理
 */
public class OperatorRuleViewAction extends ValidateAction
{
    protected void validate(HttpRequest request)
    {
        request.addValidate(new IsNotEmpty("operatorCode", "请选择操作员"));
    }

    protected void perform(HttpRequest request) throws Exception
    {
        request.setResponsePrivateCache();
        
        String operatorCode = request.getParameter("operatorCode");
        ZmrOperator operator = ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, operatorCode);
        if (operator == null)
        {
            request.returnHistory("您选择的操作员不存在");
            return;
        }
        
        // 获取操作员权限
        List<ZmrMenu> list = ZmrOperatorDao.getOperatorMenuList(request, operator);
        if (list.isEmpty())
        {//没有一个权限的，取根节点
            list = ZmrBootstrap.table(request).list(ZmrMenu.class, new Selector("menuLevel", 0));
        }
        
        Tree<ZmrMenu> tree = TreeBuilder.newTree(list, "parentCode", "menuCode");

        request.setAttribute("operator", operator);
        request.setAttribute("menuSize", list.size());
        request.setAttribute("tree", tree);
    }
}
