/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.context.returns;

import java.net.SocketException;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.context.core.Context;
import org.zhiqim.httpd.context.core.Return;
import org.zhiqim.httpd.util.Responses;
import org.zhiqim.httpd.util.Scripts;
import org.zhiqim.kernel.util.Htmls;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.zml.ZmlEngine;

public class ReturnFrame
implements Return {
    @Override
    public void process(HttpRequest request) throws SocketException {
        Context context = (Context)request.getContext();
        ZmlEngine engine = context.getZmlEngine();
        if (engine.hasZml("/conf/return/returnFrame.zml")) {
            returnTemplate.process(request, "/conf/return/returnFrame.zml", null);
            return;
        }
        HttpResponse response = request.getResponse();
        String encoding = response.getCharacterEncoding();
        StringBuilder strb = new StringBuilder();
        strb.append("<!DOCTYPE html>").append("\r\n");
        strb.append("<html>").append("\r\n");
        strb.append("<head>").append("\r\n");
        strb.append(Htmls.toTitle((String)request.getContextName()));
        strb.append(Htmls.toContentType((String)encoding));
        strb.append("<script>\r\n");
        this.buildAlertMsgFunction(request, strb);
        this.buildCallbackFunction(request, strb);
        strb.append("</script>").append("\r\n");
        strb.append("</head>").append("\r\n");
        strb.append("</html>").append("\r\n");
        Responses.printAndCommit(response, strb, log);
    }

    private void buildAlertMsgFunction(HttpRequest request, StringBuilder strb) {
        String message = request.getAlertMsg();
        if (Validates.isEmpty((String)message)) {
            strb.append("callback();").append("\r\n").append("\r\n");
            return;
        }
        message = Scripts.formatAlertMsg(message);
        strb.append("if (parent.Z && parent.Z.onload && parent.Z.alert)").append("\r\n").append("{").append("\r\n").append("    ").append("parent.Z.alert(\"").append(message).append("\", callback, {type: \"").append(request.isResponseSuccess() ? "success" : "failure").append("\"});").append("\r\n").append("}").append("\r\n").append("else").append("\r\n").append("{").append("\r\n").append("    ").append("alert(\"").append(message).append("\");").append("\r\n").append("    ").append("callback();").append("\r\n").append("}").append("\r\n").append("\r\n");
    }

    private void buildCallbackFunction(HttpRequest request, StringBuilder strb) {
        int formIndex;
        int returnType = request.getForceReturnType();
        strb.append("function callback()").append("\r\n").append("{").append("\r\n");
        if (returnType != 0 && (formIndex = request.getParameterInt("zFormIndex")) != -1) {
            strb.append("    ").append("if (parent.setFormButtonResume){").append("\r\n").append("    ").append("    ").append("parent.setFormButtonResume(").append(formIndex).append(");").append("\r\n").append("    ").append("}").append("\r\n").append("\r\n");
        }
        switch (request.getForceReturnType()) {
            case -1: 
            case 1: 
            case 2: 
            case 3: {
                strb.append("    ").append("window.location.href = \"about:blank\";").append("\r\n");
                break;
            }
            case 4: {
                String redirect = request.getRedirect("UTF-8");
                strb.append("    ").append(redirect.substring("javascript:".length())).append("\r\n");
                break;
            }
            default: {
                String redirect = request.getRedirect("UTF-8");
                redirect = redirect.replaceAll("\r", "");
                redirect = redirect.replaceAll("\n", "");
                if (redirect.startsWith("/") && !redirect.startsWith("//")) {
                    redirect = request.getContext().getRootPath(redirect);
                }
                strb.append("    ");
                int target = request.getResponseStatus();
                if (target == 601) {
                    strb.append("parent.parent.location.href=\"");
                } else if (target == 603) {
                    strb.append("top.location.href=\"");
                } else {
                    strb.append("parent.location.href=\"");
                }
                strb.append(redirect).append("\";").append("\r\n");
            }
        }
        strb.append("}").append("\r\n");
    }
}

