/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.context;

import java.util.ArrayList;
import java.util.List;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpWebsocket;
import org.zhiqim.httpd.HttpWebsocketConnection;
import org.zhiqim.httpd.HttpWebsocketManager;
import org.zhiqim.httpd.context.ZmlContext;
import org.zhiqim.kernel.extend.HashMapSV;
import org.zhiqim.kernel.schedule.Interval;
import org.zhiqim.kernel.schedule.Task;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Validates;

public class ZmlWebsocketManager
implements HttpWebsocketManager,
Task {
    private final ZmlContext context;
    private final List<HttpWebsocketConnection> connList;
    private final HashMapSV<HttpWebsocket> websocketMap;
    private Interval interval;

    public ZmlWebsocketManager(ZmlContext context) {
        this.context = context;
        this.connList = new ArrayList<HttpWebsocketConnection>();
        this.websocketMap = new HashMapSV();
    }

    @Override
    public void open() {
        this.interval = Interval.shedule((Task)this, (int)29000);
    }

    @Override
    public void close() {
        if (this.interval != null) {
            this.interval.close();
            this.interval = null;
        }
    }

    @Override
    public HttpContext getContext() {
        return this.context;
    }

    @Override
    public HttpWebsocket getWebsocket(String protocol) {
        if (Validates.isEmptyBlank((String)protocol)) {
            return null;
        }
        if (this.websocketMap.containsKey(protocol)) {
            return (HttpWebsocket)this.websocketMap.get(protocol);
        }
        HttpWebsocket websocket = this.context.getConfig().getWebsocket(protocol);
        this.websocketMap.put(protocol, (Object)websocket);
        return websocket;
    }

    @Override
    public List<HttpWebsocketConnection> get(String protocol) {
        if (protocol == null) {
            return this.connList;
        }
        ArrayList<HttpWebsocketConnection> sList = new ArrayList<HttpWebsocketConnection>();
        for (HttpWebsocketConnection conn : this.connList) {
            if (!protocol.equals(conn.getProtocol())) continue;
            sList.add(conn);
        }
        return sList;
    }

    @Override
    public List<HttpWebsocketConnection> get(String protocol, String sessionId) {
        if (sessionId == null) {
            return this.get(protocol);
        }
        ArrayList<HttpWebsocketConnection> sList = new ArrayList<HttpWebsocketConnection>();
        if (protocol == null) {
            for (HttpWebsocketConnection conn : this.connList) {
                if (!sessionId.equals(conn.getSessionId())) continue;
                sList.add(conn);
            }
        } else {
            for (HttpWebsocketConnection conn : this.connList) {
                if (!protocol.equals(conn.getProtocol()) || !sessionId.equals(conn.getSessionId())) continue;
                sList.add(conn);
            }
        }
        return Lists.trim(sList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(HttpWebsocketConnection conn) {
        List<HttpWebsocketConnection> list = this.connList;
        synchronized (list) {
            this.connList.add(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(HttpWebsocketConnection conn) {
        List<HttpWebsocketConnection> list = this.connList;
        synchronized (list) {
            this.connList.remove(conn);
        }
    }

    public void execute() {
        ArrayList<HttpWebsocketConnection> closes = new ArrayList<HttpWebsocketConnection>();
        for (HttpWebsocketConnection conn : this.connList) {
            if (!this.context.getSessionManager().hasSession(conn.getSessionId())) {
                closes.add(conn);
                continue;
            }
            if (conn.sendPing()) continue;
            closes.add(conn);
        }
        for (HttpWebsocketConnection conn : closes) {
            conn.close();
        }
        closes.clear();
    }
}

