/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.context;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import org.zhiqim.httpd.HttpException;
import org.zhiqim.httpd.HttpExecutor;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.context.ZmlContextConstants;
import org.zhiqim.httpd.context.config.ZAction;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.httpd.context.core.Context;
import org.zhiqim.httpd.context.extend.DispatchAction;
import org.zhiqim.httpd.context.extend.GetPostAction;
import org.zhiqim.httpd.context.extend.StdDispatchAction;
import org.zhiqim.httpd.context.extend.StdSwitchAction;
import org.zhiqim.httpd.context.extend.ValidateAction;
import org.zhiqim.httpd.context.extend.ViewExecAction;
import org.zhiqim.httpd.context.returns.ReturnResult;
import org.zhiqim.httpd.context.returns.ReturnView;
import org.zhiqim.kernel.annotation.AnTransaction;
import org.zhiqim.kernel.transaction.Transaction;
import org.zhiqim.kernel.transaction.TransactionManager;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.zml.ZmlEngine;
import org.zhiqim.zml.ZmlLoader;

public class ZmlExecutor
implements HttpExecutor,
ZmlContextConstants {
    private List<String> patternList;
    private ReturnView returnView;
    private ReturnResult returnResult;

    public ZmlExecutor(String patterns) {
        this.patternList = Lists.toStringList((String)patterns);
        this.returnView = new ReturnView();
        this.returnResult = new ReturnResult();
    }

    @Override
    public boolean isMatch(String pathInContext) {
        return true;
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response) throws HttpException, IOException {
        String path;
        Context context = (Context)request.getContext();
        ZAction zAction = context.getAction(path = request.getPathInContext());
        if (zAction != null) {
            this.handleAction(request, response, zAction);
        } else if (this.isMatchPattern(path)) {
            this.handleZML(request, response);
        } else {
            context.handleResource(request, response);
        }
    }

    private boolean isMatchPattern(String pathInContext) {
        for (String pattern : this.patternList) {
            if (!Validates.isMatch((String)pathInContext, (String)pattern)) continue;
            return true;
        }
        return false;
    }

    private void handleZML(HttpRequest request, HttpResponse response) throws HttpException, IOException {
        Context context = (Context)request.getContext();
        String path = request.getPathInContext();
        ZmlEngine engine = context.getZmlEngine();
        if (engine == null) {
            context.getNotFoundHandler().handle(request, response);
            return;
        }
        ZmlLoader loader = engine.getZmlLoader(path);
        if (loader == null) {
            context.getNotFoundHandler().handle(request, response);
            return;
        }
        if (request.isMethodHead()) {
            response.sendHeader(200);
            return;
        }
        request.setResponseEncodingUTF8();
        request.setResponseNoCache();
        this.returnView.process(request, path, null);
        if (request.isResponseRedirect()) {
            this.returnResult.process(request);
        }
    }

    /*
     * Exception decompiling
     */
    private void handleAction(HttpRequest request, HttpResponse response, ZAction zAction) throws HttpException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 27[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Transaction getTransaction(HttpRequest request, ZAction fAction, Action action) throws Exception {
        AnTransaction anTx;
        Method method;
        if (Validates.isNotEmpty((String)fAction.getTransaction())) {
            String transaction = fAction.getTransaction();
            if ("true".equals(transaction)) {
                return TransactionManager.beginTransaction((String[])new String[0]);
            }
            return TransactionManager.beginTransaction((String[])Arrays.toStringArray((String)transaction));
        }
        String fMethod = fAction.getMethod();
        if (Validates.isEmpty((String)fMethod)) {
            fMethod = this.getActionDefaultMethod(request, action);
        }
        if (Validates.isNotEmpty((String)fAction.getMethod()) && (method = Classes.getMethod(action.getClass(), (String)fMethod, (Class[])new Class[]{HttpRequest.class})) != null && (anTx = method.getAnnotation(AnTransaction.class)) != null) {
            return TransactionManager.beginTransaction((String[])anTx.value());
        }
        AnTransaction anTx2 = action.getClass().getAnnotation(AnTransaction.class);
        if (anTx2 != null) {
            return TransactionManager.beginTransaction((String[])anTx2.value());
        }
        return null;
    }

    private String getActionDefaultMethod(HttpRequest request, Action action) {
        if (action instanceof ValidateAction) {
            return "perform";
        }
        if (action instanceof ViewExecAction) {
            return "view";
        }
        if (action instanceof StdSwitchAction) {
            return "list";
        }
        if (action instanceof StdDispatchAction || action instanceof DispatchAction) {
            return request.getParameter("method");
        }
        if (action instanceof GetPostAction) {
            if (request.isMethodGet()) {
                return "doGet";
            }
            if (request.isMethodPost()) {
                return "doPost";
            }
            return null;
        }
        return "execute";
    }
}

