/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.zhiqim.httpd.HttpExecutor;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.HttpWebsocketService;
import org.zhiqim.httpd.context.ZmlContextConstants;
import org.zhiqim.httpd.context.service.AjaxService;
import org.zhiqim.httpd.context.service.ResourceService;
import org.zhiqim.httpd.context.service.RmiService;
import org.zhiqim.httpd.context.service.UploadAccessService;
import org.zhiqim.httpd.context.service.UploadService;
import org.zhiqim.httpd.context.service.VcodeService;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Validates;

public class ServiceExecutor
implements HttpExecutor,
ZmlContextConstants {
    private HashMap<String, HttpExecutor> executorMap = new HashMap();
    private ArrayList<HttpExecutor> executors = new ArrayList();

    public ServiceExecutor() {
        this.executorMap.put("/service/ajax", new AjaxService());
        this.executorMap.put("/service/rmi", new RmiService());
        this.executorMap.put("/service/vcode.jpg", new VcodeService());
        this.executorMap.put("/service/upload", new UploadService());
        this.executorMap.put("/service/ws", new HttpWebsocketService());
        this.executors.add(new ResourceService());
        this.executors.add(new UploadAccessService());
        this.executors.trimToSize();
    }

    @Override
    public boolean isMatch(String pathInContext) {
        return Validates.isMatch((String)pathInContext, (String)"/service/*");
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response) throws IOException {
        HttpExecutor executor = this.getMatchExecutor(request.getPathInContext());
        if (executor != null) {
            executor.handle(request, response);
        } else {
            request.getContext().getNotFoundHandler().handle(request, response);
        }
    }

    public RmiService getRmiService() {
        return (RmiService)this.executorMap.get("/service/rmi");
    }

    public void addService(String path, HttpExecutor service) {
        Asserts.as((String)(Validates.isLen((String)path, (int)10, (int)100) && path.startsWith("/service/") ? null : "\u589e\u52a0ZML\u4e0a\u4e0b\u6587\u73af\u5883\u4e0b\u670d\u52a1\u65f6\uff0cpath\u5fc5\u987b\u4ee5/service/\u5f00\u5934\uff0c\u6700\u957f100\u5b57\u7b26"));
        Asserts.as((String)(service != null ? null : "\u589e\u52a0ZML\u4e0a\u4e0b\u6587\u73af\u5883\u4e0b\u670d\u52a1\u65f6\uff0c\u670d\u52a1\u4e0d\u80fd\u4e3anull"));
        if (path.contains("*")) {
            this.executors.add(service);
        } else {
            this.executorMap.put(path, service);
        }
    }

    private HttpExecutor getMatchExecutor(String pathInContext) {
        HttpExecutor executor = this.executorMap.get(pathInContext);
        if (executor != null) {
            return executor;
        }
        for (HttpExecutor handler : this.executors) {
            if (!handler.isMatch(pathInContext)) continue;
            return handler;
        }
        return null;
    }
}

