/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.bio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.zhiqim.httpd.HttpListener;
import org.zhiqim.httpd.HttpServer;
import org.zhiqim.httpd.bio.HttpBioConnection;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Sockets;
import org.zhiqim.kernel.util.Threads;
import org.zhiqim.kernel.util.Validates;

public class HttpBioListener
extends HttpListener {
    private ServerSocket serverSocket;

    public HttpBioListener(HttpServer server) {
        super(server);
    }

    @Override
    protected boolean openBefore() {
        super.openBefore();
        try {
            this.serverSocket = Validates.isEmpty((String)this.listenerIp) ? new ServerSocket(this.listenerPort) : new ServerSocket(this.listenerPort, 50, InetAddress.getByName(this.listenerIp));
            this.serverSocket.setReuseAddress(true);
            return true;
        }
        catch (Exception e) {
            throw Asserts.exception((Exception)e);
        }
    }

    @Override
    protected void closeAfter() {
        if (this.serverSocket != null) {
            Threads.closeIgnoreException((AutoCloseable)this.serverSocket);
            this.serverSocket = null;
        }
        super.closeAfter();
    }

    protected void loop() {
        try {
            Socket socket = this.serverSocket.accept();
            Sockets.setOption((Socket)socket, (boolean)true, (int)this.soTimeoutMs, (int)this.soLingerS, (boolean)false);
            this.controller.execute((Runnable)this.add(this.newConnection(socket)));
        }
        catch (SocketException e) {
            if (!"Socket closed".equalsIgnoreCase(e.getMessage())) {
                log.error((Object)(String.valueOf(this.toString()) + "SocketException\u5f02\u5e38"), (Throwable)e, new Object[0]);
            }
        }
        catch (IOException e) {
            log.error((Object)(String.valueOf(this.toString()) + "IO\u5f02\u5e38"), (Throwable)e, new Object[0]);
        }
    }

    private HttpBioConnection newConnection(Socket socket) throws IOException {
        return new HttpBioConnection(this, socket, socket.getInputStream(), socket.getOutputStream());
    }
}

