/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_calendar.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.calendar.action;

import java.util.ArrayList;
import java.util.List;

import org.zhiqim.calendar.ZmrCalendarConstants;
import org.zhiqim.calendar.dbo.ZmrCalendar;
import org.zhiqim.calendar.model.CalendarModel;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;

/**
 * 日历信息表
 *
 * @version v1.0.0 @author huangsufang 2017-10-27 新建与整理
 */
public class CalendarAction implements Action, ZmrCalendarConstants
{
    @Override
    public void execute(HttpRequest request) throws Exception
    {
        int year = request.getParameterInt("year", DateTimes.getCurrentYear());
        int month = request.getParameterInt("month", DateTimes.getCurrentMonth());
        
        boolean isPrev = request.getParameterBoolean("prev");
        boolean isNext = request.getParameterBoolean("next");
        
        if (isPrev)
        {
            year = month==1?year-1:year;
            month = month==1?12:month-1;
        }
        else if (isNext)
        {
            year = month==12?year+1:year;
            month = month==12?1:month+1;
        }
        
        //计算上月和下月，并取出上当下三月数据
        int prevYear = month==1?year-1:year;
        int prevMonth = month==1?12:month-1;
        int nextYear = month==12?year+1:year;
        int nextMonth = month==12?1:month+1;

        Selector selector = new Selector();
        selector.addMustThenG("calendarDate", prevYear * 10000 + prevMonth * 100);
        selector.addMustThenL("calendarDate", nextYear * 10000 + (nextMonth+1) * 100);
        List<ZmrCalendar> calendarList = ORM.get(ZTable.class, request).list(ZmrCalendar.class, selector);
        
        List<CalendarModel> list = new ArrayList<>();
        
        //生成日历表
        int firstWeek = DateTimes.getDateWeek7(year, month, 1); //某月第一天的星期几
        int curMonthMaxDay = DateTimes.getMonthDays(year, month);
        int prevMonthMaxDay = DateTimes.getMonthDays(prevYear, prevMonth);
        
        //1到firstWeek表示上月
        for (int i=1;i<=firstWeek;i++)
        {
            int day = prevMonthMaxDay-firstWeek+i;
            
            CalendarModel date = new CalendarModel();
            date.setCalendarDate(prevYear, prevMonth, day);
            date.setCalendarMonth(PREV_MONTH);
            
            setCalendarDay(calendarList, date);
            list.add(date);
        }
        
        //firstWeek+1到firstWeek+1+curMonthMaxDay表示当月
        for (int i=firstWeek+1;i<firstWeek+1+curMonthMaxDay;i++)
        {
            int day = i-firstWeek;
            
            CalendarModel date = new CalendarModel();
            date.setCalendarDate(year, month, day);
            date.setCalendarMonth(CURR_MONTH);
            
            setCalendarDay(calendarList, date);
            list.add(date);
        }
        
        //firstWeek+1+curMonthMaxDay+1到42表示下月
        for (int i=firstWeek+1+curMonthMaxDay;i<=42;i++)
        {
            int day = i-curMonthMaxDay-firstWeek;//日期从1到显示的最后一天
            
            CalendarModel date = new CalendarModel();
            date.setCalendarDate(nextYear, nextMonth, day);
            date.setCalendarMonth(NEXT_MONTH);
            
            setCalendarDay(calendarList, date);
            list.add(date);
        }
        
        request.setAttribute("year", year);
        request.setAttribute("month", month);
        request.setAttribute("list", list);
    }
    
    private void setCalendarDay(List<ZmrCalendar> calendarList, CalendarModel date)
    {
        ZmrCalendar calendar = getCalendar(calendarList, date.getCalendarDate());
        if (calendar != null)
        {//存在配置取配置
            date.setCalendarRest(calendar.isCalendarRest());
        }
        else
        {//否则周六周末认为是休息日
            int week = DateTimes.getDateWeek7(date.getYear(), date.getMonth(), date.getDay());
            date.setCalendarRest(week == 6 || week == 7);
        }
    }
    
    private ZmrCalendar getCalendar(List<ZmrCalendar> calendarList, int date)
    {
        for (ZmrCalendar calendar : calendarList)
        {
            if (calendar.getCalendarDate() == date)
                return calendar;
        }
        
        return null;
    }
}
