/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util.seqs;

import java.util.Calendar;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Longs;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.seqs.SequenceFile;

public class SequenceDateFile
extends SequenceFile {
    private static final long DAY_MS = 86400000L;
    private long zone;
    private volatile long date;

    public SequenceDateFile(String filePath) {
        super(filePath);
    }

    public SequenceDateFile(int len, String filePath) {
        super(len, filePath);
    }

    public SequenceDateFile(long min, long max, String filePath) {
        super(min, max, min, filePath);
    }

    public SequenceDateFile(long min, long max, long seq, String filePath) {
        super(min, max, seq, filePath);
    }

    public SequenceDateFile(String filePath, boolean auto) {
        super(filePath, auto);
    }

    public SequenceDateFile(int len, String filePath, boolean auto) {
        super(len, filePath, auto);
    }

    public SequenceDateFile(long min, long max, String filePath, boolean auto) {
        super(min, max, filePath, auto);
    }

    public SequenceDateFile(long min, long max, long seq, String filePath, boolean auto) {
        super(min, max, seq, filePath, auto);
    }

    public String getDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.date * 86400000L);
        return DateTimes.toDateString(calendar);
    }

    @Override
    protected void init() {
        this.zone = DateTimes.toLong("1970-01-01 00:00:00");
        this.date = (System.currentTimeMillis() - this.zone) / 86400000L;
    }

    @Override
    public SequenceDateFile load() {
        String seqs = this.readFile();
        if (Validates.isEmpty(seqs)) {
            return this;
        }
        String[] daySeq = Arrays.toStringArray(seqs);
        if (daySeq.length != 2) {
            return this;
        }
        long day = Longs.toLong(Strings.trim(daySeq[0]), -1L);
        if (day != this.date) {
            return this;
        }
        String seq = Strings.trim(daySeq[1]);
        if (!Validates.isIntegerPositive(seq)) {
            return this;
        }
        this.setSequence(Longs.toLong(seq));
        return this;
    }

    @Override
    public void save() {
        String day = Strings.suffixLen(this.date, 10, ' ');
        String seq = Strings.suffixLen(this.sequence, 19, ' ');
        this.writeFile(day + "," + seq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next() {
        if (!this.isValid()) {
            throw Asserts.exception("\u521b\u5efaSequenceFile\u5931\u8d25\uff0c\u6587\u4ef6\u76ee\u5f55\u4e0d\u5b58\u5728\u4e14\u521b\u5efa\u5931\u8d25");
        }
        SequenceDateFile sequenceDateFile = this;
        synchronized (sequenceDateFile) {
            long day = (System.currentTimeMillis() - this.zone) / 86400000L;
            if (day == this.date) {
                this.chkSequence();
            } else {
                this.resetSequence();
                this.date = day;
            }
            long seq = this.sequence++;
            if (this.isAuto()) {
                this.save();
            }
            return seq;
        }
    }
}

