/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util.seqs;

import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Longs;
import org.zhiqim.kernel.util.Strings;

public class Sequence {
    private final long min;
    private final long max;
    private final int len;
    protected long sequence;

    public Sequence() {
        this(1L, Integer.MAX_VALUE, 10, 1L);
    }

    public Sequence(int len) {
        this(1L, Ints.getMaxInt(len), len, 1L);
    }

    public Sequence(long min, long max) {
        this(min, max, Longs.length(max), min);
    }

    public Sequence(long min, long max, long seq) {
        this(min, max, Longs.length(max), seq);
    }

    protected Sequence(long min, long max, int len, long seq) {
        this.min = min;
        this.max = max;
        this.len = len;
        this.sequence = seq;
        this.init();
    }

    protected void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long next() {
        Sequence sequence = this;
        synchronized (sequence) {
            this.chkSequence();
            return this.sequence++;
        }
    }

    public int nextInt() {
        return (int)this.next();
    }

    public String nextString() {
        return Strings.prefixZero(this.next(), this.len);
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public int getLen() {
        return this.len;
    }

    public long getSequence() {
        return this.sequence;
    }

    protected void chkSequence() {
        if (this.sequence <= this.min || this.sequence > this.max) {
            this.sequence = this.min;
        }
    }

    protected void resetSequence() {
        this.sequence = this.min;
    }

    protected void setSequence(long seq) {
        if (seq < this.min || seq > this.max) {
            return;
        }
        this.sequence = seq;
    }
}

