/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Longs;
import org.zhiqim.kernel.util.Stringx;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"Strings"})
public class Strings
extends Stringx
implements SignConstants,
CodeConstants {
    public static String formatPlaceholder(String pattern, String placeholder, Object ... arguments) {
        if (pattern == null || arguments == null || arguments.length == 0) {
            return pattern;
        }
        String[] segmentArr = pattern.split(placeholder);
        if (segmentArr.length <= 1) {
            return pattern;
        }
        int len = segmentArr.length;
        StringBuilder strb = new StringBuilder();
        int i = 0;
        while (i < len - 1 && i < arguments.length) {
            strb.append(segmentArr[i]).append(arguments[i]);
            ++i;
        }
        int j = i;
        while (j < len) {
            strb.append(segmentArr[j]);
            ++j;
        }
        return strb.toString();
    }

    public static String formats(String pattern, Object ... arguments) {
        if (Validates.isEmptyBlank(pattern) || arguments == null || arguments.length == 0) {
            return pattern;
        }
        if (pattern.indexOf("{}") != -1) {
            pattern = pattern.replaceAll("\\{\\}", "%s");
        }
        return String.format(pattern, arguments);
    }

    public static String formatMessage(String pattern, Object ... arguments) {
        return MessageFormat.format(pattern, arguments);
    }

    public static String formatTwo(String pattern, Object ... arguments) {
        if (Validates.isEmptyBlank(pattern) || arguments == null || arguments.length == 0) {
            return pattern;
        }
        if (pattern.indexOf("{}") != -1) {
            pattern = pattern.replaceAll("\\{\\}", "%s");
        }
        try {
            pattern = MessageFormat.format(pattern, arguments);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return String.format(pattern, arguments);
    }

    public static String formatSpace(String s) {
        s = Strings.trim(s);
        StringBuilder strb = new StringBuilder();
        int lastChar = 0;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c != ' ' || lastChar != 32) {
                strb.append(c);
                lastChar = c;
            }
            ++i;
        }
        return strb.toString();
    }

    public static String formatMessage(String message, Throwable e) {
        if (message != null) {
            return message;
        }
        if (e == null) {
            return null;
        }
        if (e.getMessage() != null) {
            return e.getMessage();
        }
        if (e.getCause() == null) {
            return e.getClass().getName();
        }
        if (e.getCause().getMessage() == null) {
            return e.getCause().getClass().getName();
        }
        return e.getCause().getMessage();
    }

    public static String newStringUTF8(byte[] data) {
        return Strings.newString(data, _UTF_8_C_);
    }

    public static String newString(byte[] data, String encoding) {
        try {
            return data == null ? null : new String(data, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String newString(byte[] data, Charset encoding) {
        return data == null ? null : new String(data, encoding);
    }

    public static byte[] getBytesUTF8(String s) {
        return s.getBytes(_UTF_8_C_);
    }

    public static byte[] getBytesGBK(String s) {
        return s.getBytes(_GBK_C_);
    }

    public static byte[] getBytesISO88591(String s) {
        try {
            return s.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String toString(Object o) {
        return o == null ? "" : String.valueOf(o);
    }

    public static String toString(Object o, String dv) {
        return o == null ? dv : String.valueOf(o);
    }

    public static boolean toBooleanWide(String s, boolean dv) {
        if (s == null) {
            return dv;
        }
        if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("1") || s.equalsIgnoreCase("on")) {
            return true;
        }
        if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("no") || s.equalsIgnoreCase("0") || s.equalsIgnoreCase("off")) {
            return false;
        }
        return dv;
    }

    public static boolean toBooleanWide(String s) {
        Asserts.notNull(s);
        if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("1") || s.equalsIgnoreCase("on")) {
            return true;
        }
        if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("no") || s.equalsIgnoreCase("0") || s.equalsIgnoreCase("off")) {
            return false;
        }
        throw Asserts.exception("\u5b57\u7b26\u4e32\u5bbd\u6cdb\u5f0f\u8f6c\u4e3a\u5e03\u5c14\u578b\u65f6\u503c\u4e0d\u5728[true|false|yes|no|1|0|on|ff]\u89c4\u8303\u5185");
    }

    public static Object toObject(Class<?> clazz, String s) {
        if (s == null) {
            return null;
        }
        if (clazz == Object.class || clazz == String.class) {
            return s;
        }
        s = s.trim();
        try {
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return Integer.valueOf(s);
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return Long.valueOf(s);
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return Short.valueOf(s);
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                return new Character(s.charAt(0));
            }
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return Byte.valueOf(s);
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return Float.valueOf(s);
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                return Double.valueOf(s);
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return Boolean.valueOf(s);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    public static byte[] toUTF8(String str) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c <= '\u007f') {
                out.write(c);
            } else if (c <= '\u07ff') {
                out.write(0xC0 | c >> 6 & 0x1F);
                out.write(0x80 | c & 0x3F);
            } else if (c <= '\uffff') {
                out.write(0xE0 | c >> 12 & 0xF);
                out.write(0x80 | c >> 6 & 0x3F);
                out.write(0x80 | c & 0x3F);
            } else {
                out.write(0xF0 | c >> 18);
                out.write(0x80 | c >> 12 & 0x3F);
                out.write(0x80 | c >> 6 & 0x3F);
                out.write(0x80 | c & 0x3F);
            }
            ++i;
        }
        return out.toByteArray();
    }

    public static String toUpperFirstChar(String str) {
        if (str == null) {
            return null;
        }
        if ((str = Strings.trim(str)).length() == 0) {
            return "";
        }
        return String.valueOf(str.substring(0, 1).toUpperCase()) + str.substring(1);
    }

    public static String indexOfString(String str, String indexOf) {
        if (str == null || indexOf == null || str.indexOf(indexOf) == -1) {
            return str;
        }
        int ind = str.indexOf(indexOf);
        return str.substring(ind + indexOf.length());
    }

    public static String lastIndexOfString(String str, String indexOf) {
        if (str == null || indexOf == null || str.lastIndexOf(indexOf) == -1) {
            return str;
        }
        int ind = str.lastIndexOf(indexOf);
        return str.substring(ind + indexOf.length());
    }

    public static int lengthUnicode(String s) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        int len = 0;
        int i = 0;
        while (i < s.length()) {
            len = s.charAt(i) > '\u007f' ? (len += 2) : ++len;
            ++i;
        }
        return len;
    }

    public static int lengthUnicodeRemain(String s, int maxLength) {
        return maxLength - Strings.lengthUnicode(s);
    }

    public static int lengthUnicode35(String s) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        int len = 0;
        int i = 0;
        while (i < s.length()) {
            len = s.charAt(i) > '\u007f' ? (len += 5) : (len += 3);
            ++i;
        }
        return len;
    }

    public static String substringLen(String str, int len) {
        if (Validates.isEmpty(str)) {
            return "";
        }
        len *= 5;
        int length = 0;
        int ind = 0;
        int i = 0;
        while (i < str.length()) {
            length = str.charAt(i) > '\u007f' ? (length += 5) : (length += 3);
            ind = i + 1;
            if (length >= len) break;
            ++i;
        }
        str = ind < str.length() ? String.valueOf(str.substring(0, ind - 1)) + "..." : str.substring(0, ind);
        return str;
    }

    public static boolean startsWith(String s, String ... prefixs) {
        if (prefixs == null) {
            return true;
        }
        if (s == null) {
            return false;
        }
        String[] stringArray = prefixs;
        int n = prefixs.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (Strings.startsWith(s, prefix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean endsWith(String s, String ... suffixs) {
        if (suffixs == null) {
            return true;
        }
        if (s == null) {
            return false;
        }
        String[] stringArray = suffixs;
        int n = suffixs.length;
        int n2 = 0;
        while (n2 < n) {
            String suffix = stringArray[n2];
            if (Strings.endsWith(s, suffix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean startsWithIgnoreCase(String s, String prefix) {
        if (prefix == null) {
            return true;
        }
        if (s == null || s.length() < prefix.length()) {
            return false;
        }
        return s.toLowerCase().startsWith(prefix.toLowerCase());
    }

    public static boolean endsWithIgnoreCase(String s, String suffix) {
        if (suffix == null) {
            return true;
        }
        if (s == null || s.length() < suffix.length()) {
            return false;
        }
        return s.toLowerCase().endsWith(suffix.toLowerCase());
    }

    public static String suffixLen(String value, int len, char suffix) {
        StringBuilder strb = new StringBuilder(value);
        int i = 0;
        while (i < len) {
            strb.append(suffix);
            ++i;
        }
        return strb.substring(0, len);
    }

    public static String suffixLen(int value, int len, char suffix) {
        StringBuilder strb = new StringBuilder(20).append(value);
        int i = 0;
        while (i < len) {
            strb.append(suffix);
            ++i;
        }
        return strb.substring(0, len);
    }

    public static String suffixLen(long value, int len, char suffix) {
        StringBuilder strb = new StringBuilder(38).append(value);
        int i = 0;
        while (i < len) {
            strb.append(suffix);
            ++i;
        }
        return strb.substring(0, len);
    }

    public static int suffixInt(String str) {
        StringBuilder strb = new StringBuilder();
        int i = str.length() - 1;
        while (i >= 0) {
            char c = str.charAt(i);
            if (c < '0' || c > '9') break;
            strb.append(c);
            --i;
        }
        if (strb.length() == 0) {
            return 0;
        }
        return Ints.toInt(strb.toString());
    }

    public static String prefixZero(String str, int len) {
        return Strings.prefixLen(str, len, '0');
    }

    public static String prefixLen(String value, int len, char prefix) {
        int vlen = value.length();
        if (vlen == len) {
            return value;
        }
        if (vlen > len) {
            return value.substring(vlen - len);
        }
        StringBuilder strb = new StringBuilder(len);
        int i = vlen;
        while (i < len) {
            strb.append(prefix);
            ++i;
        }
        return strb.append(value).toString();
    }

    public static String prefixZeroOne(int value, int lte) {
        return value <= lte ? "0" + value : Integer.toString(value);
    }

    public static String prefixZero(int value, int len) {
        return Strings.prefixLen(value, len, '0');
    }

    public static String prefixLen(int value, int len, char prefix) {
        int vlen = Ints.length(value);
        if (vlen == len) {
            return Integer.toString(value);
        }
        StringBuilder strb = new StringBuilder();
        if (vlen < len) {
            int i = vlen;
            while (i < len) {
                strb.append(prefix);
                ++i;
            }
        }
        return strb.append(value).substring(strb.length() - len);
    }

    public static String prefixZero(long value, int len) {
        return Strings.prefixLen(value, len, '0');
    }

    public static String prefixLen(long value, int len, char prefix) {
        int vlen = Longs.length(value);
        if (vlen == len) {
            return Long.toString(value);
        }
        StringBuilder strb = new StringBuilder();
        if (vlen < len) {
            int i = vlen;
            while (i < len) {
                strb.append(prefix);
                ++i;
            }
        }
        return strb.append(value).substring(strb.length() - len);
    }

    public static int prefixInt(String str) {
        boolean isNon;
        boolean bl = isNon = '-' == str.charAt(0);
        if (isNon) {
            str = str.substring(1);
        }
        StringBuilder strb = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c < '0' || c > '9') break;
            strb.append(c);
            ++i;
        }
        if (strb.length() == 0) {
            return 0;
        }
        int num = Ints.toInt(strb.toString());
        return isNon ? -num : num;
    }

    public static float prefixFloat(String str) {
        int ind2;
        boolean isNon;
        boolean bl = isNon = '-' == str.charAt(0);
        if (isNon) {
            str = str.substring(1);
        }
        StringBuilder strb = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if ((c < '0' || c > '9') && c != '.') break;
            strb.append(c);
            ++i;
        }
        if (strb.length() == 0) {
            return 0.0f;
        }
        String prefix = strb.toString();
        int ind = prefix.indexOf(".");
        if (ind != -1 && (ind2 = prefix.indexOf(".", ind + 1)) != -1) {
            prefix = prefix.substring(0, ind2);
        }
        float num = Float.parseFloat(prefix);
        return isNon ? -num : num;
    }

    public static int getTimes(String src, char c) {
        int times = 0;
        int i = 0;
        while (i < src.length()) {
            if (c == src.charAt(i)) {
                ++times;
            }
            ++i;
        }
        return times;
    }

    public static int getTimesIgnoreFirstLast(String src, char c) {
        int times = 0;
        int i = 1;
        while (i < src.length() - 1) {
            if (c == src.charAt(i)) {
                ++times;
            }
            ++i;
        }
        return times;
    }

    public static int getTimes(String src, String str) {
        int timelen;
        int times = 0;
        if (src == null || str == null) {
            return times;
        }
        int len = src.length();
        if (len < (timelen = str.length())) {
            return times;
        }
        int ind;
        while ((ind = src.indexOf(str)) != -1) {
            ++times;
            src = src.substring(ind + timelen);
        }
        return times;
    }

    public static int getStartsWithBrNum(String content) {
        if (content.startsWith("\r\n")) {
            return 2;
        }
        if (content.startsWith("\r") || content.startsWith("\n")) {
            return 1;
        }
        return 0;
    }

    public static int getMessyCodeNum(String s) {
        if (Strings.isEmpty(s)) {
            return 0;
        }
        int num = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\ufffd') {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public static String trim(String s, String defaultValue) {
        return s == null ? defaultValue : Strings.trim(s);
    }

    public static String trimEmpty(String s, String defaultValue) {
        return s == null || s.isEmpty() ? defaultValue : Strings.trim(s);
    }

    public static String trimEmptyBlank(String s, String defaultValue) {
        return Validates.isEmptyBlank(s) ? defaultValue : Strings.trim(s);
    }

    public static String trimLeft(String s) {
        if (Validates.isEmpty(s)) {
            return s;
        }
        int len = s.length();
        int i = 0;
        while (i < len && Validates.isWhitespace(s.charAt(i))) {
            ++i;
        }
        return i > 0 ? s.substring(i) : s;
    }

    public static String trimLeftOneBR(String s) {
        if (Validates.isEmpty(s)) {
            return s;
        }
        char c = s.charAt(0);
        if (c != '\n' && c != '\r') {
            return s;
        }
        if (c == '\n') {
            return s.substring(1);
        }
        if (s.length() > 1 && s.charAt(1) == '\n') {
            return s.substring(2);
        }
        return s.substring(1);
    }

    public static String trimRight(String s) {
        if (Validates.isEmpty(s)) {
            return s;
        }
        int len = s.length();
        int i = len - 1;
        while (i > 0 && Validates.isWhitespace(s.charAt(i))) {
            --i;
        }
        return i < len - 1 ? s.substring(0, i + 1) : s;
    }

    public static String trimRight(String s, char c) {
        if (Validates.isEmpty(s)) {
            return s;
        }
        int len = s.length();
        int i = len - 1;
        while (i > 0 && s.charAt(i) == c) {
            --i;
        }
        return i < len - 1 ? s.substring(0, i + 1) : s;
    }

    public static String trim(String s, String prefix, String suffix) {
        if (Validates.isEmpty(s)) {
            return s;
        }
        if (!Validates.isEmpty(prefix) && s.startsWith(prefix)) {
            s = s.substring(prefix.length());
        }
        if (!Validates.isEmpty(suffix) && s.endsWith(suffix)) {
            s = s.substring(0, s.length() - suffix.length());
        }
        return s;
    }

    public static String trimLeft(String s, String prefix) {
        if (Validates.isEmpty(s) || Validates.isEmpty(prefix)) {
            return s;
        }
        if (!s.startsWith(prefix)) {
            return s;
        }
        return s.substring(prefix.length());
    }

    public static String trimRight(String s, String suffix) {
        if (Validates.isEmpty(s) || Validates.isEmpty(suffix)) {
            return s;
        }
        if (!s.endsWith(suffix)) {
            return s;
        }
        return s.substring(0, s.length() - suffix.length());
    }

    public static void trimRight(StringBuilder strb, String suffix) {
        if (strb == null || Validates.isEmpty(suffix) || strb.length() < suffix.length()) {
            return;
        }
        String end = strb.substring(strb.length() - suffix.length());
        if (suffix.equals(end)) {
            strb.setLength(strb.length() - suffix.length());
        }
    }

    public static String removeBag(String s, String bag) {
        if (Validates.isEmpty(s) || Validates.isEmpty(bag)) {
            return s;
        }
        StringBuilder strb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (bag.indexOf(c) <= -1) {
                strb.append(c);
            }
            ++i;
        }
        return strb.toString();
    }

    public static String removeBagNot(String s, String bag) {
        if (Validates.isEmpty(s)) {
            return s;
        }
        if (Validates.isEmpty(bag)) {
            return "";
        }
        StringBuilder strb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (bag.indexOf(c) != -1) {
                strb.append(c);
            }
            ++i;
        }
        return strb.toString();
    }

    public static String removeAllBlank(String s) {
        if (Validates.isEmpty(s)) {
            return s;
        }
        StringBuilder strb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (!Validates.isWhitespace(c)) {
                strb.append(c);
            }
            ++i;
        }
        return strb.toString();
    }

    public static String removeLeftByFirst(String s, String separator) {
        if (Validates.isEmptyBlank(s)) {
            return "";
        }
        int pos = (s = s.trim()).indexOf(separator);
        if (pos == -1) {
            return s;
        }
        return s.substring(pos + separator.length());
    }

    public static String removeLeftByLast(String s, String separator) {
        if (Validates.isEmptyBlank(s)) {
            return "";
        }
        int pos = (s = s.trim()).lastIndexOf(separator);
        if (pos == -1) {
            return s;
        }
        return s.substring(pos + separator.length());
    }

    public static String removeRightByFirst(String s, String separator) {
        if (Validates.isEmptyBlank(s)) {
            return "";
        }
        int pos = (s = s.trim()).indexOf(separator);
        if (pos == -1) {
            return s;
        }
        if (pos < 1) {
            return "";
        }
        return s.substring(0, pos);
    }

    public static String removeRightByLast(String s, String separator) {
        if (Validates.isEmptyBlank(s)) {
            return "";
        }
        int pos = (s = s.trim()).lastIndexOf(separator);
        if (pos == -1) {
            return s;
        }
        if (pos < 1) {
            return "";
        }
        return s.substring(0, pos);
    }

    public static String removeRightMaybeEmptyBlank(String s) {
        if (Validates.isEmptyBlank(s)) {
            return "";
        }
        int index = -1;
        int i = s.length() - 1;
        while (i >= 0) {
            char c = s.charAt(i);
            if (c == '\n' || c == '\r') {
                index = i;
                break;
            }
            if (!Validates.isWhitespace(c)) break;
            --i;
        }
        return index == -1 ? s : s.substring(0, index + 1);
    }

    public static void removeRightMaybeEmptyBlank(StringBuilder strb) {
        int index = -1;
        boolean allEmptyBlank = true;
        int i = strb.length() - 1;
        while (i >= 0) {
            char c = strb.charAt(i);
            if (c == '\n' || c == '\r') {
                index = i;
                allEmptyBlank = false;
                break;
            }
            if (!Validates.isWhitespace(c)) {
                allEmptyBlank = false;
                break;
            }
            --i;
        }
        if (allEmptyBlank) {
            strb.setLength(0);
        } else if (index != -1) {
            strb.setLength(index + 1);
        }
    }

    public static String removeRightMaybeEmptyBlankLine(String s) {
        if (Validates.isEmptyBlank(s)) {
            return "";
        }
        int index = -1;
        int i = s.length() - 1;
        while (i >= 0) {
            char c = s.charAt(i);
            if (c == '\n') {
                if (i > 0 && s.charAt(i - 1) == '\r') {
                    index = i - 1;
                    break;
                }
                index = i;
                break;
            }
            if (c == '\r') {
                index = i;
                break;
            }
            if (!Validates.isWhitespace(c)) break;
            --i;
        }
        return index == -1 ? s : s.substring(0, index);
    }

    public static void removeRightMaybeEmptyBlankLine(StringBuilder strb) {
        int index = -1;
        int i = strb.length() - 1;
        while (i >= 0) {
            char c = strb.charAt(i);
            if (c == '\n') {
                if (i > 0 && strb.charAt(i - 1) == '\r') {
                    index = i - 1;
                    break;
                }
                index = i;
                break;
            }
            if (c == '\r') {
                index = i;
                break;
            }
            if (!Validates.isWhitespace(c)) break;
            --i;
        }
        if (index != -1) {
            strb.setLength(index);
        }
    }

    public static String removeStartsWith(String s, String startsWith) {
        return Strings.trimLeft(s, startsWith);
    }

    public static String removeEndsWith(String s, String endsWith) {
        return Strings.trimRight(s, endsWith);
    }

    public static void removeEndsWith(StringBuilder strb, String endsWith) {
        Strings.trimRight(strb, endsWith);
    }

    public static String addStartsWith(String s, String startsWith) {
        if (s == null) {
            return startsWith;
        }
        if (Validates.isEmpty(startsWith)) {
            return s;
        }
        if (s.startsWith(startsWith)) {
            return s;
        }
        return String.valueOf(startsWith) + s;
    }

    public static String addEndsWith(String s, String endsWith) {
        if (s == null) {
            return endsWith;
        }
        if (Validates.isEmpty(endsWith)) {
            return s;
        }
        if (s.endsWith(endsWith)) {
            return s;
        }
        return String.valueOf(s) + endsWith;
    }

    public static StringBuilder addNewLine(StringBuilder strb) {
        return strb.append("\r\n");
    }

    public static StringBuffer addNewLine(StringBuffer strb) {
        return strb.append("\r\n");
    }

    public static StringBuilder addTwoSpace(StringBuilder strb, int num) {
        int i = 0;
        while (i < num) {
            strb.append("  ");
            ++i;
        }
        return strb;
    }

    public static StringBuffer addTwoSpace(StringBuffer strb, int num) {
        int i = 0;
        while (i < num) {
            strb.append("  ");
            ++i;
        }
        return strb;
    }

    public static StringBuilder addFourSpace(StringBuilder strb, int num) {
        int i = 0;
        while (i < num) {
            strb.append("    ");
            ++i;
        }
        return strb;
    }

    public static StringBuffer addFourSpace(StringBuffer strb, int num) {
        int i = 0;
        while (i < num) {
            strb.append("    ");
            ++i;
        }
        return strb;
    }

    public static StringBuilder addTab(StringBuilder strb, int num) {
        int i = 0;
        while (i < num) {
            strb.append("\t");
            ++i;
        }
        return strb;
    }

    public static StringBuffer addTab(StringBuffer strb, int num) {
        int i = 0;
        while (i < num) {
            strb.append("\t");
            ++i;
        }
        return strb;
    }
}

