/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.control.Filter;
import org.zhiqim.kernel.control.FilterHandler;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Jars;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Systems;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"Resources"})
public class Resources
implements CodeConstants {
    public static boolean scanClassPath(Filter filter, FilterHandler handler) {
        return Resources.scanClassPath(filter, handler, Lists.toList(Systems.getClassPaths()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean scanClassPath(Filter filter, FilterHandler handler, List<String> pathList) {
        for (String path : pathList) {
            File file = new File(path);
            if (!Files.exists(file) || !file.canRead() || !file.isFile() && !file.isDirectory()) continue;
            if (file.isDirectory()) {
                try {
                    ArrayList<File> fileList = new ArrayList<File>();
                    Files.queryFilterList(fileList, file, filter);
                    for (File classFile : fileList) {
                        if (handler.handle(new Object[]{file, classFile})) continue;
                        return false;
                    }
                }
                catch (Throwable throwable) {}
                continue;
            }
            if (!file.isFile() || !Strings.endsWithIgnoreCase(path, ".jar") && !Strings.endsWithIgnoreCase(path, ".zip")) continue;
            try {
                JarFile jarFile = new JarFile(path);
                List<JarEntry> entryList = Jars.queryEndsWithList(jarFile, filter);
                for (JarEntry jarEntry : entryList) {
                    if (handler.handle(new Object[]{jarFile, jarEntry})) continue;
                    return false;
                }
            }
            catch (Throwable throwable) {}
        }
        return true;
    }

    public static boolean exists(String path) {
        path = Strings.removeStartsWith(path, "/");
        return Thread.currentThread().getContextClassLoader().getResource(path) != null;
    }

    public static boolean exists(Class<?> clazz, String path) {
        return Resources.exists(path) ? true : clazz.getResource(path) != null;
    }

    public static URL getResource(String path) {
        path = Strings.removeStartsWith(path, "/");
        return Thread.currentThread().getContextClassLoader().getResource(path);
    }

    public static URL getResource(Class<?> clazz, String path) {
        URL url = clazz.getResource(path);
        return url != null ? url : Resources.getResource(path);
    }

    public static InputStream getResourceStream(String path) {
        path = Strings.removeStartsWith(path, "/");
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
    }

    public static InputStream getResourceStream(Class<?> clazz, String path) {
        InputStream in = clazz.getResourceAsStream(path);
        return in != null ? in : Resources.getResourceStream(path);
    }

    public static String getResourceStringUTF8(String path) throws IOException {
        return Resources.getResourceString(path, "UTF-8");
    }

    public static String getResourceStringUTF8(Class<?> clazz, String path) throws IOException {
        return Resources.getResourceString(clazz, path, "UTF-8");
    }

    public static String getResourceString(String path, String encoding) throws IOException {
        if (Validates.isEmpty(path) || Validates.isEmpty(encoding)) {
            return null;
        }
        try {
            return new String(Streams.getBytesClassPath(path), encoding);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getResourceString(Class<?> clazz, String path, String encoding) {
        if (Validates.isEmpty(path) || Validates.isEmpty(encoding)) {
            return null;
        }
        try {
            return new String(Streams.getBytesClassPath(clazz, path), encoding);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static List<String> getResourceFileNameList(Class<?> clazz, String path) throws IOException {
        return Resources.getResourceNameList(clazz, path, 1);
    }

    public static List<String> getResourceFolderNameList(Class<?> clazz, String path) throws IOException {
        List<String> folderList = Resources.getResourceNameList(clazz, path, 2);
        int i = 0;
        while (i < folderList.size()) {
            folderList.set(i, Strings.trimRight(folderList.get(i), "/"));
            ++i;
        }
        return folderList;
    }

    public static List<String> getResourceNameList(Class<?> clazz, String path) throws IOException {
        return Resources.getResourceNameList(clazz, path, 0);
    }

    public static List<String> getResourceNameList(Class<?> clazz, String path, int type) throws IOException {
        path = Strings.removeStartsWith(path, "/");
        path = Strings.addEndsWith(path, "/");
        ArrayList<File> fileDirList = new ArrayList<File>();
        ArrayList<JarFile> jarDirList = new ArrayList<JarFile>();
        Enumeration<URL> resources = clazz.getClassLoader().getResources(path);
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            if ("file".equals(resource.getProtocol())) {
                fileDirList.add(new File(resource.getFile()));
                continue;
            }
            if ("jar".equals(resource.getProtocol())) {
                String string = resource.getPath();
                int ind = string.indexOf("!");
                if (ind == -1) continue;
                String string3 = string.substring(0, ind);
                string3 = Strings.removeStartsWith(string3, "file:");
                jarDirList.add(new JarFile(string3));
                continue;
            }
            if (!"bundleresource".equals(resource.getProtocol())) continue;
            try {
                Class<?> clazz2 = Classes.forName("org.eclipse.core.runtime.FileLocator");
                Method m = clazz2.getDeclaredMethod("toFileURL", URL.class);
                resource = (URL)m.invoke(null, resource);
                fileDirList.add(new File(resource.getPath()));
            }
            catch (Exception exception) {}
        }
        ArrayList<String> fileNameList = new ArrayList<String>();
        for (File file : fileDirList) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray[n2];
                if (file2.isFile() || file2.canRead()) {
                    fileNameList.add(file2.getName());
                }
                ++n2;
            }
        }
        for (JarFile jarFile : jarDirList) {
            Enumeration<JarEntry> enumeration = jarFile.entries();
            block11: while (enumeration.hasMoreElements()) {
                JarEntry entry = enumeration.nextElement();
                String name = entry.getName();
                if (!name.startsWith(path) || "".equals(name = Strings.removeStartsWith(name, path))) continue;
                switch (type) {
                    case 0: {
                        if (name.indexOf("/") == -1) {
                            fileNameList.add(name);
                            break;
                        }
                        if (Strings.getTimes(name, '/') != 1 || !Strings.endsWith(name, "/")) continue block11;
                        fileNameList.add(name);
                        break;
                    }
                    case 1: {
                        if (name.indexOf("/") != -1) break;
                        fileNameList.add(name);
                        break;
                    }
                    case 2: {
                        if (Strings.getTimes(name, '/') != 1 || !Strings.endsWith(name, "/")) continue block11;
                        fileNameList.add(name);
                    }
                }
            }
        }
        return fileNameList;
    }

    public static void buildStaticProperties(Class<?> clazz) {
        Resources.buildStaticProperties(clazz, clazz.getName());
    }

    public static void buildStaticProperties(Class<?> clazz, String propertiesPath) {
        ResourceBundle bundle = ResourceBundle.getBundle(propertiesPath, Locale.getDefault(), Global.getClassLoader());
        for (String name : bundle.keySet()) {
            Field field = Classes.getField(clazz, name);
            if (field == null) continue;
            Classes.setFieldValue(null, field, bundle.getString(name));
        }
    }

    public static <T> T buildProperties(Class<T> clazz) {
        return Resources.buildProperties(clazz, clazz.getName());
    }

    public static <T> T buildProperties(Class<T> cls, String propertiesPath) {
        ResourceBundle bundle = ResourceBundle.getBundle(propertiesPath, Locale.getDefault(), Global.getClassLoader());
        T obj = Classes.newInstance(cls);
        for (String name : bundle.keySet()) {
            Field field = Classes.getField(cls, name);
            if (field == null) continue;
            Classes.setFieldValue(obj, field, bundle.getString(name));
        }
        return obj;
    }
}

