/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNullable;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Listx;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"Lists"})
public class Lists
extends Listx
implements SignConstants {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <E> List<E> copy(List<E> list, boolean sync) {
        if (sync) {
            List<E> list2 = list;
            synchronized (list2) {
                ArrayList<E> newList = new ArrayList<E>();
                for (E item : list) {
                    newList.add(item);
                }
                return newList;
            }
        }
        ArrayList<E> newList = new ArrayList<E>();
        for (E item : list) {
            newList.add(item);
        }
        return newList;
    }

    public static final <E> List<E> copy(List<E> list, int n) {
        ArrayList<E> newList = new ArrayList<E>();
        int i = 0;
        while (i < n) {
            newList.add(list.get(i));
            ++i;
        }
        return newList;
    }

    public static final <E> List<E> copySet(List<E> list, int index, E element) {
        ArrayList<E> newList = new ArrayList<E>(list);
        newList.set(index, element);
        return newList;
    }

    public static final <E> List<E> copyAdd(List<E> list, E element) {
        ArrayList<E> newList = new ArrayList<E>(list);
        newList.add(element);
        return newList;
    }

    public static final <E> List<E> copyAdd(List<E> list, int index, E element) {
        ArrayList<E> newList = new ArrayList<E>(list);
        newList.add(index, element);
        return newList;
    }

    public static final <E> List<E> copyRemove(List<E> list, int index) {
        ArrayList<E> newList = new ArrayList<E>(list);
        newList.remove(index);
        return newList;
    }

    public static <T> ArrayList<T> trim(ArrayList<T> list) {
        list.trimToSize();
        return list;
    }

    public static <T> List<T> trim(List<T> list) {
        if (!(list instanceof ArrayList)) {
            return list;
        }
        ((ArrayList)list).trimToSize();
        return list;
    }

    public static <T> List<T> sort(List<T> list, Comparator<T> comparator) {
        if (!list.isEmpty()) {
            Collections.sort(list, comparator);
        }
        return list;
    }

    public static <T> ArrayList<T> sort(ArrayList<T> list, Comparator<T> comparator) {
        if (!list.isEmpty()) {
            Collections.sort(list, comparator);
        }
        return list;
    }

    public static <T> ArrayList<T> sortAndTrim(ArrayList<T> list, Comparator<T> comparator) {
        if (!list.isEmpty()) {
            Collections.sort(list, comparator);
        }
        list.trimToSize();
        return list;
    }

    public static <T> List<T> toList(T[] arr) {
        if (arr == null) {
            return new ArrayList();
        }
        ArrayList<T> list = new ArrayList<T>(arr.length);
        T[] TArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            T elem = TArray[n2];
            list.add(elem);
            ++n2;
        }
        return list;
    }

    public static List<Integer> toList(int[] arr) {
        return Lists.toList(Arrays.convert(arr));
    }

    public static List<Long> toList(long[] arr) {
        return Lists.toList(Arrays.convert(arr));
    }

    public static List<Byte> toList(byte[] arr) {
        return Lists.toList(Arrays.convert(arr));
    }

    public static List<Short> toList(short[] arr) {
        return Lists.toList(Arrays.convert(arr));
    }

    public static List<Character> toList(char[] arr) {
        return Lists.toList(Arrays.convert(arr));
    }

    public static List<Boolean> toList(boolean[] arr) {
        return Lists.toList(Arrays.convert(arr));
    }

    public static List<Float> toList(float[] arr) {
        return Lists.toList(Arrays.convert(arr));
    }

    public static List<Double> toList(double[] arr) {
        return Lists.toList(Arrays.convert(arr));
    }

    public static List<String> toStringList(String strs) {
        return Lists.toStringList(strs, ",");
    }

    public static List<String> toStringList(String strs, String separator) {
        if (Validates.isEmpty(strs)) {
            return new ArrayList<String>();
        }
        ArrayList<String> strList = new ArrayList<String>();
        String[] array = strs.split(separator);
        int i = 0;
        while (i < array.length) {
            strList.add(array[i].trim());
            ++i;
        }
        strList.trimToSize();
        return strList;
    }

    public static List<Integer> toIntList(String strs) {
        return Lists.toIntList(strs, ",");
    }

    public static List<Integer> toIntList(String strs, String separator) {
        List<String> strList = Lists.toStringList(strs, separator);
        return Lists.toIntList(strList);
    }

    public static List<Integer> toIntList(List<String> strList) {
        ArrayList<Integer> intList = new ArrayList<Integer>(strList.size());
        for (String str : strList) {
            intList.add(Integer.parseInt(str.trim()));
        }
        return intList;
    }

    public static List<Long> toLongList(String strs) {
        return Lists.toLongList(strs, ",");
    }

    public static List<Long> toLongList(String strs, String separator) {
        List<String> strList = Lists.toStringList(strs, separator);
        return Lists.toLongList(strList);
    }

    public static List<Long> toLongList(List<String> strList) {
        ArrayList<Long> longList = new ArrayList<Long>();
        for (String str : strList) {
            longList.add(Long.parseLong(str.trim()));
        }
        return longList;
    }

    public static String toString(List<?> list) {
        return Lists.toString(list, ",");
    }

    public static String toString(List<?> list, String separator) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuilder strb = new StringBuilder().append(list.get(0));
        int i = 1;
        while (i < list.size()) {
            strb.append(separator).append(list.get(i));
            ++i;
        }
        return strb.toString();
    }

    public static <T> void fill(List<T> list, int toIndex, T elem) {
        while (list.size() < toIndex) {
            list.add(elem);
        }
    }

    public static <T> ArrayList<T> reverse(ArrayList<T> oldList) {
        ArrayList<T> newList = new ArrayList<T>(oldList.size());
        int i = oldList.size() - 1;
        while (i >= 0) {
            newList.add(oldList.get(i));
            --i;
        }
        newList.trimToSize();
        return newList;
    }

    public static boolean contains(Collection<?> list, String field, Object equalValue) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (field == null) {
            return list.contains(equalValue);
        }
        for (Object obj : list) {
            Object v;
            Field f;
            if (obj == null || (f = Classes.getFieldDeep(obj.getClass(), field)) == null || !Validates.isEqual(equalValue, v = Classes.getFieldValue(obj, f))) continue;
            return true;
        }
        return false;
    }

    public static <T> T get(Collection<T> list, String field, Object equalValue) {
        if (list == null || list.isEmpty() || equalValue == null) {
            return null;
        }
        for (T obj : list) {
            Object v;
            Field f;
            if (obj == null || !(field == null ? Validates.isEqual(equalValue, obj) : (f = Classes.getFieldDeep(obj.getClass(), field)) != null && Validates.isEqual(equalValue, v = Classes.getFieldValue(obj, f)))) continue;
            return obj;
        }
        return null;
    }

    @AnNullable
    public static List<String> getMatchList(String s, String pattern) {
        if (s == null || pattern == null) {
            return null;
        }
        int ind = pattern.indexOf("*");
        if (ind == -1) {
            return s.equals(pattern) ? new ArrayList() : null;
        }
        ArrayList<String> matchList = new ArrayList<String>();
        while (s.length() > ind) {
            String match;
            if (ind > 0) {
                String match2 = pattern.substring(0, ind);
                if (!s.startsWith(match2)) {
                    return null;
                }
                pattern = pattern.substring(ind);
                s = s.substring(ind);
            }
            if (Validates.isEmpty(pattern = pattern.substring(1))) {
                matchList.add(s);
                matchList.trimToSize();
                return matchList;
            }
            String temp = s.substring(0, 1);
            s = s.substring(1);
            ind = pattern.indexOf("*");
            if (ind == -1) {
                if (!s.endsWith(pattern)) {
                    return null;
                }
                match = String.valueOf(temp) + Strings.trimRight(s, pattern);
                matchList.add(match);
                matchList.trimToSize();
                return matchList;
            }
            match = pattern.substring(0, ind);
            int aInd = s.indexOf(match);
            if (aInd == -1) {
                return null;
            }
            if (aInd == 0) {
                matchList.add(temp);
                continue;
            }
            matchList.add(String.valueOf(temp) + s.substring(0, aInd));
            s = s.substring(aInd);
        }
        return null;
    }
}

