/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.transaction;

import java.util.List;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.transaction.Transaction;
import org.zhiqim.kernel.transaction.TransactionAbstracter;
import org.zhiqim.kernel.util.Arrays;

public class TransactionLister
extends TransactionAbstracter {
    private static final Log log = LogFactory.getLog(TransactionLister.class);
    private List<Transaction> txList = null;

    public TransactionLister(String[] ids, List<Transaction> txList) {
        super(Arrays.toString(ids));
        this.txList = txList;
    }

    public List<Transaction> getTransactionList() {
        return this.txList;
    }

    @Override
    public Transaction begin() throws Exception {
        for (Transaction tx : this.txList) {
            tx.begin();
        }
        return this;
    }

    @Override
    public void commit() throws Exception {
        for (Transaction tx : this.txList) {
            tx.commit();
        }
        super.setCommitted();
    }

    @Override
    public void rollback() throws Exception {
        for (Transaction tx : this.txList) {
            try {
                tx.rollback();
            }
            catch (Exception e) {
                log.error(e);
            }
        }
        super.setRollbacked();
    }

    @Override
    public void close() throws Exception {
        for (Transaction tx : this.txList) {
            try {
                tx.close();
            }
            catch (Exception e) {
                log.error(e);
            }
        }
        super.setClosed();
    }
}

