/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.logging.appender;

import org.zhiqim.kernel.logging.appender.FileAppender;
import org.zhiqim.kernel.util.Files;

public class FileSizeAppender
extends FileAppender {
    private final Object lock = new Object();

    @Override
    public void setFilePath(String filePath) {
        super.setFilePath(filePath);
        this.doCreateWriter();
    }

    @Override
    public void append(int level, String message, Throwable throwable) {
        if (super.getFileSize() >= (long)this.fileMaxSize) {
            this.doConvertWriter();
        }
        this.print(level, message, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCreateWriter() {
        Object object = this.lock;
        synchronized (object) {
            if (super.getWriter() != null) {
                return;
            }
            if (super.getFileSize() >= (long)this.fileMaxSize) {
                Files.removeMaxFileAndRenameFile(this.fileDir, this.fileName, this.fileMaxNum, true);
            }
            super.createWriter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConvertWriter() {
        Object object = this.lock;
        synchronized (object) {
            if (super.getFileSize() < (long)this.fileMaxSize) {
                return;
            }
            super.closeWriter();
            Files.removeMaxFileAndRenameFile(this.fileDir, this.fileName, this.fileMaxNum, true);
            super.createWriter();
        }
    }
}

