/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.httpclient;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.httpclient.HttpClient;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Bytes;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Urls;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.codes.MD5;

public class HttpRMI
extends HttpClient {
    private String key;
    private String secret;
    private String className;
    private String methodName;
    private String serviceId;
    private List<String> params;
    private MapSO paramMap;
    private String queryString;
    private String redirect;
    private String error;

    public HttpRMI(String url) {
        super(url, "POST");
    }

    public void setKeySecret(String key, String secret) {
        this.key = key;
        this.secret = secret;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = Strings.trim(serviceId);
    }

    public void addParam(Object param) {
        Asserts.as(param != null ? null : "\u4e0d\u652f\u6301\u6309\u503c\u65b9\u5f0f\u4f20\u5165null\u503c");
        if (this.params == null) {
            this.params = new ArrayList<String>();
        }
        this.params.add(String.valueOf(param));
    }

    public void addParam(String name, Object value) {
        if (value == null) {
            return;
        }
        if (this.paramMap == null) {
            this.paramMap = new HashMapSO(3);
        }
        this.paramMap.put(name, value);
    }

    public String getRedirect() {
        return this.redirect;
    }

    public String getError() {
        return this.error;
    }

    @Override
    protected boolean doPreRequestProperty() {
        if (Validates.isEmptyBlank(this.serviceId) && Validates.isEmptyBlank(this.className) || Validates.isEmptyBlank(this.methodName) || Validates.isEmptyBlank(this.key) || Validates.isEmptyBlank(this.secret)) {
            this.responseStatus = 72;
            this.responseText = "\u5fc5\u987b\u7684\u53c2\u6570\u672a\u6ee1\u8db3";
            return false;
        }
        String clazz = Strings.trim(this.className, "");
        String service = Strings.trim(this.serviceId, "");
        String timestamp = DateTimes.getDateTimeString();
        String authorization = MD5.encodeUTF8(String.valueOf(this.key) + timestamp + clazz + this.methodName + service + this.secret);
        this.addRequestProperty("X-RMI-Key", this.key);
        this.addRequestProperty("X-RMI-Class", clazz);
        this.addRequestProperty("X-RMI-Method", this.methodName);
        this.addRequestProperty("X-RMI-Service", service);
        this.addRequestProperty("X-RMI-Timestamp", timestamp);
        this.addRequestProperty("X-RMI-Authorization", authorization);
        if (this.paramMap != null) {
            this.queryString = Urls.toQueryString(this.paramMap);
            this.addRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        } else if (this.params != null) {
            StringBuilder strb = new StringBuilder();
            for (String param : this.params) {
                if (param.indexOf(35) != -1) {
                    param = param.replaceAll("#", "-%2-%-3%-");
                }
                strb.append("%23").append(Urls.encodeUTF8(param)).append("%23");
            }
            this.queryString = strb.toString();
            this.addRequestProperty("Content-Type", "text/plain; charset=UTF-8");
        }
        if (Validates.isNotEmpty(this.queryString)) {
            this.setDoOutput(true);
            this.addRequestProperty("Content-Length", Bytes.getByteLen(this.queryString, "UTF-8"));
        } else {
            this.addRequestProperty("Content-Type", "text/plain; charset=UTF-8");
        }
        return true;
    }

    @Override
    protected void doWriteRequestContent(HttpURLConnection conn) throws IOException {
        if (Validates.isEmpty(this.queryString)) {
            return;
        }
        conn.getOutputStream().write(this.queryString.getBytes("UTF-8"));
    }

    @Override
    protected void doReadResponseContent(HttpURLConnection conn) throws IOException {
        if (this.responseStatus == 302) {
            this.responseText = conn.getHeaderField("Location");
            return;
        }
        String charset = this.getResponseCharset();
        if (this.responseStatus != 200 && this.responseStatus != 601 && this.responseStatus != 602 && this.responseStatus != 603) {
            this.responseText = Urls.decode(conn.getResponseMessage(), charset);
            if (Validates.isEmpty(this.responseText)) {
                this.responseText = "\u8c03\u7528\u670d\u52a1\u7aef\u63a5\u53e3\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a" + this.responseStatus;
            }
            return;
        }
        this.responseText = HttpRMI.getResponseAsString(conn);
        if (this.responseStatus == 601 || this.responseStatus == 602 || this.responseStatus == 603) {
            if (this.responseText == null) {
                this.responseText = "\u8c03\u7528\u670d\u52a1\u7aef\u63a5\u53e3\u5931\u8d25\uff0c\u8981\u6c42\u91cd\u5b9a\u5411[" + this.responseStatus + "]\uff0c\u4f46\u5185\u5bb9\u4e3aNULL";
                this.responseStatus = 699;
            } else {
                int ind = this.responseText.lastIndexOf("#");
                if (ind == -1) {
                    this.redirect = this.responseText;
                } else {
                    this.error = this.responseText.substring(ind + 1);
                    this.redirect = this.responseText.substring(0, ind);
                }
            }
        }
    }
}

