/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.control;

import org.zhiqim.kernel.control.ThreaderController;
import org.zhiqim.kernel.control.Threadx;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.seqs.Sequence;

public class Threader
extends Threadx
implements Runnable {
    private static final Log log = LogFactory.getLog(Threader.class);
    private static final Sequence sequence = new Sequence();
    private final ThreaderController controller;
    private final String threadName;
    private volatile boolean idle = true;
    private volatile long idleTimeMs = System.currentTimeMillis();

    public Threader(ThreaderController controller) {
        this.controller = controller;
        this.threadName = String.valueOf(controller.getThreadGroup().getName()) + "-" + sequence.next();
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    protected ThreadGroup getThreadGroup() {
        return this.controller.getThreadGroup();
    }

    @Override
    protected void loop() {
        Runnable command = this.controller.accept();
        if (command == null) {
            return;
        }
        try {
            try {
                this.idle = false;
                this.controller.active();
                command.run();
            }
            catch (Exception e) {
                log.error((Object)"\u7ebf\u7a0b\u6c60\u5904\u7406\u65f6\u5f02\u5e38\uff1a[%s]", (Throwable)e, e.getMessage());
                this.idle = true;
                this.idleTimeMs = System.currentTimeMillis();
                this.controller.idle();
                command = null;
            }
        }
        finally {
            this.idle = true;
            this.idleTimeMs = System.currentTimeMillis();
            this.controller.idle();
            command = null;
        }
    }

    public boolean isActive() {
        return !this.idle;
    }

    public boolean isIdle() {
        return this.idle;
    }

    public long getIdleTimeMs() {
        return this.idleTimeMs;
    }

    public String getIdleTimeString() {
        return DateTimes.toDateTimeString(this.idleTimeMs);
    }

    public boolean isIdleTimeout(long maxIdleTimeMs) {
        return this.idle && System.currentTimeMillis() - this.idleTimeMs - maxIdleTimeMs > 0L;
    }
}

