/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.AppDTVImpl;
import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.DTV;
import com.microsoft.sqlserver.jdbc.DTVImpl;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.PLPInputStream;
import com.microsoft.sqlserver.jdbc.PLPXMLInputStream;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.SimpleInputStream;
import com.microsoft.sqlserver.jdbc.StreamSetterArgs;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSReaderMark;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.io.IOException;
import java.util.Calendar;

final class ServerDTVImpl
extends DTVImpl {
    private int valueLength;
    private TDSReaderMark valueMark;
    private boolean isNull;
    int nIntValue;
    private static final int STREAMCONSUMED = -2;

    ServerDTVImpl() {
    }

    @Override
    void setValue(DTV dTV, SQLCollation sQLCollation, JDBCType jDBCType, Object object, StreamSetterArgs streamSetterArgs, Calendar calendar, Integer n, SQLServerConnection sQLServerConnection) throws SQLServerException {
        dTV.setImpl(new AppDTVImpl());
        dTV.setValue(sQLCollation, jDBCType, object, streamSetterArgs, calendar, n, sQLServerConnection);
    }

    @Override
    void setValue(Object object) {
        assert (false);
    }

    void setPositionAfterStreamed(TDSReader tDSReader) {
        this.valueMark = tDSReader.mark();
        this.valueLength = -2;
    }

    @Override
    void setStreamSetterArgs(StreamSetterArgs streamSetterArgs) {
        assert (false);
    }

    @Override
    void setCalendar(Calendar calendar) {
        assert (false);
    }

    @Override
    void setScale(Integer n) {
        assert (false);
    }

    @Override
    StreamSetterArgs getStreamSetterArgs() {
        assert (false);
        return null;
    }

    @Override
    Calendar getCalendar() {
        assert (false);
        return null;
    }

    @Override
    Integer getScale() {
        assert (false);
        return null;
    }

    @Override
    boolean isNull() {
        return this.isNull;
    }

    @Override
    void setJdbcType(JDBCType jDBCType) {
        assert (false);
    }

    @Override
    JDBCType getJdbcType() {
        assert (false);
        return JDBCType.UNKNOWN;
    }

    @Override
    final void skipValue(TypeInfo typeInfo, TDSReader tDSReader, boolean bl) throws SQLServerException {
        if (null == this.valueMark) {
            this.getValuePrep(typeInfo, tDSReader);
        }
        tDSReader.reset(this.valueMark);
        if (this.valueLength != -2) {
            if (this.valueLength == -1) {
                assert (typeInfo.isPLPType());
                PLPInputStream pLPInputStream = PLPInputStream.makeTempStream(tDSReader, bl, this);
                try {
                    if (null != pLPInputStream) {
                        pLPInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    tDSReader.getConnection().terminate(3, iOException.getMessage());
                }
            } else {
                assert (this.valueLength >= 0);
                tDSReader.skip(this.valueLength);
            }
        }
    }

    private final void getValuePrep(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        assert (null == this.valueMark);
        if (typeInfo.isPLPType()) {
            this.valueLength = -1;
            this.isNull = PLPInputStream.isNull(tDSReader);
        } else {
            int n = typeInfo.getValueLengthSize();
            switch (n) {
                case 0: {
                    this.valueLength = typeInfo.getMaxLength();
                    this.isNull = 0 == this.valueLength;
                    break;
                }
                case 1: {
                    this.valueLength = tDSReader.readUnsignedByte();
                    this.isNull = 0 == this.valueLength;
                    break;
                }
                case 2: {
                    this.valueLength = tDSReader.readUnsignedShort();
                    boolean bl = this.isNull = 65535 == this.valueLength;
                    if (!this.isNull) break;
                    this.valueLength = 0;
                    break;
                }
                case 4: {
                    if (SSType.TEXT == typeInfo.getSSType() || SSType.IMAGE == typeInfo.getSSType() || SSType.NTEXT == typeInfo.getSSType()) {
                        boolean bl = this.isNull = 0 == tDSReader.readUnsignedByte();
                        if (this.isNull) {
                            this.valueLength = 0;
                            break;
                        }
                        tDSReader.skip(24);
                        this.valueLength = tDSReader.readInt();
                        break;
                    }
                    this.valueLength = tDSReader.readInt();
                    this.isNull = 0 == this.valueLength;
                    break;
                }
                default: {
                    tDSReader.throwInvalidTDS();
                }
            }
        }
        this.valueMark = tDSReader.mark();
    }

    @Override
    Object getValue(DTV dTV, JDBCType jDBCType, boolean bl, int n, InputStreamGetterArgs inputStreamGetterArgs, Calendar calendar, TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        this.nIntValue = 0;
        if (null == this.valueMark) {
            this.getValuePrep(typeInfo, tDSReader);
        }
        boolean bl2 = false;
        if (null != inputStreamGetterArgs) {
            if (!inputStreamGetterArgs.streamType.convertsFrom(typeInfo)) {
                DataTypes.throwConversionError(typeInfo.getSSType().toString(), inputStreamGetterArgs.streamType.toString());
            }
        } else {
            if (!typeInfo.getSSType().convertsTo(jDBCType)) {
                DataTypes.throwConversionError(typeInfo.getSSType().toString(), jDBCType.toString());
            }
            inputStreamGetterArgs = InputStreamGetterArgs.getDefaultArgs();
        }
        if (-2 == this.valueLength) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_dataAlreadyAccessed"), null, 0, false);
        }
        if (this.isNull) {
            return null;
        }
        tDSReader.reset(this.valueMark);
        switch (typeInfo.getSSType()) {
            case VARBINARYMAX: 
            case VARCHARMAX: 
            case NVARCHARMAX: 
            case UDT: {
                return DDC.convertStreamToObject(PLPInputStream.makeStream(tDSReader, inputStreamGetterArgs, this), typeInfo, jDBCType, inputStreamGetterArgs);
            }
            case XML: {
                return DDC.convertStreamToObject(jDBCType.isBinary() ? PLPXMLInputStream.makeXMLStream(tDSReader, inputStreamGetterArgs, this) : PLPInputStream.makeStream(tDSReader, inputStreamGetterArgs, this), typeInfo, jDBCType, inputStreamGetterArgs);
            }
            case CHAR: 
            case VARCHAR: 
            case TEXT: 
            case NCHAR: 
            case NVARCHAR: 
            case NTEXT: 
            case IMAGE: 
            case BINARY: 
            case VARBINARY: 
            case TIMESTAMP: {
                return DDC.convertStreamToObject(new SimpleInputStream(tDSReader, this.valueLength, inputStreamGetterArgs, this), typeInfo, jDBCType, inputStreamGetterArgs);
            }
            case BIT: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                switch (this.valueLength) {
                    case 8: {
                        long l = tDSReader.readLong();
                        if (bl) {
                            return DDC.convertLongToObject(l, jDBCType, inputStreamGetterArgs.streamType);
                        }
                        this.nIntValue = (int)l;
                        return null;
                    }
                    case 4: {
                        this.nIntValue = tDSReader.readInt();
                        break;
                    }
                    case 2: {
                        this.nIntValue = tDSReader.readShort();
                        break;
                    }
                    case 1: {
                        this.nIntValue = tDSReader.readUnsignedByte();
                        break;
                    }
                    default: {
                        assert (false) : "Unexpected valueLength" + this.valueLength;
                        break;
                    }
                }
                if (bl) {
                    return DDC.convertIntegerToObject(this.nIntValue, this.valueLength, jDBCType, inputStreamGetterArgs.streamType);
                }
                return null;
            }
            case DECIMAL: 
            case NUMERIC: {
                return tDSReader.readDecimal(this.valueLength, typeInfo, jDBCType, inputStreamGetterArgs.streamType);
            }
            case MONEY: 
            case SMALLMONEY: {
                return tDSReader.readMoney(this.valueLength, jDBCType, inputStreamGetterArgs.streamType);
            }
            case FLOAT: {
                return tDSReader.readFloat(this.valueLength, jDBCType, inputStreamGetterArgs.streamType);
            }
            case REAL: {
                return tDSReader.readReal(this.valueLength, jDBCType, inputStreamGetterArgs.streamType);
            }
            case DATETIME: 
            case SMALLDATETIME: {
                return tDSReader.readDateTime(this.valueLength, calendar, jDBCType, inputStreamGetterArgs.streamType);
            }
            case GUID: {
                return tDSReader.readGUID(this.valueLength, jDBCType, inputStreamGetterArgs.streamType);
            }
        }
        assert (false) : "Unexpected SSType " + (Object)((Object)typeInfo.getSSType());
        return null;
    }

    @Override
    Object getSetterValue() {
        assert (false);
        return null;
    }
}

