/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerBlob;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.IOException;
import java.io.InputStream;

final class SQLServerBlobInputStream
extends InputStream {
    private SQLServerBlob parentBlob = null;
    private long streamPos;
    private long markPos;
    private byte[] bSingleByte = new byte[1];

    SQLServerBlobInputStream(SQLServerBlob sQLServerBlob) {
        this.parentBlob = sQLServerBlob;
        this.streamPos = 0L;
        this.markPos = 0L;
    }

    private long getBlobLength() throws IOException {
        try {
            return this.parentBlob.length();
        }
        catch (SQLServerException sQLServerException) {
            throw new IOException(sQLServerException.getMessage());
        }
    }

    private void checkClosed() throws IOException {
        if (null == this.parentBlob) {
            throw new IOException(SQLServerException.getErrString("R_streamIsClosed"));
        }
    }

    private boolean isEOS() throws IOException {
        return this.streamPos >= this.getBlobLength();
    }

    @Override
    public long skip(long l) throws IOException {
        this.checkClosed();
        if (l < 0L) {
            return 0L;
        }
        if (this.isEOS()) {
            return 0L;
        }
        long l2 = this.getBlobLength();
        if (0L == l2) {
            return 0L;
        }
        if (this.streamPos >= l2) {
            return 0L;
        }
        if (l > l2 - this.streamPos) {
            long l3 = l2 - this.streamPos;
            this.streamPos = l2;
            return l3;
        }
        this.streamPos += l;
        return l;
    }

    @Override
    public int available() throws IOException {
        this.checkClosed();
        if (this.isEOS()) {
            return 0;
        }
        long l = this.getBlobLength();
        if (0L == l) {
            return 0;
        }
        if (this.streamPos >= l) {
            return 0;
        }
        return (int)(l - this.streamPos);
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (this.isEOS()) {
            return -1;
        }
        int n = this.read(this.bSingleByte, 0, 1);
        return 0 == n ? -1 : this.bSingleByte[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        this.checkClosed();
        if (null == byArray) {
            return 0;
        }
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkClosed();
        if (null == byArray) {
            return 0;
        }
        if (this.isEOS()) {
            return -1;
        }
        int n3 = this.parentBlob.read((int)this.streamPos, byArray, n, n2);
        this.streamPos += (long)n3;
        return n3;
    }

    @Override
    public void mark(int n) {
        this.markPos = this.streamPos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() throws IOException {
        this.checkClosed();
        this.parentBlob = null;
    }

    @Override
    public void reset() throws IOException {
        this.checkClosed();
        this.streamPos = this.markPos;
    }
}

