/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;

final class ParameterUtils {
    ParameterUtils() {
    }

    static byte[] HexToBin(String string) throws SQLServerException {
        int n = string.length();
        char[] cArray = string.toCharArray();
        if (n % 2 != 0) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_stringNotInHex"), null, false);
        }
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n / 2; ++i) {
            byArray[i] = (byte)((ParameterUtils.CharToHex(cArray[2 * i]) << 4) + ParameterUtils.CharToHex(cArray[2 * i + 1]));
        }
        return byArray;
    }

    static byte CharToHex(char c) throws SQLServerException {
        byte by = 0;
        if (c >= 'A' && c <= 'F') {
            by = (byte)(c - 65 + 10);
        } else if (c >= 'a' && c <= 'f') {
            by = (byte)(c - 97 + 10);
        } else if (c >= '0' && c <= '9') {
            by = (byte)(c - 48);
        } else {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_stringNotInHex"), null, false);
        }
        return by;
    }

    static int scanSQLForChar(char c, String string, int n) {
        block6: while (n < string.length()) {
            char c2 = string.charAt(n++);
            switch (c2) {
                case '/': {
                    if (n == string.length()) continue block6;
                    if (string.charAt(n) == '*') {
                        while (++n < string.length()) {
                            if (string.charAt(n) != '*' || n + 1 >= string.length() || string.charAt(n + 1) != '/') continue;
                            n += 2;
                            continue block6;
                        }
                        continue block6;
                    }
                    if (string.charAt(n) == '-') continue block6;
                }
                case '-': {
                    if (string.charAt(n) == '-') {
                        while (++n < string.length()) {
                            if (string.charAt(n) != '\n' && string.charAt(n) != '\r') continue;
                            ++n;
                            continue block6;
                        }
                        continue block6;
                    }
                }
                default: {
                    if (c != c2) continue block6;
                    return n - 1;
                }
                case '[': {
                    c2 = ']';
                }
                case '\"': 
                case '\'': 
            }
            char c3 = c2;
            while (n < string.length()) {
                if (string.charAt(n++) != c3) continue;
                if (string.length() == n || string.charAt(n) != c3) continue block6;
                ++n;
            }
        }
        return string.length();
    }

    static String insertQuotes(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = string.indexOf("'", n)) < 0) {
                stringBuffer.append(string.substring(n));
                return stringBuffer.toString();
            }
            stringBuffer.append(string.substring(n, n2 + 1));
            stringBuffer.append("'");
            n = n2 + 1;
        }
    }

    static String replaceQuoteWithDouble(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        char c = '\"';
        while (true) {
            int n2;
            if ((n2 = string.indexOf("'", n)) < 0) {
                stringBuffer.append(string.substring(n));
                return stringBuffer.toString();
            }
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(c);
            n = n2 + 1;
        }
    }
}

