/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.xml;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.constants.XmlConstants;
import org.zhiqim.kernel.util.Streams;

@AnAlias(value={"Xmlx"})
public class Xmlx
implements XmlConstants,
CodeConstants {
    public static String toXmlSave(String value) {
        value = value.replaceAll("&", "&amp;");
        value = value.replaceAll(">", "&gt;");
        value = value.replaceAll("<", "&lt;");
        value = value.replaceAll("\"", "&quot;");
        value = value.replaceAll("'", "&apos;");
        value = value.replaceAll("\u00a9", "&copy;");
        value = value.replaceAll("\u00ae", "&reg;");
        return value;
    }

    public static String toXmlLoad(String value) {
        value = value.replaceAll("&amp;", "&");
        value = value.replaceAll("&gt;", ">");
        value = value.replaceAll("&lt;", "<");
        value = value.replaceAll("&quot;", "\"");
        value = value.replaceAll("&apos;", "'");
        value = value.replaceAll("&copy;", "\u00a9");
        value = value.replaceAll("&reg;", "\u00ae");
        return value;
    }

    public static String toTagBegin(String tag) {
        return "<" + tag + ">";
    }

    public static String toTagEnd(String tag) {
        return "</" + tag + ">";
    }

    public static String toCDataBegin() {
        return "<![CDATA[";
    }

    public static String toCDataEnd() {
        return "]]>";
    }

    public static StringBuilder addTagBegin(StringBuilder strb, String tag) {
        return strb.append("<").append(tag).append(">");
    }

    public static StringBuilder addTagEnd(StringBuilder strb, String tag) {
        return strb.append("</").append(tag).append(">");
    }

    public static StringBuffer addTagBegin(StringBuffer strb, String tag) {
        return strb.append("<").append(tag).append(">");
    }

    public static StringBuffer addTagEnd(StringBuffer strb, String tag) {
        return strb.append("</").append(tag).append(">");
    }

    public static EntityResolver getEmptyResolver() {
        return new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
            }
        };
    }

    public static Document buildDocument(String path, EntityResolver resolver) throws IOException {
        FileInputStream in = new FileInputStream(path);
        return Xmlx.buildDocument(in, resolver);
    }

    public static Document buildDocument(String path) throws IOException {
        FileInputStream in = new FileInputStream(path);
        return Xmlx.buildDocument(in, Xmlx.getEmptyResolver());
    }

    public static Document buildDocument(InputStream in) throws IOException {
        return Xmlx.buildDocument(in, Xmlx.getEmptyResolver());
    }

    public static Document buildDocument(InputStream in, EntityResolver resolver) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringElementContentWhitespace(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(resolver);
            return builder.parse(in);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static Document buildDocument(String content, String charset, EntityResolver resolver) throws IOException {
        ByteArrayInputStream is = Streams.toStream(content, charset);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringElementContentWhitespace(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(resolver);
            return builder.parse(is);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static Document buildDocument(String content, String charset) throws IOException {
        return Xmlx.buildDocument(content, charset, Xmlx.getEmptyResolver());
    }

    public static Document buildDocumentUTF8(String content) throws IOException {
        return Xmlx.buildDocument(content, "UTF-8");
    }

    public static boolean isOwn(Node node, String nodeName) {
        if (node == null || nodeName == null) {
            return false;
        }
        return nodeName.equals(node.getNodeName());
    }

    public static Node getNode(Node node, String childName) {
        if (node == null || childName == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node child = nodeList.item(i);
            if (childName.equals(child.getNodeName())) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public static List<Node> getNodeList(Node node, String childName) {
        if (node == null || childName == null) {
            return new ArrayList<Node>();
        }
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node child = nodeList.item(i);
            if (childName.equals(child.getNodeName())) {
                list.add(child);
            }
            ++i;
        }
        return list;
    }

    public static String getAttribute(NamedNodeMap namedNodeMap, String name) {
        return namedNodeMap == null ? null : (namedNodeMap.getNamedItem(name) == null ? null : namedNodeMap.getNamedItem(name).getNodeValue());
    }

    public static String getAttribute(Node node, String name) {
        return node == null ? null : (node.getAttributes().getNamedItem(name) == null ? null : node.getAttributes().getNamedItem(name).getNodeValue());
    }
}

