/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util.streams;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

public class DigestInputStream
extends FilterInputStream {
    private MessageDigest digest;
    private long length;

    public DigestInputStream(InputStream stream, MessageDigest digest) {
        super(stream);
        this.digest = digest;
    }

    @Override
    public int read() throws IOException {
        int ch = this.in.read();
        if (ch != -1) {
            this.digest.update((byte)ch);
            ++this.length;
        }
        return ch;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int result = this.in.read(b);
        if (result != -1) {
            this.digest.update(b, 0, result);
            this.length += (long)result;
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.in.read(b, off, len);
        if (result != -1) {
            this.digest.update(b, off, result);
            this.length += (long)len;
        }
        return result;
    }

    public MessageDigest getMessageDigest() {
        return this.digest;
    }

    public byte[] digest() {
        return this.digest.digest();
    }

    public long length() {
        return this.length;
    }

    public String toString() {
        return "[DigestInputStream] " + this.digest.toString();
    }
}

