/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.util.Bytes;
import org.zhiqim.kernel.util.Strings;

@AnAlias(value={"Ints"})
public class Ints {
    public static int toInt(String s) {
        return Integer.parseInt(s);
    }

    public static int toInt(String s, int defaultValue) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static int toInt(Object o, int defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Long) {
            return (int)((Long)o).longValue();
        }
        if (o instanceof String) {
            return Ints.toInt((String)o, defaultValue);
        }
        return defaultValue;
    }

    public static int toIntByHex(String s) {
        return Integer.parseInt(s, 16);
    }

    public static int toIntByHex(byte[] b) {
        return Integer.parseInt(new String(b), 16);
    }

    public static String toStringHex(int i) {
        return Integer.toString(i, 16);
    }

    public static byte[] toBytesHex(int i) {
        String hex = Integer.toString(i, 16);
        return Bytes.toBytesASCII(hex);
    }

    public static byte[] toBytesHex4(int i) {
        String hex = Integer.toString(i, 16);
        return Bytes.toBytesASCII(Strings.prefixZero(hex, 4));
    }

    public static byte[] toBytesHex8(int i) {
        String hex = Integer.toString(i, 16);
        return Bytes.toBytesASCII(Strings.prefixZero(hex, 8));
    }

    public static int length(int val) {
        if (val == 0) {
            return 1;
        }
        boolean isNegative = false;
        if (val < 0) {
            val = -val;
            isNegative = true;
        }
        int len = 0;
        int i = val;
        while (i != 0) {
            ++len;
            i /= 10;
        }
        return isNegative ? len + 1 : len;
    }

    public static int getMaxInt(int length) {
        if (length >= 10) {
            return Integer.MAX_VALUE;
        }
        if (length <= 0) {
            return 9;
        }
        String maxString = "999999999".substring(0, length);
        return Ints.toInt(maxString);
    }

    public static int compareUnsigned(int a, int b) {
        int cmp = (a >>> 1) - (b >>> 1);
        if (cmp != 0) {
            return cmp > 0 ? 1 : -1;
        }
        cmp = (a & 1) - (b & 1);
        return cmp > 0 ? 1 : (cmp < 0 ? -1 : 0);
    }
}

