/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.schedule;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.control.Threadx;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.schedule.Task;
import org.zhiqim.kernel.schedule.TaskLoad;
import org.zhiqim.kernel.util.Threads;

@AnAlias(value={"Interval"})
public class Interval
extends Threadx
implements SignConstants {
    private static final Log log = LogFactory.getLog(Interval.class);
    private Task task;
    private int firstMillis;
    private int middleMillis;
    private int times;

    public static Interval shedule(Task task, int millis) {
        return new Interval().open(task, 0, millis, -1);
    }

    public static Interval shedule(Task task, int firstMillis, int middleMillis) {
        return new Interval().open(task, firstMillis, middleMillis, -1);
    }

    public static Interval shedule(Task task, int firstMillis, int middleMillis, int times) {
        return new Interval().open(task, firstMillis, middleMillis, times);
    }

    public Interval open(Task task, int firstMillis, int middleMillis, int times) {
        this.task = task;
        this.firstMillis = firstMillis;
        this.middleMillis = middleMillis;
        this.times = times;
        super.open();
        return this;
    }

    @Override
    public String getThreadName() {
        return "Interval-" + this.task.getClass().getName();
    }

    @Override
    public void closeAfter() {
        this.times = 0;
    }

    @Override
    protected void first() {
        if (this.task instanceof TaskLoad) {
            ((TaskLoad)this.task).load();
        }
        Threads.sleepIgnoreException(this.firstMillis);
    }

    @Override
    protected void loop() {
        if (this.times == 0) {
            this.close();
            return;
        }
        try {
            this.task.execute();
        }
        catch (Throwable e) {
            if (this.times == -1) {
                log.error((Object)"Interval:[%s],\u5728\u8fdb\u884c\u65f6Exception\u5f02\u5e38", e, this.getThreadName());
            }
            log.error((Object)"Interval:[%s],\u5728\u8fdb\u884c%s\u65f6Exception\u5f02\u5e38", e, this.getThreadName(), this.times == -1 ? "" : "\u7b2c" + this.times + "\u6b21");
        }
        if (this.times > 0) {
            --this.times;
        }
        Threads.sleepIgnoreException(this.middleMillis);
    }

    public String toString() {
        return "{name:Interval, " + "firstMillis:" + this.firstMillis + ", " + "middleMillis:" + this.middleMillis + ", " + "times:" + this.times + "}";
    }
}

