/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.logging;

import java.util.List;
import org.zhiqim.kernel.logging.LogConstants;
import org.zhiqim.kernel.logging.LogService;
import org.zhiqim.kernel.logging.Logger;
import org.zhiqim.kernel.util.Strings;

public class Log
implements LogConstants {
    private LogService logService;
    private String mustName;
    private Class<?> mustClass;

    public Log(String mustName, LogService logService) {
        this.mustName = mustName;
        this.logService = logService;
    }

    public Log(Class<?> mustClass, LogService logService) {
        this.mustClass = mustClass;
        this.logService = logService;
    }

    public void setLogService(LogService logService) {
        this.logService = logService;
    }

    public String getMustName() {
        return this.mustName;
    }

    public Class<?> getMustClass() {
        return this.mustClass;
    }

    public LogService getLogService() {
        return this.logService;
    }

    public String getParamName() {
        return this.mustClass != null ? this.mustClass.getName() : this.mustName;
    }

    public void debug(Object message) {
        this.handle(1, message, new Object[0]);
    }

    public void debug(Throwable throwable) {
        this.handle(1, null, throwable, new Object[0]);
    }

    public void debug(Object message, Object ... arguments) {
        this.handle(1, message, arguments);
    }

    public void debug(Object message, Throwable throwable, Object ... arguments) {
        this.handle(1, message, throwable, arguments);
    }

    public void info(Object message) {
        this.handle(2, message, new Object[0]);
    }

    public void info(Throwable throwable) {
        this.handle(2, null, throwable, new Object[0]);
    }

    public void info(Object message, Object ... arguments) {
        this.handle(2, message, arguments);
    }

    public void info(Object message, Throwable throwable, Object ... arguments) {
        this.handle(2, message, throwable, arguments);
    }

    public void error(Object message) {
        this.handle(3, message, new Object[0]);
    }

    public void error(Throwable throwable) {
        this.handle(3, null, throwable, new Object[0]);
    }

    public void error(Object message, Object ... arguments) {
        this.handle(3, message, arguments);
    }

    public void error(Object message, Throwable throwable, Object ... arguments) {
        this.handle(3, message, throwable, arguments);
    }

    public void warn(Object message) {
        this.handle(4, message, new Object[0]);
    }

    public void warn(Throwable throwable) {
        this.handle(4, null, throwable, new Object[0]);
    }

    public void warn(Object message, Object ... arguments) {
        this.handle(4, message, arguments);
    }

    public void warn(Object message, Throwable throwable, Object ... arguments) {
        this.handle(4, message, throwable, arguments);
    }

    public void fatal(Object message) {
        this.handle(5, message, new Object[0]);
    }

    public void fatal(Throwable throwable) {
        this.handle(5, null, throwable, new Object[0]);
    }

    public void fatal(Object message, Object ... arguments) {
        this.handle(5, message, arguments);
    }

    public void fatal(Object message, Throwable throwable, Object ... arguments) {
        this.handle(5, message, throwable, arguments);
    }

    public boolean isDebugEnabled() {
        return this.allow(1);
    }

    public boolean isInfoEnabled() {
        return this.allow(2);
    }

    public boolean isErrorEnabled() {
        return this.allow(3);
    }

    public boolean isWarnEnabled() {
        return this.allow(4);
    }

    public boolean isFatalEnabled() {
        return this.allow(5);
    }

    private void handle(int level, Object message, Object ... arguments) {
        this.handle(level, message, null, arguments);
    }

    private void handle(int level, Object message, Throwable throwable, Object ... arguments) {
        List<Logger> loggerList = this.logService.getLoggerList(this, level);
        if (loggerList == null || loggerList.isEmpty()) {
            return;
        }
        String msg = Strings.formatTwo(String.valueOf(message), arguments);
        for (Logger logger : loggerList) {
            logger.logger(this, level, msg, throwable);
        }
    }

    private boolean allow(int level) {
        return this.logService.isLoggerEnabled(this, level);
    }
}

