/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.json;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.zhiqim.kernel.extend.HashMapCV;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.HashMapSS;
import org.zhiqim.kernel.extend.LinkedMapSO;
import org.zhiqim.kernel.extend.LinkedMapSS;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.extend.TreeMapSO;
import org.zhiqim.kernel.extend.TreeMapSS;
import org.zhiqim.kernel.json.Json;
import org.zhiqim.kernel.json.JsonParser;
import org.zhiqim.kernel.json.parser.ArrayParser;
import org.zhiqim.kernel.json.parser.BaseParser;
import org.zhiqim.kernel.json.parser.DateParser;
import org.zhiqim.kernel.json.parser.ListParser;
import org.zhiqim.kernel.json.parser.MapParser;
import org.zhiqim.kernel.json.parser.MapSOParser;
import org.zhiqim.kernel.json.parser.MapSSParser;
import org.zhiqim.kernel.json.parser.ObjectParser;
import org.zhiqim.kernel.util.Classes;

public class JsonFactory {
    private HashMapCV<JsonParser> parserMap = new HashMapCV();

    public JsonFactory(Json jsonMain) {
        JsonParser baseParser = new BaseParser().set(jsonMain);
        this.parserMap.put(Boolean.TYPE, baseParser);
        this.parserMap.put(Byte.TYPE, baseParser);
        this.parserMap.put(Character.TYPE, baseParser);
        this.parserMap.put(Short.TYPE, baseParser);
        this.parserMap.put(Integer.TYPE, baseParser);
        this.parserMap.put(Long.TYPE, baseParser);
        this.parserMap.put(Float.TYPE, baseParser);
        this.parserMap.put(Double.TYPE, baseParser);
        this.parserMap.put(Boolean.class, baseParser);
        this.parserMap.put(Byte.class, baseParser);
        this.parserMap.put(Character.class, baseParser);
        this.parserMap.put(Short.class, baseParser);
        this.parserMap.put(Integer.class, baseParser);
        this.parserMap.put(Long.class, baseParser);
        this.parserMap.put(Float.class, baseParser);
        this.parserMap.put(Double.class, baseParser);
        this.parserMap.put(String.class, baseParser);
        JsonParser arrarParser = new ArrayParser().set(jsonMain);
        this.parserMap.put(boolean[].class, arrarParser);
        this.parserMap.put(byte[].class, arrarParser);
        this.parserMap.put(char[].class, arrarParser);
        this.parserMap.put(short[].class, arrarParser);
        this.parserMap.put(int[].class, arrarParser);
        this.parserMap.put(long[].class, arrarParser);
        this.parserMap.put(float[].class, arrarParser);
        this.parserMap.put(double[].class, arrarParser);
        this.parserMap.put(Boolean[].class, arrarParser);
        this.parserMap.put(Byte[].class, arrarParser);
        this.parserMap.put(Character[].class, arrarParser);
        this.parserMap.put(Short[].class, arrarParser);
        this.parserMap.put(Integer[].class, arrarParser);
        this.parserMap.put(Long[].class, arrarParser);
        this.parserMap.put(Float[].class, arrarParser);
        this.parserMap.put(Double[].class, arrarParser);
        this.parserMap.put(String[].class, arrarParser);
        JsonParser mapParser = new MapParser().set(jsonMain);
        this.parserMap.put(Map.class, mapParser);
        this.parserMap.put(HashMap.class, mapParser);
        this.parserMap.put(ConcurrentMap.class, mapParser);
        this.parserMap.put(ConcurrentHashMap.class, mapParser);
        this.parserMap.put(Hashtable.class, mapParser);
        this.parserMap.put(LinkedHashMap.class, mapParser);
        this.parserMap.put(TreeMap.class, mapParser);
        JsonParser zmapParser = new MapSOParser().set(jsonMain);
        this.parserMap.put(MapSO.class, zmapParser);
        this.parserMap.put(HashMapSO.class, zmapParser);
        this.parserMap.put(LinkedMapSO.class, zmapParser);
        this.parserMap.put(TreeMapSO.class, zmapParser);
        JsonParser zmapssParser = new MapSSParser().set(jsonMain);
        this.parserMap.put(MapSS.class, zmapssParser);
        this.parserMap.put(HashMapSS.class, zmapssParser);
        this.parserMap.put(LinkedMapSS.class, zmapssParser);
        this.parserMap.put(TreeMapSS.class, zmapssParser);
        JsonParser listParser = new ListParser().set(jsonMain);
        this.parserMap.put(Collection.class, listParser);
        this.parserMap.put(List.class, listParser);
        this.parserMap.put(ArrayList.class, listParser);
        this.parserMap.put(LinkedList.class, listParser);
        this.parserMap.put(Set.class, listParser);
        this.parserMap.put(HashSet.class, listParser);
        JsonParser dateParser = new DateParser().set(jsonMain);
        this.parserMap.put(java.util.Date.class, dateParser);
        this.parserMap.put(Date.class, dateParser);
        this.parserMap.put(Time.class, dateParser);
        this.parserMap.put(Timestamp.class, dateParser);
        this.parserMap.put(Calendar.class, dateParser);
        this.parserMap.put(Object[].class, arrarParser);
        this.parserMap.put(Object.class, new ObjectParser().set(jsonMain));
    }

    public JsonParser getParser(Class<?> clazz) {
        JsonParser parser = (JsonParser)this.parserMap.get(clazz);
        if (parser == null) {
            parser = Classes.isCollection(clazz) ? (JsonParser)this.parserMap.get(List.class) : (Classes.isMap(clazz) ? (JsonParser)this.parserMap.get(Map.class) : (clazz.isArray() ? (JsonParser)this.parserMap.get(Object[].class) : (JsonParser)this.parserMap.get(Object.class)));
        }
        return parser;
    }
}

