/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.mysql5_0_8.jdbc;

import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimerTask;
import org.zhiqim.mysql5_0_8.jdbc.AssertionFailedException;
import org.zhiqim.mysql5_0_8.jdbc.CachedResultSetMetaData;
import org.zhiqim.mysql5_0_8.jdbc.CharsetMapping;
import org.zhiqim.mysql5_0_8.jdbc.Connection;
import org.zhiqim.mysql5_0_8.jdbc.Constants;
import org.zhiqim.mysql5_0_8.jdbc.DatabaseMetaData;
import org.zhiqim.mysql5_0_8.jdbc.EscapeProcessor;
import org.zhiqim.mysql5_0_8.jdbc.EscapeProcessorResult;
import org.zhiqim.mysql5_0_8.jdbc.Field;
import org.zhiqim.mysql5_0_8.jdbc.Messages;
import org.zhiqim.mysql5_0_8.jdbc.MysqlIO;
import org.zhiqim.mysql5_0_8.jdbc.PingTarget;
import org.zhiqim.mysql5_0_8.jdbc.PreparedStatement;
import org.zhiqim.mysql5_0_8.jdbc.ResultSet;
import org.zhiqim.mysql5_0_8.jdbc.RowDataStatic;
import org.zhiqim.mysql5_0_8.jdbc.SQLError;
import org.zhiqim.mysql5_0_8.jdbc.SingleByteCharsetConverter;
import org.zhiqim.mysql5_0_8.jdbc.StringUtils;
import org.zhiqim.mysql5_0_8.jdbc.exceptions.MySQLTimeoutException;
import org.zhiqim.mysql5_0_8.jdbc.profiler.ProfileEventSink;
import org.zhiqim.mysql5_0_8.jdbc.profiler.ProfilerEvent;

public class Statement
implements java.sql.Statement {
    protected static final String PING_MARKER = "/* ping */";
    protected Object cancelTimeoutMutex = new Object();
    protected static int statementCounter = 1;
    public static final byte USES_VARIABLES_FALSE = 0;
    public static final byte USES_VARIABLES_TRUE = 1;
    public static final byte USES_VARIABLES_UNKNOWN = -1;
    protected boolean wasCancelled = false;
    protected List batchedArgs;
    protected SingleByteCharsetConverter charConverter = null;
    protected String charEncoding = null;
    protected Connection connection = null;
    protected long connectionId = 0L;
    protected String currentCatalog = null;
    protected boolean doEscapeProcessing = true;
    protected ProfileEventSink eventSink = null;
    private int fetchSize = 0;
    protected boolean isClosed = false;
    protected long lastInsertId = -1L;
    protected int maxFieldSize = MysqlIO.getMaxBuf();
    protected int maxRows = -1;
    protected boolean maxRowsChanged = false;
    protected List openResults = new ArrayList();
    protected boolean pedantic = false;
    protected Throwable pointOfOrigin;
    protected boolean profileSQL = false;
    protected ResultSet results = null;
    protected int resultSetConcurrency = 0;
    protected int resultSetType = 0;
    protected int statementId;
    protected int timeoutInMillis = 0;
    protected long updateCount = -1L;
    protected boolean useUsageAdvisor = false;
    protected SQLWarning warningChain = null;
    protected boolean holdResultsOpenOverClose = false;
    protected ArrayList batchedGeneratedKeys = null;
    protected boolean retrieveGeneratedKeys = false;
    protected boolean continueBatchOnError = false;
    protected PingTarget pingTarget = null;

    public Statement(Connection c, String catalog) throws SQLException {
        int maxRowsConn;
        boolean profiling;
        if (c == null || c.isClosed()) {
            throw SQLError.createSQLException(Messages.getString("Statement.0"), "08003");
        }
        this.connection = c;
        this.connectionId = this.connection.getId();
        this.currentCatalog = catalog;
        this.pedantic = this.connection.getPedantic();
        this.continueBatchOnError = this.connection.getContinueBatchOnError();
        if (!this.connection.getDontTrackOpenResources()) {
            this.connection.registerStatement(this);
        }
        if (this.connection != null) {
            this.maxFieldSize = this.connection.getMaxAllowedPacket();
            int defaultFetchSize = this.connection.getDefaultFetchSize();
            if (defaultFetchSize != 0) {
                this.setFetchSize(defaultFetchSize);
            }
        }
        if (this.connection.getUseUnicode()) {
            this.charEncoding = this.connection.getEncoding();
            this.charConverter = this.connection.getCharsetConverter(this.charEncoding);
        }
        boolean bl = profiling = this.connection.getProfileSql() || this.connection.getUseUsageAdvisor();
        if (this.connection.getAutoGenerateTestcaseScript() || profiling) {
            this.statementId = statementCounter++;
        }
        if (profiling) {
            this.pointOfOrigin = new Throwable();
            this.profileSQL = this.connection.getProfileSql();
            this.useUsageAdvisor = this.connection.getUseUsageAdvisor();
            this.eventSink = ProfileEventSink.getInstance(this.connection);
        }
        if ((maxRowsConn = this.connection.getMaxRows()) != -1) {
            this.setMaxRows(maxRowsConn);
        }
    }

    @Override
    public synchronized void addBatch(String sql) throws SQLException {
        if (this.batchedArgs == null) {
            this.batchedArgs = new ArrayList();
        }
        if (sql != null) {
            this.batchedArgs.add(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        if (!this.isClosed && this.connection != null && this.connection.versionMeetsMinimum(5, 0, 0)) {
            Connection cancelConn = null;
            java.sql.Statement cancelStmt = null;
            try {
                try {
                    Object object = this.cancelTimeoutMutex;
                    synchronized (object) {
                        cancelConn = this.connection.duplicate();
                        cancelStmt = cancelConn.createStatement();
                        cancelStmt.execute("KILL QUERY " + this.connection.getIO().getThreadId());
                        this.wasCancelled = true;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    throw SQLError.createSQLException(Messages.getString("Statement.49"), "08003");
                }
            }
            finally {
                if (cancelStmt != null) {
                    cancelStmt.close();
                }
                if (cancelConn != null) {
                    cancelConn.close();
                }
            }
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw SQLError.createSQLException(Messages.getString("Statement.49"), "08003");
        }
    }

    protected void checkForDml(String sql, char firstStatementChar) throws SQLException {
        String noCommentSql;
        if ((firstStatementChar == 'I' || firstStatementChar == 'U' || firstStatementChar == 'D' || firstStatementChar == 'A' || firstStatementChar == 'C') && (StringUtils.startsWithIgnoreCaseAndWs(noCommentSql = StringUtils.stripComments(sql, "'\"", "'\"", true, false, true, true), "INSERT") || StringUtils.startsWithIgnoreCaseAndWs(noCommentSql, "UPDATE") || StringUtils.startsWithIgnoreCaseAndWs(noCommentSql, "DELETE") || StringUtils.startsWithIgnoreCaseAndWs(noCommentSql, "DROP") || StringUtils.startsWithIgnoreCaseAndWs(noCommentSql, "CREATE") || StringUtils.startsWithIgnoreCaseAndWs(noCommentSql, "ALTER"))) {
            throw SQLError.createSQLException(Messages.getString("Statement.57"), "S1009");
        }
    }

    protected void checkNullOrEmptyQuery(String sql) throws SQLException {
        if (sql == null) {
            throw SQLError.createSQLException(Messages.getString("Statement.59"), "S1009");
        }
        if (sql.length() == 0) {
            throw SQLError.createSQLException(Messages.getString("Statement.61"), "S1009");
        }
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        if (this.batchedArgs != null) {
            this.batchedArgs.clear();
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public void close() throws SQLException {
        this.realClose(true, true);
    }

    protected void closeAllOpenResults() {
        if (this.openResults != null) {
            for (ResultSet element : this.openResults) {
                try {
                    element.realClose(false);
                }
                catch (SQLException sqlEx) {
                    AssertionFailedException.shouldNotHappen(sqlEx);
                }
            }
            this.openResults.clear();
        }
    }

    private ResultSet createResultSetUsingServerFetch(String sql) throws SQLException {
        java.sql.PreparedStatement pStmt = this.connection.prepareStatement(sql, this.resultSetType, this.resultSetConcurrency);
        pStmt.setFetchSize(this.fetchSize);
        if (this.maxRows > -1) {
            pStmt.setMaxRows(this.maxRows);
        }
        pStmt.execute();
        ResultSet rs = ((Statement)((Object)pStmt)).getResultSetInternal();
        rs.setStatementUsedForFetchingRows((PreparedStatement)pStmt);
        this.results = rs;
        return rs;
    }

    protected boolean createStreamingResultSet() {
        return this.resultSetType == 1003 && this.resultSetConcurrency == 1007 && this.fetchSize == Integer.MIN_VALUE;
    }

    public void enableStreamingResults() throws SQLException {
        this.setFetchSize(Integer.MIN_VALUE);
        this.setResultSetType(1003);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkClosed();
        Connection locallyScopedConn = this.connection;
        Object object = locallyScopedConn.getMutex();
        synchronized (object) {
            boolean isSelect;
            char firstNonWsChar;
            block41: {
                Object object2 = this.cancelTimeoutMutex;
                synchronized (object2) {
                    this.wasCancelled = false;
                }
                this.checkNullOrEmptyQuery(sql);
                this.checkClosed();
                firstNonWsChar = StringUtils.firstNonWsCharUc(sql);
                isSelect = true;
                if (firstNonWsChar != 'S') {
                    isSelect = false;
                    if (locallyScopedConn.isReadOnly()) {
                        throw SQLError.createSQLException(String.valueOf(Messages.getString("Statement.27")) + Messages.getString("Statement.28"), "S1009");
                    }
                }
                if (this.doEscapeProcessing) {
                    Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, locallyScopedConn.serverSupportsConvertFn(), locallyScopedConn);
                    sql = escapedSqlResult instanceof String ? (String)escapedSqlResult : ((EscapeProcessorResult)escapedSqlResult).escapedSql;
                }
                if (this.results != null && !locallyScopedConn.getHoldResultsOpenOverStatementClose()) {
                    this.results.realClose(false);
                }
                if (firstNonWsChar != '/' || !sql.startsWith(PING_MARKER)) break block41;
                this.doPingInstead();
                return true;
            }
            CachedResultSetMetaData cachedMetaData = null;
            ResultSet rs = null;
            this.batchedGeneratedKeys = null;
            if (this.useServerFetch()) {
                rs = this.createResultSetUsingServerFetch(sql);
            } else {
                TimerTask timeoutTask = null;
                String oldCatalog = null;
                try {
                    if (locallyScopedConn.getEnableQueryTimeouts() && this.timeoutInMillis != 0 && locallyScopedConn.versionMeetsMinimum(5, 0, 0)) {
                        timeoutTask = new CancelTask();
                        Connection.getCancelTimer().schedule(timeoutTask, this.timeoutInMillis);
                    }
                    if (!locallyScopedConn.getCatalog().equals(this.currentCatalog)) {
                        oldCatalog = locallyScopedConn.getCatalog();
                        locallyScopedConn.setCatalog(this.currentCatalog);
                    }
                    if (locallyScopedConn.getCacheResultSetMetadata()) {
                        cachedMetaData = locallyScopedConn.getCachedMetaData(sql);
                    }
                    if (locallyScopedConn.useMaxRows()) {
                        int rowLimit = -1;
                        if (isSelect) {
                            if (StringUtils.indexOfIgnoreCase(sql, "LIMIT") != -1) {
                                rowLimit = this.maxRows;
                            } else if (this.maxRows <= 0) {
                                locallyScopedConn.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, null, 1003, 1007, false, this.currentCatalog, true);
                            } else {
                                locallyScopedConn.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=" + this.maxRows, -1, null, 1003, 1007, false, this.currentCatalog, true);
                            }
                        } else {
                            locallyScopedConn.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, null, 1003, 1007, false, this.currentCatalog, true);
                        }
                        rs = locallyScopedConn.execSQL(this, sql, rowLimit, null, this.resultSetType, this.resultSetConcurrency, this.createStreamingResultSet(), this.currentCatalog, cachedMetaData == null);
                    } else {
                        rs = locallyScopedConn.execSQL(this, sql, -1, null, this.resultSetType, this.resultSetConcurrency, this.createStreamingResultSet(), this.currentCatalog, cachedMetaData == null);
                    }
                    if (timeoutTask != null) {
                        if (((CancelTask)timeoutTask).caughtWhileCancelling != null) {
                            throw ((CancelTask)timeoutTask).caughtWhileCancelling;
                        }
                        timeoutTask.cancel();
                        timeoutTask = null;
                    }
                    Object object3 = this.cancelTimeoutMutex;
                    synchronized (object3) {
                        if (this.wasCancelled) {
                            this.wasCancelled = false;
                            throw new MySQLTimeoutException();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (timeoutTask != null) {
                        timeoutTask.cancel();
                    }
                    if (oldCatalog != null) {
                        locallyScopedConn.setCatalog(oldCatalog);
                    }
                    throw throwable;
                }
                if (timeoutTask != null) {
                    timeoutTask.cancel();
                }
                if (oldCatalog != null) {
                    locallyScopedConn.setCatalog(oldCatalog);
                }
            }
            this.lastInsertId = rs.getUpdateID();
            if (rs != null) {
                this.results = rs;
                rs.setFirstCharOfQuery(firstNonWsChar);
                if (rs.reallyResult()) {
                    if (cachedMetaData != null) {
                        locallyScopedConn.initializeResultsMetadataFromCache(sql, cachedMetaData, this.results);
                    } else if (this.connection.getCacheResultSetMetadata()) {
                        locallyScopedConn.initializeResultsMetadataFromCache(sql, null, this.results);
                    }
                }
            }
            return rs != null && rs.reallyResult();
        }
    }

    @Override
    public boolean execute(String sql, int returnGeneratedKeys) throws SQLException {
        if (returnGeneratedKeys == 1) {
            this.checkClosed();
            Connection locallyScopedConn = this.connection;
            Object object = locallyScopedConn.getMutex();
            synchronized (object) {
                boolean bl;
                boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
                locallyScopedConn.setReadInfoMsgEnabled(true);
                try {
                    bl = this.execute(sql);
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                }
                catch (Throwable throwable) {
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                    throw throwable;
                }
                return bl;
            }
        }
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] generatedKeyIndices) throws SQLException {
        if (generatedKeyIndices != null && generatedKeyIndices.length > 0) {
            this.checkClosed();
            Connection locallyScopedConn = this.connection;
            Object object = locallyScopedConn.getMutex();
            synchronized (object) {
                boolean bl;
                boolean readInfoMsgState = locallyScopedConn.isReadInfoMsgEnabled();
                locallyScopedConn.setReadInfoMsgEnabled(true);
                try {
                    bl = this.execute(sql);
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                }
                catch (Throwable throwable) {
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                    throw throwable;
                }
                return bl;
            }
        }
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] generatedKeyNames) throws SQLException {
        if (generatedKeyNames != null && generatedKeyNames.length > 0) {
            this.checkClosed();
            Connection locallyScopedConn = this.connection;
            Object object = locallyScopedConn.getMutex();
            synchronized (object) {
                boolean bl;
                boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
                locallyScopedConn.setReadInfoMsgEnabled(true);
                try {
                    bl = this.execute(sql);
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                }
                catch (Throwable throwable) {
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                    throw throwable;
                }
                return bl;
            }
        }
        return this.execute(sql);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized int[] executeBatch() throws SQLException {
        this.checkClosed();
        Connection locallyScopedConn = this.connection;
        if (locallyScopedConn.isReadOnly()) {
            throw SQLError.createSQLException(String.valueOf(Messages.getString("Statement.34")) + Messages.getString("Statement.35"), "S1009");
        }
        if (this.results != null && !locallyScopedConn.getHoldResultsOpenOverStatementClose()) {
            this.results.realClose(false);
        }
        Object object = locallyScopedConn.getMutex();
        synchronized (object) {
            if (this.batchedArgs == null || this.batchedArgs.size() == 0) {
                return new int[0];
            }
            try {
                this.retrieveGeneratedKeys = true;
                int[] updateCounts = null;
                if (this.batchedArgs != null) {
                    int nbrCommands = this.batchedArgs.size();
                    this.batchedGeneratedKeys = new ArrayList(this.batchedArgs.size());
                    boolean multiQueriesEnabled = locallyScopedConn.getAllowMultiQueries();
                    if (locallyScopedConn.versionMeetsMinimum(4, 1, 1) && (multiQueriesEnabled || locallyScopedConn.getRewriteBatchedStatements() && nbrCommands > 4)) {
                        int[] nArray = this.executeBatchUsingMultiQueries(multiQueriesEnabled, nbrCommands);
                        return nArray;
                    }
                    updateCounts = new int[nbrCommands];
                    int i = 0;
                    while (i < nbrCommands) {
                        updateCounts[i] = -3;
                        ++i;
                    }
                    Throwable sqlEx = null;
                    int commandIndex = 0;
                    commandIndex = 0;
                    while (commandIndex < nbrCommands) {
                        try {
                            updateCounts[commandIndex] = this.executeUpdate((String)this.batchedArgs.get(commandIndex), true);
                            this.getBatchedGeneratedKeys();
                        }
                        catch (SQLException ex) {
                            updateCounts[commandIndex] = -3;
                            if (!this.continueBatchOnError) {
                                int[] newUpdateCounts = new int[commandIndex];
                                System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                                throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), newUpdateCounts);
                            }
                            sqlEx = ex;
                        }
                        ++commandIndex;
                    }
                    if (sqlEx != null) {
                        throw new BatchUpdateException(sqlEx.getMessage(), ((SQLException)sqlEx).getSQLState(), ((SQLException)sqlEx).getErrorCode(), updateCounts);
                    }
                }
                int[] nArray = updateCounts != null ? updateCounts : new int[]{};
                return nArray;
            }
            finally {
                this.retrieveGeneratedKeys = false;
                this.clearBatch();
            }
        }
    }

    private int[] executeBatchUsingMultiQueries(boolean multiQueriesEnabled, int nbrCommands) throws SQLException {
        Connection locallyScopedConn = this.connection;
        if (!multiQueriesEnabled) {
            locallyScopedConn.getIO().enableMultiQueries();
        }
        java.sql.Statement batchStmt = null;
        try {
            int[] updateCounts = new int[nbrCommands];
            int i = 0;
            while (i < nbrCommands) {
                updateCounts[i] = -3;
                ++i;
            }
            int commandIndex = 0;
            StringBuffer queryBuf = new StringBuffer();
            batchStmt = locallyScopedConn.createStatement();
            int counter = 0;
            int numberOfBytesPerChar = 1;
            String connectionEncoding = locallyScopedConn.getEncoding();
            if (StringUtils.startsWithIgnoreCase(connectionEncoding, "utf")) {
                numberOfBytesPerChar = 3;
            } else if (CharsetMapping.isMultibyteCharset(connectionEncoding)) {
                numberOfBytesPerChar = 2;
            }
            int escapeAdjust = 1;
            if (this.doEscapeProcessing) {
                escapeAdjust = 2;
            }
            commandIndex = 0;
            while (commandIndex < nbrCommands) {
                String nextQuery = (String)this.batchedArgs.get(commandIndex);
                if (((queryBuf.length() + nextQuery.length()) * numberOfBytesPerChar + 1 + 4) * escapeAdjust + 32 > this.connection.getMaxAllowedPacket()) {
                    batchStmt.execute(queryBuf.toString());
                    updateCounts[counter++] = batchStmt.getUpdateCount();
                    long generatedKeyStart = ((Statement)batchStmt).getLastInsertID();
                    byte[][] row = new byte[][]{Long.toString(generatedKeyStart++).getBytes()};
                    this.batchedGeneratedKeys.add(row);
                    while (batchStmt.getMoreResults() || batchStmt.getUpdateCount() != -1) {
                        updateCounts[counter++] = batchStmt.getUpdateCount();
                        row = new byte[][]{Long.toString(generatedKeyStart++).getBytes()};
                        this.batchedGeneratedKeys.add(row);
                    }
                    queryBuf = new StringBuffer();
                }
                queryBuf.append(nextQuery);
                queryBuf.append(";");
                ++commandIndex;
            }
            if (queryBuf.length() > 0) {
                batchStmt.execute(queryBuf.toString());
                long generatedKeyStart = ((Statement)batchStmt).getLastInsertID();
                byte[][] row = new byte[][]{Long.toString(generatedKeyStart++).getBytes()};
                this.batchedGeneratedKeys.add(row);
                updateCounts[counter++] = batchStmt.getUpdateCount();
                while (batchStmt.getMoreResults() || batchStmt.getUpdateCount() != -1) {
                    updateCounts[counter++] = batchStmt.getUpdateCount();
                    row = new byte[][]{Long.toString(generatedKeyStart++).getBytes()};
                    this.batchedGeneratedKeys.add(row);
                }
            }
            int[] nArray = updateCounts != null ? updateCounts : new int[]{};
            return nArray;
        }
        finally {
            try {
                if (batchStmt != null) {
                    batchStmt.close();
                }
            }
            finally {
                if (!multiQueriesEnabled) {
                    locallyScopedConn.getIO().disableMultiQueries();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public java.sql.ResultSet executeQuery(String sql) throws SQLException {
        this.checkClosed();
        Connection locallyScopedConn = this.connection;
        Object object = locallyScopedConn.getMutex();
        synchronized (object) {
            Object object2 = this.cancelTimeoutMutex;
            synchronized (object2) {
                this.wasCancelled = false;
            }
            this.checkNullOrEmptyQuery(sql);
            if (this.doEscapeProcessing) {
                Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, locallyScopedConn.serverSupportsConvertFn(), this.connection);
                sql = escapedSqlResult instanceof String ? (String)escapedSqlResult : ((EscapeProcessorResult)escapedSqlResult).escapedSql;
            }
            char firstStatementChar = StringUtils.firstNonWsCharUc(sql, this.findStartOfStatement(sql));
            if (sql.charAt(0) == '/' && sql.startsWith(PING_MARKER)) {
                this.doPingInstead();
                return this.results;
            }
            this.checkForDml(sql, firstStatementChar);
            if (this.results != null && !locallyScopedConn.getHoldResultsOpenOverStatementClose()) {
                this.results.realClose(false);
            }
            CachedResultSetMetaData cachedMetaData = null;
            if (this.useServerFetch()) {
                this.results = this.createResultSetUsingServerFetch(sql);
                return this.results;
            }
            TimerTask timeoutTask = null;
            String oldCatalog = null;
            try {
                if (locallyScopedConn.getEnableQueryTimeouts() && this.timeoutInMillis != 0 && locallyScopedConn.versionMeetsMinimum(5, 0, 0)) {
                    timeoutTask = new CancelTask();
                    Connection.getCancelTimer().schedule(timeoutTask, this.timeoutInMillis);
                }
                if (!locallyScopedConn.getCatalog().equals(this.currentCatalog)) {
                    oldCatalog = locallyScopedConn.getCatalog();
                    locallyScopedConn.setCatalog(this.currentCatalog);
                }
                if (locallyScopedConn.getCacheResultSetMetadata()) {
                    cachedMetaData = locallyScopedConn.getCachedMetaData(sql);
                }
                if (locallyScopedConn.useMaxRows()) {
                    if (StringUtils.indexOfIgnoreCase(sql, "LIMIT") != -1) {
                        this.results = locallyScopedConn.execSQL(this, sql, this.maxRows, null, this.resultSetType, this.resultSetConcurrency, this.createStreamingResultSet(), this.currentCatalog, cachedMetaData == null);
                    } else {
                        if (this.maxRows <= 0) {
                            locallyScopedConn.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, null, 1003, 1007, false, this.currentCatalog, true);
                        } else {
                            locallyScopedConn.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=" + this.maxRows, -1, null, 1003, 1007, false, this.currentCatalog, true);
                        }
                        this.results = locallyScopedConn.execSQL(this, sql, -1, null, this.resultSetType, this.resultSetConcurrency, this.createStreamingResultSet(), this.currentCatalog, cachedMetaData == null);
                        if (oldCatalog != null) {
                            locallyScopedConn.setCatalog(oldCatalog);
                        }
                    }
                } else {
                    this.results = locallyScopedConn.execSQL(this, sql, -1, null, this.resultSetType, this.resultSetConcurrency, this.createStreamingResultSet(), this.currentCatalog, cachedMetaData == null);
                }
                if (timeoutTask != null) {
                    if (((CancelTask)timeoutTask).caughtWhileCancelling != null) {
                        throw ((CancelTask)timeoutTask).caughtWhileCancelling;
                    }
                    timeoutTask.cancel();
                    timeoutTask = null;
                }
                Object object3 = this.cancelTimeoutMutex;
                synchronized (object3) {
                    if (this.wasCancelled) {
                        this.wasCancelled = false;
                        throw new MySQLTimeoutException();
                    }
                }
            }
            catch (Throwable throwable) {
                if (timeoutTask != null) {
                    timeoutTask.cancel();
                }
                if (oldCatalog != null) {
                    locallyScopedConn.setCatalog(oldCatalog);
                }
                throw throwable;
            }
            if (timeoutTask != null) {
                timeoutTask.cancel();
            }
            if (oldCatalog != null) {
                locallyScopedConn.setCatalog(oldCatalog);
            }
            this.lastInsertId = this.results.getUpdateID();
            if (cachedMetaData != null) {
                locallyScopedConn.initializeResultsMetadataFromCache(sql, cachedMetaData, this.results);
            } else if (this.connection.getCacheResultSetMetadata()) {
                locallyScopedConn.initializeResultsMetadataFromCache(sql, null, this.results);
            }
            return this.results;
        }
    }

    protected void doPingInstead() throws SQLException {
        ResultSet fakeSelectOneResultSet;
        if (this.pingTarget != null) {
            this.pingTarget.doPing();
        } else {
            this.connection.ping();
        }
        this.results = fakeSelectOneResultSet = this.generatePingResultSet();
    }

    protected ResultSet generatePingResultSet() throws SQLException {
        Field[] fields = new Field[]{new Field(null, "1", -5, 1)};
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        byte[] colVal = new byte[]{49};
        rows.add(new byte[][]{colVal});
        return (ResultSet)DatabaseMetaData.buildResultSet(fields, rows, this.connection);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdate(sql, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeUpdate(String sql, boolean isBatch) throws SQLException {
        this.checkClosed();
        Connection locallyScopedConn = this.connection;
        char firstStatementChar = StringUtils.firstNonWsCharUc(sql, this.findStartOfStatement(sql));
        ResultSet rs = null;
        Object object = locallyScopedConn.getMutex();
        synchronized (object) {
            Object object2 = this.cancelTimeoutMutex;
            synchronized (object2) {
                this.wasCancelled = false;
            }
            this.checkNullOrEmptyQuery(sql);
            if (this.doEscapeProcessing) {
                Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, this.connection.serverSupportsConvertFn(), this.connection);
                sql = escapedSqlResult instanceof String ? (String)escapedSqlResult : ((EscapeProcessorResult)escapedSqlResult).escapedSql;
            }
            if (locallyScopedConn.isReadOnly()) {
                throw SQLError.createSQLException(String.valueOf(Messages.getString("Statement.42")) + Messages.getString("Statement.43"), "S1009");
            }
            if (StringUtils.startsWithIgnoreCaseAndWs(sql, "select")) {
                throw SQLError.createSQLException(Messages.getString("Statement.46"), "01S03");
            }
            if (this.results != null && !locallyScopedConn.getHoldResultsOpenOverStatementClose()) {
                this.results.realClose(false);
            }
            TimerTask timeoutTask = null;
            String oldCatalog = null;
            try {
                if (locallyScopedConn.getEnableQueryTimeouts() && this.timeoutInMillis != 0 && locallyScopedConn.versionMeetsMinimum(5, 0, 0)) {
                    timeoutTask = new CancelTask();
                    Connection.getCancelTimer().schedule(timeoutTask, this.timeoutInMillis);
                }
                if (!locallyScopedConn.getCatalog().equals(this.currentCatalog)) {
                    oldCatalog = locallyScopedConn.getCatalog();
                    locallyScopedConn.setCatalog(this.currentCatalog);
                }
                if (locallyScopedConn.useMaxRows()) {
                    locallyScopedConn.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, null, 1003, 1007, false, this.currentCatalog, true);
                }
                rs = locallyScopedConn.execSQL(this, sql, -1, null, 1003, 1007, false, this.currentCatalog, true, isBatch);
                if (timeoutTask != null) {
                    if (((CancelTask)timeoutTask).caughtWhileCancelling != null) {
                        throw ((CancelTask)timeoutTask).caughtWhileCancelling;
                    }
                    timeoutTask.cancel();
                    timeoutTask = null;
                }
                Object object3 = this.cancelTimeoutMutex;
                synchronized (object3) {
                    if (this.wasCancelled) {
                        this.wasCancelled = false;
                        throw new MySQLTimeoutException();
                    }
                }
            }
            catch (Throwable throwable) {
                if (timeoutTask != null) {
                    timeoutTask.cancel();
                }
                if (oldCatalog != null) {
                    locallyScopedConn.setCatalog(oldCatalog);
                }
                throw throwable;
            }
            if (timeoutTask != null) {
                timeoutTask.cancel();
            }
            if (oldCatalog != null) {
                locallyScopedConn.setCatalog(oldCatalog);
            }
        }
        this.results = rs;
        rs.setFirstCharOfQuery(firstStatementChar);
        this.updateCount = rs.getUpdateCount();
        int truncatedUpdateCount = 0;
        truncatedUpdateCount = this.updateCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.updateCount;
        this.lastInsertId = rs.getUpdateID();
        return truncatedUpdateCount;
    }

    @Override
    public int executeUpdate(String sql, int returnGeneratedKeys) throws SQLException {
        if (returnGeneratedKeys == 1) {
            this.checkClosed();
            Connection locallyScopedConn = this.connection;
            Object object = locallyScopedConn.getMutex();
            synchronized (object) {
                int n;
                boolean readInfoMsgState = locallyScopedConn.isReadInfoMsgEnabled();
                locallyScopedConn.setReadInfoMsgEnabled(true);
                try {
                    n = this.executeUpdate(sql);
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                }
                catch (Throwable throwable) {
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                    throw throwable;
                }
                return n;
            }
        }
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] generatedKeyIndices) throws SQLException {
        if (generatedKeyIndices != null && generatedKeyIndices.length > 0) {
            this.checkClosed();
            Connection locallyScopedConn = this.connection;
            Object object = locallyScopedConn.getMutex();
            synchronized (object) {
                int n;
                boolean readInfoMsgState = locallyScopedConn.isReadInfoMsgEnabled();
                locallyScopedConn.setReadInfoMsgEnabled(true);
                try {
                    n = this.executeUpdate(sql);
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                }
                catch (Throwable throwable) {
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                    throw throwable;
                }
                return n;
            }
        }
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] generatedKeyNames) throws SQLException {
        if (generatedKeyNames != null && generatedKeyNames.length > 0) {
            this.checkClosed();
            Connection locallyScopedConn = this.connection;
            Object object = locallyScopedConn.getMutex();
            synchronized (object) {
                int n;
                boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
                locallyScopedConn.setReadInfoMsgEnabled(true);
                try {
                    n = this.executeUpdate(sql);
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                }
                catch (Throwable throwable) {
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                    throw throwable;
                }
                return n;
            }
        }
        return this.executeUpdate(sql);
    }

    protected Calendar getCalendarInstanceForSessionOrNew() {
        if (this.connection != null) {
            return this.connection.getCalendarInstanceForSessionOrNew();
        }
        return new GregorianCalendar();
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        if (this.batchedGeneratedKeys == null) {
            return this.getGeneratedKeysInternal();
        }
        Field[] fields = new Field[]{new Field("", "GENERATED_KEY", -5, 17)};
        fields[0].setConnection(this.connection);
        return new ResultSet(this.currentCatalog, fields, new RowDataStatic(this.batchedGeneratedKeys), this.connection, this);
    }

    protected java.sql.ResultSet getGeneratedKeysInternal() throws SQLException {
        Field[] fields = new Field[]{new Field("", "GENERATED_KEY", -5, 17)};
        fields[0].setConnection(this.connection);
        ArrayList<byte[][]> rowSet = new ArrayList<byte[][]>();
        long beginAt = this.getLastInsertID();
        int numKeys = this.getUpdateCount();
        if (this.results != null) {
            String serverInfo = this.results.getServerInfo();
            if (numKeys > 0 && this.results.getFirstCharOfQuery() == 'R' && serverInfo != null && serverInfo.length() > 0) {
                numKeys = this.getRecordCountFromInfo(serverInfo);
            }
            if (beginAt > 0L && numKeys > 0) {
                int i = 0;
                while (i < numKeys) {
                    byte[][] row = new byte[][]{Long.toString(beginAt++).getBytes()};
                    rowSet.add(row);
                    ++i;
                }
            }
        }
        return new ResultSet(this.currentCatalog, fields, new RowDataStatic(rowSet), this.connection, this);
    }

    protected int getId() {
        return this.statementId;
    }

    public long getLastInsertID() {
        return this.lastInsertId;
    }

    public long getLongUpdateCount() {
        if (this.results == null) {
            return -1L;
        }
        if (this.results.reallyResult()) {
            return -1L;
        }
        return this.updateCount;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (this.maxRows <= 0) {
            return 0;
        }
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (this.results == null) {
            return false;
        }
        ResultSet nextResultSet = this.results.getNextResultSet();
        switch (current) {
            case 1: {
                if (this.results == null) break;
                this.results.close();
                this.results.clearNextResult();
                break;
            }
            case 3: {
                if (this.results != null) {
                    this.results.close();
                    this.results.clearNextResult();
                }
                this.closeAllOpenResults();
                break;
            }
            case 2: {
                if (!this.connection.getDontTrackOpenResources()) {
                    this.openResults.add(this.results);
                }
                this.results.clearNextResult();
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.getString("Statement.19"), "S1009");
            }
        }
        this.results = nextResultSet;
        if (this.results == null) {
            this.updateCount = -1L;
            this.lastInsertId = -1L;
        } else if (this.results.reallyResult()) {
            this.updateCount = -1L;
            this.lastInsertId = -1L;
        } else {
            this.updateCount = this.results.getUpdateCount();
            this.lastInsertId = this.results.getUpdateID();
        }
        return this.results != null && this.results.reallyResult();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.timeoutInMillis / 1000;
    }

    private int getRecordCountFromInfo(String serverInfo) {
        StringBuffer recordsBuf = new StringBuffer();
        int recordsCount = 0;
        int duplicatesCount = 0;
        char c = '\u0000';
        int length = serverInfo.length();
        int i = 0;
        while (i < length) {
            c = serverInfo.charAt(i);
            if (Character.isDigit(c)) break;
            ++i;
        }
        recordsBuf.append(c);
        ++i;
        while (i < length) {
            c = serverInfo.charAt(i);
            if (!Character.isDigit(c)) break;
            recordsBuf.append(c);
            ++i;
        }
        recordsCount = Integer.parseInt(recordsBuf.toString());
        StringBuffer duplicatesBuf = new StringBuffer();
        while (i < length) {
            c = serverInfo.charAt(i);
            if (Character.isDigit(c)) break;
            ++i;
        }
        duplicatesBuf.append(c);
        ++i;
        while (i < length) {
            c = serverInfo.charAt(i);
            if (!Character.isDigit(c)) break;
            duplicatesBuf.append(c);
            ++i;
        }
        duplicatesCount = Integer.parseInt(duplicatesBuf.toString());
        return recordsCount - duplicatesCount;
    }

    @Override
    public java.sql.ResultSet getResultSet() throws SQLException {
        return this.results != null && this.results.reallyResult() ? this.results : null;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    protected ResultSet getResultSetInternal() {
        return this.results;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.results == null) {
            return -1;
        }
        if (this.results.reallyResult()) {
            return -1;
        }
        int truncatedUpdateCount = 0;
        truncatedUpdateCount = this.results.getUpdateCount() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.results.getUpdateCount();
        return truncatedUpdateCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        if (this.connection != null && !this.connection.isClosed() && this.connection.versionMeetsMinimum(4, 1, 0)) {
            SQLWarning pendingWarningsFromServer = SQLError.convertShowWarningsToSQLWarnings(this.connection);
            if (this.warningChain != null) {
                this.warningChain.setNextWarning(pendingWarningsFromServer);
            } else {
                this.warningChain = pendingWarningsFromServer;
            }
            return this.warningChain;
        }
        return this.warningChain;
    }

    protected void realClose(boolean calledExplicitly, boolean closeOpenResults) throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.useUsageAdvisor && !calledExplicitly) {
            String message = String.valueOf(Messages.getString("Statement.63")) + Messages.getString("Statement.64");
            this.eventSink.consumeEvent(new ProfilerEvent(0, "", this.currentCatalog, this.connectionId, this.getId(), -1, System.currentTimeMillis(), 0L, Constants.MILLIS_I18N, null, this.pointOfOrigin, message));
        }
        if (this.results != null) {
            if (closeOpenResults) {
                boolean bl = closeOpenResults = !this.holdResultsOpenOverClose;
            }
            if (closeOpenResults && this.connection != null && !this.connection.getHoldResultsOpenOverStatementClose()) {
                try {
                    this.results.close();
                }
                catch (Exception exception) {}
                this.closeAllOpenResults();
            }
        }
        if (this.connection != null) {
            if (this.maxRowsChanged) {
                this.connection.unsetMaxRows(this);
            }
            if (!this.connection.getDontTrackOpenResources()) {
                this.connection.unregisterStatement(this);
            }
        }
        this.isClosed = true;
        this.results = null;
        this.connection = null;
        this.warningChain = null;
        this.openResults = null;
        this.batchedGeneratedKeys = null;
        this.cancelTimeoutMutex = null;
        this.pingTarget = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.doEscapeProcessing = enable;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.getString("Statement.5"), "S1009");
            }
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0 && rows != Integer.MIN_VALUE || this.maxRows != 0 && this.maxRows != -1 && rows > this.getMaxRows()) {
            throw SQLError.createSQLException(Messages.getString("Statement.7"), "S1009");
        }
        this.fetchSize = rows;
    }

    protected void setHoldResultsOpenOverClose(boolean holdResultsOpenOverClose) {
        this.holdResultsOpenOverClose = holdResultsOpenOverClose;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        int maxBuf;
        if (max < 0) {
            throw SQLError.createSQLException(Messages.getString("Statement.11"), "S1009");
        }
        int n = maxBuf = this.connection != null ? this.connection.getMaxAllowedPacket() : MysqlIO.getMaxBuf();
        if (max > maxBuf) {
            throw SQLError.createSQLException(Messages.getString("Statement.13", new Object[]{new Long(maxBuf)}), "S1009");
        }
        this.maxFieldSize = max;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max > 50000000 || max < 0) {
            throw SQLError.createSQLException(String.valueOf(Messages.getString("Statement.15")) + max + " > " + 50000000 + ".", "S1009");
        }
        if (max == 0) {
            max = -1;
        }
        this.maxRows = max;
        this.maxRowsChanged = true;
        if (this.maxRows == -1) {
            this.connection.unsetMaxRows(this);
            this.maxRowsChanged = false;
        } else {
            this.connection.maxRowsChanged(this);
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw SQLError.createSQLException(Messages.getString("Statement.21"), "S1009");
        }
        this.timeoutInMillis = seconds * 1000;
    }

    void setResultSetConcurrency(int concurrencyFlag) {
        this.resultSetConcurrency = concurrencyFlag;
    }

    void setResultSetType(int typeFlag) {
        this.resultSetType = typeFlag;
    }

    protected void getBatchedGeneratedKeys(java.sql.Statement batchedStatement) throws SQLException {
        if (this.retrieveGeneratedKeys) {
            try (java.sql.ResultSet rs = null;){
                rs = batchedStatement.getGeneratedKeys();
                while (rs.next()) {
                    this.batchedGeneratedKeys.add(new byte[][]{rs.getBytes(1)});
                }
            }
        }
    }

    protected void getBatchedGeneratedKeys() throws SQLException {
        if (this.retrieveGeneratedKeys) {
            try (java.sql.ResultSet rs = null;){
                rs = this.getGeneratedKeysInternal();
                while (rs.next()) {
                    this.batchedGeneratedKeys.add(new byte[][]{rs.getBytes(1)});
                }
            }
        }
    }

    private boolean useServerFetch() throws SQLException {
        return this.connection.isCursorFetchEnabled() && this.fetchSize > 0 && this.resultSetConcurrency == 1007 && this.resultSetType == 1003;
    }

    protected int findStartOfStatement(String sql) {
        int statementStartPos = 0;
        if (StringUtils.startsWithIgnoreCaseAndWs(sql, "/*")) {
            statementStartPos = sql.indexOf("*/");
            statementStartPos = statementStartPos == -1 ? 0 : (statementStartPos += 2);
        } else if ((StringUtils.startsWithIgnoreCaseAndWs(sql, "--") || StringUtils.startsWithIgnoreCaseAndWs(sql, "#")) && (statementStartPos = sql.indexOf(10)) == -1 && (statementStartPos = sql.indexOf(13)) == -1) {
            statementStartPos = 0;
        }
        return statementStartPos;
    }

    protected synchronized void setPingTarget(PingTarget pingTarget) {
        this.pingTarget = pingTarget;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    class CancelTask
    extends TimerTask {
        long connectionId = 0L;
        SQLException caughtWhileCancelling = null;

        CancelTask() throws SQLException {
            this.connectionId = Statement.this.connection.getIO().getThreadId();
        }

        @Override
        public void run() {
            Thread cancelThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block29: {
                        Connection cancelConn = null;
                        java.sql.Statement cancelStmt = null;
                        try {
                            try {
                                Object object = ((CancelTask)CancelTask.this).Statement.this.cancelTimeoutMutex;
                                synchronized (object) {
                                    cancelConn = ((CancelTask)CancelTask.this).Statement.this.connection.duplicate();
                                    cancelStmt = cancelConn.createStatement();
                                    cancelStmt.execute("KILL QUERY " + CancelTask.this.connectionId);
                                    ((CancelTask)CancelTask.this).Statement.this.wasCancelled = true;
                                }
                            }
                            catch (SQLException sqlEx) {
                                CancelTask.this.caughtWhileCancelling = sqlEx;
                                if (cancelStmt != null) {
                                    try {
                                        cancelStmt.close();
                                    }
                                    catch (SQLException sqlEx2) {
                                        throw new RuntimeException(sqlEx2.toString());
                                    }
                                }
                                if (cancelConn == null) break block29;
                                try {
                                    cancelConn.close();
                                }
                                catch (SQLException sqlEx3) {
                                    throw new RuntimeException(sqlEx3.toString());
                                }
                            }
                            catch (NullPointerException nullPointerException) {
                                block30: {
                                    if (cancelStmt == null) break block30;
                                    try {
                                        cancelStmt.close();
                                    }
                                    catch (SQLException sqlEx) {
                                        throw new RuntimeException(sqlEx.toString());
                                    }
                                }
                                if (cancelConn == null) break block29;
                                try {
                                    cancelConn.close();
                                }
                                catch (SQLException sqlEx) {
                                    throw new RuntimeException(sqlEx.toString());
                                }
                            }
                        }
                        finally {
                            if (cancelStmt != null) {
                                try {
                                    cancelStmt.close();
                                }
                                catch (SQLException sqlEx) {
                                    throw new RuntimeException(sqlEx.toString());
                                }
                            }
                            if (cancelConn != null) {
                                try {
                                    cancelConn.close();
                                }
                                catch (SQLException sqlEx) {
                                    throw new RuntimeException(sqlEx.toString());
                                }
                            }
                        }
                    }
                }
            };
            cancelThread.start();
        }
    }
}

