/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.mysql5_0_8.jdbc;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.zhiqim.mysql5_0_8.jdbc.CharsetMapping;
import org.zhiqim.mysql5_0_8.jdbc.Connection;

public class SingleByteCharsetConverter {
    private static final int BYTE_RANGE = 256;
    private static byte[] allBytes = new byte[256];
    private static final Map CONVERTER_MAP = new HashMap();
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static byte[] unknownCharsMap = new byte[65536];
    private char[] byteToChars = new char[256];
    private byte[] charToByteMap = new byte[65536];

    static {
        int i = -128;
        while (i <= 127) {
            SingleByteCharsetConverter.allBytes[i - -128] = (byte)i;
            ++i;
        }
        i = 0;
        while (i < unknownCharsMap.length) {
            SingleByteCharsetConverter.unknownCharsMap[i] = 63;
            ++i;
        }
    }

    public static synchronized SingleByteCharsetConverter getInstance(String encodingName, Connection conn) throws UnsupportedEncodingException, SQLException {
        SingleByteCharsetConverter instance = (SingleByteCharsetConverter)CONVERTER_MAP.get(encodingName);
        if (instance == null) {
            instance = SingleByteCharsetConverter.initCharset(encodingName);
        }
        return instance;
    }

    public static SingleByteCharsetConverter initCharset(String javaEncodingName) throws UnsupportedEncodingException, SQLException {
        if (CharsetMapping.isMultibyteCharset(javaEncodingName)) {
            return null;
        }
        SingleByteCharsetConverter converter = new SingleByteCharsetConverter(javaEncodingName);
        CONVERTER_MAP.put(javaEncodingName, converter);
        return converter;
    }

    public static String toStringDefaultEncoding(byte[] buffer, int startPos, int length) {
        return new String(buffer, startPos, length);
    }

    private SingleByteCharsetConverter(String encodingName) throws UnsupportedEncodingException {
        String allBytesString = new String(allBytes, 0, 256, encodingName);
        int allBytesLen = allBytesString.length();
        System.arraycopy(unknownCharsMap, 0, this.charToByteMap, 0, this.charToByteMap.length);
        int i = 0;
        while (i < 256 && i < allBytesLen) {
            char c;
            this.byteToChars[i] = c = allBytesString.charAt(i);
            this.charToByteMap[c] = allBytes[i];
            ++i;
        }
    }

    public final byte[] toBytes(char[] c) {
        if (c == null) {
            return null;
        }
        int length = c.length;
        byte[] bytes = new byte[length];
        int i = 0;
        while (i < length) {
            bytes[i] = this.charToByteMap[c[i]];
            ++i;
        }
        return bytes;
    }

    public final byte[] toBytes(char[] chars, int offset, int length) {
        if (chars == null) {
            return null;
        }
        if (length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = new byte[length];
        int i = 0;
        while (i < length) {
            bytes[i] = this.charToByteMap[chars[i + offset]];
            ++i;
        }
        return bytes;
    }

    public final byte[] toBytes(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        byte[] bytes = new byte[length];
        int i = 0;
        while (i < length) {
            bytes[i] = this.charToByteMap[s.charAt(i)];
            ++i;
        }
        return bytes;
    }

    public final byte[] toBytes(String s, int offset, int length) {
        if (s == null) {
            return null;
        }
        if (length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = new byte[length];
        int i = 0;
        while (i < length) {
            char c = s.charAt(i + offset);
            bytes[i] = this.charToByteMap[c];
            ++i;
        }
        return bytes;
    }

    public final String toString(byte[] buffer) {
        return this.toString(buffer, 0, buffer.length);
    }

    public final String toString(byte[] buffer, int startPos, int length) {
        char[] charArray = new char[length];
        int readpoint = startPos;
        int i = 0;
        while (i < length) {
            charArray[i] = this.byteToChars[buffer[readpoint] - -128];
            ++readpoint;
            ++i;
        }
        return new String(charArray);
    }
}

