/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.mysql5_0_8.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.zhiqim.mysql5_0_8.jdbc.CommunicationsException;
import org.zhiqim.mysql5_0_8.jdbc.Connection;
import org.zhiqim.mysql5_0_8.jdbc.Messages;
import org.zhiqim.mysql5_0_8.jdbc.NonRegisteringDriver;
import org.zhiqim.mysql5_0_8.jdbc.PingTarget;
import org.zhiqim.mysql5_0_8.jdbc.SQLError;
import org.zhiqim.mysql5_0_8.jdbc.Statement;

public class LoadBalancingConnectionProxy
implements InvocationHandler,
PingTarget {
    private static Method getLocalTimeMethod;
    private Connection currentConn;
    private List hostList;
    private Map liveConnections;
    private Map connectionsToHostsMap;
    private long[] responseTimes;
    private Map hostsToListIndexMap;
    boolean inTransaction = false;
    long transactionStartTime = 0L;
    Properties localProps;
    boolean isClosed = false;
    BalanceStrategy balancer;

    static {
        try {
            getLocalTimeMethod = System.class.getMethod("nanoTime", new Class[0]);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    LoadBalancingConnectionProxy(List hosts, Properties props) throws SQLException {
        this.hostList = hosts;
        int numHosts = this.hostList.size();
        this.liveConnections = new HashMap(numHosts);
        this.connectionsToHostsMap = new HashMap(numHosts);
        this.responseTimes = new long[numHosts];
        this.hostsToListIndexMap = new HashMap(numHosts);
        int i = 0;
        while (i < numHosts) {
            this.hostsToListIndexMap.put(this.hostList.get(i), new Integer(i));
            ++i;
        }
        this.localProps = (Properties)props.clone();
        this.localProps.remove("HOST");
        this.localProps.remove("PORT");
        this.localProps.setProperty("useLocalSessionState", "true");
        String strategy = this.localProps.getProperty("loadBalanceStrategy", "random");
        if ("random".equals(strategy)) {
            this.balancer = new RandomBalanceStrategy();
        } else if ("bestResponseTime".equals(strategy)) {
            this.balancer = new BestResponseTimeBalanceStrategy();
        } else {
            throw SQLError.createSQLException(Messages.getString("InvalidLoadBalanceStrategy", new Object[]{strategy}), "S1009");
        }
        this.pickNewConnection();
    }

    private synchronized Connection createConnectionForHost(String hostPortSpec) throws SQLException {
        Properties connProps = (Properties)this.localProps.clone();
        String[] hostPortPair = NonRegisteringDriver.parseHostPortPair(hostPortSpec);
        if (hostPortPair[1] == null) {
            hostPortPair[1] = "3306";
        }
        connProps.setProperty("HOST", hostPortSpec);
        connProps.setProperty("PORT", hostPortPair[1]);
        Connection conn = new Connection(hostPortSpec, Integer.parseInt(hostPortPair[1]), connProps, connProps.getProperty("DBNAME"), "jdbc:mysql://" + hostPortPair[0] + ":" + hostPortPair[1] + "/");
        this.liveConnections.put(hostPortSpec, conn);
        this.connectionsToHostsMap.put(conn, hostPortSpec);
        return conn;
    }

    void dealWithInvocationException(InvocationTargetException e) throws SQLException, Throwable, InvocationTargetException {
        Throwable t = e.getTargetException();
        if (t != null) {
            String sqlState;
            if (t instanceof SQLException && (sqlState = ((SQLException)t).getSQLState()) != null && sqlState.startsWith("08")) {
                this.invalidateCurrentConnection();
            }
            throw t;
        }
        throw e;
    }

    synchronized void invalidateCurrentConnection() throws SQLException {
        try {
            if (!this.currentConn.isClosed()) {
                this.currentConn.close();
            }
        }
        finally {
            this.liveConnections.remove(this.connectionsToHostsMap.get(this.currentConn));
            this.connectionsToHostsMap.remove(this.currentConn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("close".equals(methodName)) {
            Map map = this.liveConnections;
            synchronized (map) {
                Iterator allConnections = this.liveConnections.values().iterator();
                while (allConnections.hasNext()) {
                    ((Connection)allConnections.next()).close();
                }
                this.liveConnections.clear();
                this.connectionsToHostsMap.clear();
                return null;
            }
        }
        if ("isClosed".equals(methodName)) {
            return this.isClosed;
        }
        if (this.isClosed) {
            throw SQLError.createSQLException("No operations allowed after connection closed.", "08003");
        }
        if (!this.inTransaction) {
            this.inTransaction = true;
            this.transactionStartTime = LoadBalancingConnectionProxy.getLocalTimeBestResolution();
        }
        Object result = null;
        try {
            try {
                result = method.invoke((Object)this.currentConn, args);
                if (result != null) {
                    if (result instanceof Statement) {
                        ((Statement)result).setPingTarget(this);
                    }
                    result = this.proxyIfInterfaceIsJdbc(result, result.getClass());
                }
            }
            catch (InvocationTargetException e) {
                this.dealWithInvocationException(e);
                if (!"commit".equals(methodName) && !"rollback".equals(methodName)) return result;
                this.inTransaction = false;
                int hostIndex = (Integer)this.hostsToListIndexMap.get(this.connectionsToHostsMap.get(this.currentConn));
                long[] lArray = this.responseTimes;
                synchronized (this.responseTimes) {
                    this.responseTimes[hostIndex] = LoadBalancingConnectionProxy.getLocalTimeBestResolution() - this.transactionStartTime;
                    // ** MonitorExit[var9_12] (shouldn't be in output)
                    this.pickNewConnection();
                    return result;
                }
            }
        }
        catch (Throwable throwable) {
            if (!"commit".equals(methodName) && !"rollback".equals(methodName)) throw throwable;
            this.inTransaction = false;
            int hostIndex = (Integer)this.hostsToListIndexMap.get(this.connectionsToHostsMap.get(this.currentConn));
            long[] lArray = this.responseTimes;
            synchronized (this.responseTimes) {
                this.responseTimes[hostIndex] = LoadBalancingConnectionProxy.getLocalTimeBestResolution() - this.transactionStartTime;
                // ** MonitorExit[var9_13] (shouldn't be in output)
                this.pickNewConnection();
                throw throwable;
            }
        }
        if (!"commit".equals(methodName) && !"rollback".equals(methodName)) return result;
        this.inTransaction = false;
        int hostIndex = (Integer)this.hostsToListIndexMap.get(this.connectionsToHostsMap.get(this.currentConn));
        long[] lArray = this.responseTimes;
        synchronized (this.responseTimes) {
            this.responseTimes[hostIndex] = LoadBalancingConnectionProxy.getLocalTimeBestResolution() - this.transactionStartTime;
            // ** MonitorExit[var9_14] (shouldn't be in output)
            this.pickNewConnection();
            return result;
        }
    }

    private synchronized void pickNewConnection() throws SQLException {
        if (this.currentConn == null) {
            this.currentConn = this.balancer.pickConnection();
            return;
        }
        Connection newConn = this.balancer.pickConnection();
        newConn.setTransactionIsolation(this.currentConn.getTransactionIsolation());
        newConn.setAutoCommit(this.currentConn.getAutoCommit());
        this.currentConn = newConn;
    }

    Object proxyIfInterfaceIsJdbc(Object toProxy, Class clazz) {
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces.length > 0) {
            String packageName = interfaces[0].getPackage().getName();
            if ("java.sql".equals(packageName) || "javax.sql".equals(packageName)) {
                return Proxy.newProxyInstance(toProxy.getClass().getClassLoader(), interfaces, (InvocationHandler)new ConnectionErrorFiringInvocationHandler(toProxy));
            }
            return this.proxyIfInterfaceIsJdbc(toProxy, interfaces[0]);
        }
        return toProxy;
    }

    private static long getLocalTimeBestResolution() {
        if (getLocalTimeMethod != null) {
            try {
                return (Long)getLocalTimeMethod.invoke(null, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return System.currentTimeMillis();
    }

    @Override
    public synchronized void doPing() throws SQLException {
        Iterator allConns = this.liveConnections.values().iterator();
        while (allConns.hasNext()) {
            ((Connection)allConns.next()).ping();
        }
    }

    static interface BalanceStrategy {
        public Connection pickConnection() throws SQLException;
    }

    class BestResponseTimeBalanceStrategy
    implements BalanceStrategy {
        BestResponseTimeBalanceStrategy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Connection pickConnection() throws SQLException {
            long minResponseTime = Long.MAX_VALUE;
            int bestHostIndex = 0;
            long[] localResponseTimes = new long[LoadBalancingConnectionProxy.this.responseTimes.length];
            long[] lArray = LoadBalancingConnectionProxy.this.responseTimes;
            synchronized (lArray) {
                System.arraycopy(LoadBalancingConnectionProxy.this.responseTimes, 0, localResponseTimes, 0, LoadBalancingConnectionProxy.this.responseTimes.length);
            }
            SQLException ex = null;
            int attempts = 0;
            while (attempts < 1200) {
                block18: {
                    int i2 = 0;
                    while (i2 < localResponseTimes.length) {
                        long candidateResponseTime = localResponseTimes[i2];
                        if (candidateResponseTime < minResponseTime) {
                            if (candidateResponseTime == 0L) {
                                bestHostIndex = i2;
                                break;
                            }
                            bestHostIndex = i2;
                            minResponseTime = candidateResponseTime;
                        }
                        ++i2;
                    }
                    if (bestHostIndex == localResponseTimes.length - 1) {
                        long[] i2 = LoadBalancingConnectionProxy.this.responseTimes;
                        synchronized (i2) {
                            System.arraycopy(LoadBalancingConnectionProxy.this.responseTimes, 0, localResponseTimes, 0, LoadBalancingConnectionProxy.this.responseTimes.length);
                        }
                    }
                    String bestHost = (String)LoadBalancingConnectionProxy.this.hostList.get(bestHostIndex);
                    Connection conn = (Connection)LoadBalancingConnectionProxy.this.liveConnections.get(bestHost);
                    if (conn == null) {
                        try {
                            conn = LoadBalancingConnectionProxy.this.createConnectionForHost(bestHost);
                        }
                        catch (SQLException sqlEx) {
                            ex = sqlEx;
                            if (sqlEx instanceof CommunicationsException || "08S01".equals(sqlEx.getSQLState())) {
                                localResponseTimes[bestHostIndex] = Long.MAX_VALUE;
                                try {
                                    Thread.sleep(250L);
                                }
                                catch (InterruptedException interruptedException) {}
                                break block18;
                            }
                            throw sqlEx;
                        }
                    }
                    return conn;
                }
                ++attempts;
            }
            if (ex != null) {
                throw ex;
            }
            return null;
        }
    }

    protected class ConnectionErrorFiringInvocationHandler
    implements InvocationHandler {
        Object invokeOn = null;

        public ConnectionErrorFiringInvocationHandler(Object toInvokeOn) {
            this.invokeOn = toInvokeOn;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = null;
            try {
                result = method.invoke(this.invokeOn, args);
                if (result != null) {
                    result = LoadBalancingConnectionProxy.this.proxyIfInterfaceIsJdbc(result, result.getClass());
                }
            }
            catch (InvocationTargetException e) {
                LoadBalancingConnectionProxy.this.dealWithInvocationException(e);
            }
            return result;
        }
    }

    class RandomBalanceStrategy
    implements BalanceStrategy {
        RandomBalanceStrategy() {
        }

        @Override
        public Connection pickConnection() throws SQLException {
            int random = (int)(Math.random() * (double)LoadBalancingConnectionProxy.this.hostList.size());
            if (random == LoadBalancingConnectionProxy.this.hostList.size()) {
                --random;
            }
            String hostPortSpec = (String)LoadBalancingConnectionProxy.this.hostList.get(random);
            SQLException ex = null;
            int attempts = 0;
            while (attempts < 1200) {
                block9: {
                    Connection conn = (Connection)LoadBalancingConnectionProxy.this.liveConnections.get(hostPortSpec);
                    if (conn == null) {
                        try {
                            conn = LoadBalancingConnectionProxy.this.createConnectionForHost(hostPortSpec);
                        }
                        catch (SQLException sqlEx) {
                            ex = sqlEx;
                            if (sqlEx instanceof CommunicationsException || "08S01".equals(sqlEx.getSQLState())) {
                                try {
                                    Thread.sleep(250L);
                                }
                                catch (InterruptedException interruptedException) {}
                                break block9;
                            }
                            throw sqlEx;
                        }
                    }
                    return conn;
                }
                ++attempts;
            }
            if (ex != null) {
                throw ex;
            }
            return null;
        }
    }
}

