/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.util;

import java.util.Map;
import org.zhiqim.httpd.util.Scriptx;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.HtmlConstants;
import org.zhiqim.kernel.constants.RegexpConstants;
import org.zhiqim.kernel.extend.HashMapSS;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.util.Strings;

@AnAlias(value={"Scripts"})
public class Scripts
extends Scriptx
implements RegexpConstants,
HtmlConstants {
    public static String head() {
        return "<script>\r\n";
    }

    public static String tail() {
        return "</script>";
    }

    public static String src(String src) {
        return "<script src=\"" + src + "\"></script>";
    }

    public static String src(String src, String props) {
        StringBuilder strb = new StringBuilder();
        strb.append("<script");
        strb.append(" src=\"").append(src).append("\"");
        HashMapSS propMap = Jsons.toMapSS((String)props);
        for (Map.Entry entry : propMap.entrySet()) {
            strb.append(" ").append((String)entry.getKey()).append("=\"").append((String)entry.getValue()).append("\"");
        }
        strb.append("</script>");
        strb.append("\r\n");
        return strb.toString();
    }

    public static String jQuery(String version) {
        if (Strings.getTimes((String)version, (char)'.') == 1) {
            version = String.valueOf(version) + ".0";
        }
        return Scripts.src("//apps.bdimg.com/libs/jquery/" + version + "/jquery.min.js");
    }

    public static String onload(String load) {
        StringBuilder strb = new StringBuilder();
        strb.append("<script>");
        strb.append("Z.onload(function(){").append(load).append("});");
        strb.append("</script>");
        return strb.toString();
    }

    public static String formatAlertMsg(String message) {
        message = message.replaceAll("\r", "\\\\r");
        message = message.replaceAll("\n", "\\\\n");
        message = message.replaceAll("\"", "\\\\\"");
        message = message.replaceAll("'", "\\\\'");
        return message;
    }

    public static String doReloadParent() {
        return "<script>parent.location.reload();</script>";
    }

    public static String doReloadParent(String alert) {
        return "<script>top.Z.success(\"" + alert + "\", function(){parent.location.reload();});</script>";
    }

    public static String doLocationParent(String url) {
        return "<script>parent.location.href = \"" + url + "\";</script>";
    }

    public static String doLocationParent(String url, String alert) {
        return "<script>top.Z.success(\"" + alert + "\", function(){parent.location.href = \"" + url + "\";});</script>";
    }

    public static String isRegexp(String regexp) {
        return Scriptx.isRegexp(regexp, false);
    }

    public static String isNumeric() {
        return Scriptx.isNumeric(false);
    }

    public static String isInteger() {
        return Scriptx.isInteger(false);
    }

    public static String isAlphaNumeric() {
        return Scriptx.isAlphaNumeric(false);
    }

    public static String isFloat() {
        return Scriptx.isFloat(false);
    }

    public static String isAmount2R() {
        return Scriptx.isAmount2R(false);
    }

    public static String isEmail() {
        return Scriptx.isEmail(false);
    }

    public static String isIP() {
        return Scriptx.isIP(false);
    }

    public static String isMacAddress() {
        return Scriptx.isMacAddress(false);
    }

    public static String isMobile() {
        return Scriptx.isMobile(false);
    }

    public static String isMobile11() {
        return Scriptx.isMobile11(false);
    }

    public static String isDate() {
        return Scriptx.isDate(false);
    }

    public static String isTime() {
        return Scriptx.isTime(false);
    }

    public static String isDateTime() {
        return Scriptx.isDateTime(false);
    }

    public static String isIdcard() {
        return Scriptx.isIdcard(false);
    }

    public static String isPostalCode() {
        return Scriptx.isPostalCode(false);
    }

    public static String isEmpty() {
        return "function " + "isEmpty" + "(value)" + "\r\n" + "{" + "\r\n" + "    " + "if (value == null || value == '' || value.length < 1)" + "\r\n" + "    " + "    " + "return true;" + "\r\n" + "\r\n" + "    " + "for (var i=0;i<value.length;i++)" + "\r\n" + "    " + "{" + "\r\n" + "    " + "    " + "if (value.charAt(i) > String.fromCharCode(32))" + "\r\n" + "    " + "    " + "    " + "return false;" + "\r\n" + "    " + "}" + "\r\n" + "    " + "return true;" + "\r\n" + "}" + "\r\n" + "\r\n";
    }

    public static String isNotEmpty() {
        return "function " + "isNotEmpty" + "(value)" + "\r\n" + "{" + "\r\n" + "    " + "if (value == null || value == '' || value.length < 1)" + "\r\n" + "    " + "    " + "return false;" + "\r\n" + "\r\n" + "    " + "for (var i=0;i<value.length;i++)" + "\r\n" + "    " + "{" + "\r\n" + "    " + "    " + "if (value.charAt(i) > String.fromCharCode(32))" + "\r\n" + "    " + "    " + "    " + "return true;" + "\r\n" + "    " + "}" + "\r\n" + "    " + "return false;" + "\r\n" + "}" + "\r\n" + "\r\n";
    }

    public static String isEqual() {
        return "function " + "isEqual" + "(value1,value2)" + "\r\n" + "{" + "\r\n" + "    " + "if (value1 == null || value1 == '' || value1.length < 1)" + "\r\n" + "    " + "{" + "\r\n" + "    " + "    " + "if (value1 == null || value1 == '' || value1.length < 1)" + "\r\n" + "    " + "    " + "    " + "return true;" + "\r\n" + "    " + "}" + "\r\n" + "\r\n" + "    " + "if (value1 == value2)" + "\r\n" + "    " + "    " + "return true;" + "\r\n" + "    " + "return false;" + "\r\n" + "}" + "\r\n" + "\r\n";
    }

    public static String isLen() {
        return "function " + "isLen" + "(value,min,max)" + "\r\n" + "{" + "\r\n" + "    " + "if (value == null || value == '' || value.length < 1)" + "\r\n" + "    " + "{" + "\r\n" + "    " + "    " + "if (min == 0)" + "\r\n" + "    " + "    " + "    " + "return true;" + "\r\n" + "    " + "    " + "else" + "\r\n" + "    " + "    " + "    " + "return false;" + "\r\n" + "    " + "}" + "\r\n" + "\r\n" + "    " + "if (value.length < min || value.length > max)" + "\r\n" + "    " + "    " + "return false;" + "\r\n" + "    " + "return true;" + "\r\n" + "}" + "\r\n" + "\r\n";
    }

    public static String isByteLen() {
        return "function " + "isByteLen" + "(value,min,max)" + "\r\n" + "{" + "\r\n" + "    " + "if (value == null || value == '' || value.length < 1)" + "\r\n" + "    " + "{" + "\r\n" + "    " + "    " + "if (min == 0)" + "\r\n" + "    " + "    " + "    " + "return true;" + "\r\n" + "    " + "    " + "else" + "\r\n" + "    " + "    " + "    " + "return false;" + "\r\n" + "    " + "}" + "\r\n" + "\r\n" + "    " + "var byteLen = value.replace(/[^\\x00-\\xff]/g,\"xx\").length;" + "\r\n" + "    " + "if ( byteLen < min ||  byteLen > max)" + "\r\n" + "    " + "    " + "return false;" + "\r\n" + "    " + "return true;" + "\r\n" + "}" + "\r\n" + "\r\n";
    }

    public static String isNumericLen() {
        StringBuilder strb = new StringBuilder().append("function ").append("isNumericLen").append("(value, min, max)").append("\r\n").append("{").append("\r\n").append("    ").append("if (min == 0 && (value == '' || value.length == 0))").append("\r\n").append("    ").append("    ").append("return true;").append("\r\n").append("\r\n").append("    ").append("if (value == '' || value.length < 1)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("\r\n").append("    ").append("var reg = /").append("^\\d+$").append("/;").append("\r\n").append("    ").append("var flg = reg.test(value);").append("\r\n").append("    ").append("if (!flg)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("    ").append("if (value.length < min || value.length > max)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("    ").append("return true;").append("\r\n").append("}").append("\r\n").append("\r\n");
        return strb.toString();
    }

    public static String isIntegerValue() {
        return "function " + "isIntegerValue" + "(value, min, max)" + "\r\n" + "{" + "\r\n" + "    " + "if (value === undefined || value == '' || value.length < 1)" + "\r\n" + "    " + "    " + "return false;" + "\r\n" + "\r\n" + "    " + "var reg = /" + "^(0|[\\+\\-]?[1-9]\\d*)$" + "/;" + "\r\n" + "    " + "var flg = reg.test(value);" + "\r\n" + "    " + "if (!flg)" + "\r\n" + "    " + "    " + "return false;" + "\r\n" + "    " + "if (parseInt(value) < min || parseInt(value) > max)" + "\r\n" + "    " + "    " + "return false;" + "\r\n" + "    " + "return true;" + "\r\n" + "}" + "\r\n" + "\r\n";
    }

    public static String isAlphaNumericLen() {
        StringBuilder strb = new StringBuilder().append("function ").append("isAlphaNumericLen").append("(value, min, max)").append("\r\n").append("{").append("\r\n").append("    ").append("if (min == 0 && (value == '' || value.length == 0))").append("\r\n").append("    ").append("    ").append("return true;").append("\r\n").append("\r\n").append("    ").append("if (value == '' || value.length < 1)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("\r\n").append("    ").append("var reg = /").append("^[A-Za-z0-9]+$").append("/;").append("\r\n").append("    ").append("var flg = reg.test(value);").append("\r\n").append("    ").append("if (!flg)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("    ").append("if (value.length < min || value.length > max)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("    ").append("return true;").append("\r\n").append("}").append("\r\n").append("\r\n");
        return strb.toString();
    }

    public static String isAlphaNumericULLen() {
        StringBuilder strb = new StringBuilder().append("function ").append("isAlphaNumericULLen").append("(value, min, max)").append("\r\n").append("{").append("\r\n").append("    ").append("if (min == 0 && (value == '' || value.length == 0))").append("\r\n").append("    ").append("    ").append("return true;").append("\r\n").append("\r\n").append("    ").append("if (value == '' || value.length < 1)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("\r\n").append("    ").append("var reg = /").append("^[A-Za-z0-9_]+$").append("/;").append("\r\n").append("    ").append("var flg = reg.test(value);").append("\r\n").append("    ").append("if (!flg)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("    ").append("if (value.length < min || value.length > max)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("    ").append("return true;").append("\r\n").append("}").append("\r\n").append("\r\n");
        return strb.toString();
    }

    public static String isAlphaNumericPALen() {
        StringBuilder strb = new StringBuilder().append("function ").append("isAlphaNumericPALen").append("(value, min, max)").append("\r\n").append("{").append("\r\n").append("    ").append("if (min == 0 && (value == '' || value.length == 0))").append("\r\n").append("    ").append("    ").append("return true;").append("\r\n").append("\r\n").append("    ").append("if (value == '' || value.length < 1)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("\r\n").append("    ").append("var reg = /").append("^[A-Za-z][A-Za-z0-9]*$").append("/;").append("\r\n").append("    ").append("var flg = reg.test(value);").append("\r\n").append("    ").append("if (!flg)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("    ").append("if (value.length < min || value.length > max)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("    ").append("return true;").append("\r\n").append("}").append("\r\n").append("\r\n");
        return strb.toString();
    }

    public static String isAlphaNumericUlLen() {
        StringBuilder strb = new StringBuilder().append("function ").append("isAlphaNumericULLen").append("(value, min, max)").append("\r\n").append("{").append("\r\n").append("    ").append("if (min == 0 && (value == '' || value.length == 0))").append("\r\n").append("    ").append("    ").append("return true;").append("\r\n").append("\r\n").append("    ").append("if (value == '' || value.length < 1)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("\r\n").append("    ").append("var reg = /").append("^[A-Za-z0-9_]+$").append("/;").append("\r\n").append("    ").append("var flg = reg.test(value);").append("\r\n").append("    ").append("if (!flg)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("    ").append("if (value.length < min || value.length > max)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("    ").append("return true;").append("\r\n").append("}").append("\r\n").append("\r\n");
        return strb.toString();
    }

    public static String isAlphaNumericDotLen() {
        StringBuilder strb = new StringBuilder().append("function ").append("isAlphaNumericDotLen").append("(value, min, max)").append("\r\n").append("{").append("\r\n").append("    ").append("if (min == 0 && (value == '' || value.length == 0))").append("\r\n").append("    ").append("    ").append("return true;").append("\r\n").append("\r\n").append("    ").append("if (value == '' || value.length < 1)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("\r\n").append("    ").append("var reg = /").append("^[A-Za-z0-9\\.]+$").append("/;").append("\r\n").append("    ").append("var flg = reg.test(value);").append("\r\n").append("    ").append("if (!flg)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("    ").append("if (value.length < min || value.length > max)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("    ").append("return true;").append("\r\n").append("}").append("\r\n").append("\r\n");
        return strb.toString();
    }

    public static String isAlphaNumericUrlLen() {
        StringBuilder strb = new StringBuilder().append("function ").append("isAlphaNumericUrlLen").append("(value, min, max)").append("\r\n").append("{").append("\r\n").append("    ").append("if (min == 0 && (value == '' || value.length == 0))").append("\r\n").append("    ").append("    ").append("return true;").append("\r\n").append("\r\n").append("    ").append("if (value == '' || value.length < 1)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("\r\n").append("    ").append("var reg = /").append("^[A-Za-z0-9\\.\\-_~]+$").append("/;").append("\r\n").append("    ").append("var flg = reg.test(value);").append("\r\n").append("    ").append("if (!flg)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("    ").append("if (value.length < min || value.length > max)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("    ").append("return true;").append("\r\n").append("}").append("\r\n").append("\r\n");
        return strb.toString();
    }

    public static String isAlphaNumericUlPALen() {
        StringBuilder strb = new StringBuilder().append("function ").append("isAlphaNumericULPALen").append("(value, min, max)").append("\r\n").append("{").append("\r\n").append("    ").append("if (min == 0 && (value == '' || value.length == 0))").append("\r\n").append("    ").append("    ").append("return true;").append("\r\n").append("\r\n").append("    ").append("if (value == '' || value.length < 1)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("\r\n").append("    ").append("var reg = /").append("^[A-Za-z_][A-Za-z0-9_]*$").append("/;").append("\r\n").append("    ").append("var flg = reg.test(value);").append("\r\n").append("    ").append("if (!flg)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("    ").append("if (value.length < min || value.length > max)").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("    ").append("return true;").append("\r\n").append("}").append("\r\n").append("\r\n");
        return strb.toString();
    }

    public static String isScope(String scope) {
        return "function " + "isScope" + "(value)" + "\r\n" + "{" + "\r\n" + "    " + "if (value === undefined || value == '' || value.length < 1)" + "\r\n" + "    " + "    " + "return false;" + "\r\n" + "\r\n" + "    " + "for (var i=0;i<value.length;i++)" + "\r\n" + "    " + "{" + "\r\n" + "    " + "    " + "var charValue = value.substring(i,i+1);" + "\r\n" + "    " + "    " + "var accord = \"" + scope + "\";" + "\r\n" + "    " + "    " + "if (accord.indexOf(charValue) == -1)" + "\r\n" + "    " + "    " + "    " + "return false;" + "\r\n" + "    " + "}" + "\r\n" + "\r\n" + "    " + "return true;" + "\r\n" + "}" + "\r\n" + "\r\n";
    }

    public static String isSelect() {
        return "function " + "isSelect" + "(form, field)" + "\r\n" + "{" + "\r\n" + "    " + "if(typeof(form[field].length)==\"number\")" + "\r\n" + "    " + "{" + "\r\n" + "    " + "    " + "var len = form[field].length;" + "\r\n" + "    " + "    " + "for (var i=0;i<len;i++)" + "\r\n" + "    " + "    " + "{" + "\r\n" + "    " + "    " + "    " + "if(form[field][i].selected)" + "\r\n" + "    " + "    " + "    " + "    " + "return true;" + "\r\n" + "    " + "    " + "}" + "\r\n" + "    " + "    " + "return false;" + "\r\n" + "    " + "}" + "\r\n" + "\r\n" + "    " + "return form[field].selected;" + "\r\n" + "}" + "\r\n" + "\r\n";
    }

    public static String isChecked() {
        return "function " + "isChecked" + "(form, field)" + "\r\n" + "{" + "\r\n" + "    " + "if(typeof(form[field].length)==\"number\")" + "\r\n" + "    " + "{" + "\r\n" + "    " + "    " + "var len = form[field].length;" + "\r\n" + "    " + "    " + "for (var i=0;i<len;i++)" + "\r\n" + "    " + "    " + "{" + "\r\n" + "    " + "    " + "    " + "if(form[field][i].checked)" + "\r\n" + "    " + "    " + "    " + "    " + "return true;" + "\r\n" + "    " + "    " + "}" + "\r\n" + "    " + "    " + "return false;" + "\r\n" + "    " + "}" + "\r\n" + "\r\n" + "    " + "return form[field].checked;" + "\r\n" + "}" + "\r\n" + "\r\n";
    }

    public static String isGreaterEqualThen() {
        return "function " + "isGreaterEqualThen" + "(value1, value2)" + "\r\n" + "{" + "\r\n" + "    " + "if (value1 > value2 || value1 == value2)" + "\r\n" + "    " + "    " + "return true;" + "\r\n" + "    " + "return false;" + "\r\n" + "}" + "\r\n" + "\r\n";
    }

    public static String isGreaterThen() {
        return "function " + "isGreaterThen" + "(value1, value2)" + "\r\n" + "{" + "\r\n" + "    " + "if (value1 > value2)" + "\r\n" + "    " + "    " + "return true;" + "\r\n" + "    " + "return false;" + "\r\n" + "}" + "\r\n" + "\r\n";
    }

    public static String isLessEqualThen() {
        return "function " + "isLessEqualThen" + "(value1, value2)" + "\r\n" + "{" + "\r\n" + "    " + "if (value1 < value2 || value1 == value2)" + "\r\n" + "    " + "    " + "return true;" + "\r\n" + "    " + "return false;" + "\r\n" + "}" + "\r\n" + "\r\n";
    }

    public static String isLessThen() {
        return "function " + "isLessThen" + "(value1, value2)" + "\r\n" + "{" + "\r\n" + "    " + "if (value1 < value2)" + "\r\n" + "    " + "    " + "return true;" + "\r\n" + "    " + "return false;" + "\r\n" + "}" + "\r\n" + "\r\n";
    }

    public static String startWith() {
        return "String.prototype.startWith=function(str)" + "\r\n" + "{" + "\r\n" + "    " + "if(str==null||str==\"\"||this.length==0||str.length>this.length)" + "\r\n" + "    " + "    " + "return false;" + "\r\n" + "    " + "if(this.substr(0,str.length)==str)" + "\r\n" + "    " + "    " + "return true;" + "\r\n" + "    " + "else" + "\r\n" + "    " + "    " + "return false;" + "\r\n" + "}" + "\r\n";
    }

    public static String endWith() {
        return "String.prototype.endWith=function(str)" + "\r\n" + "{" + "\r\n" + "    " + "if(str==null||str==\"\"||this.length==0||str.length>this.length)" + "\r\n" + "    " + "    " + "return false;" + "\r\n" + "    " + "if(this.substring(this.length-str.length)==str)" + "\r\n" + "    " + "    " + "return true;" + "\r\n" + "    " + "else" + "\r\n" + "    " + "    " + "return false;" + "\r\n" + "}" + "\r\n";
    }

    public static String ltrim() {
        StringBuilder strb = new StringBuilder();
        strb.append("function ").append("ltrim(value)").append("\r\n");
        strb.append("{").append("\r\n");
        strb.append("    ").append("var w_space = String.fromCharCode(32);").append("\r\n");
        strb.append("    ").append("var v_length = value.length;").append("\r\n");
        strb.append("    ").append("if(v_length < 1)").append("\r\n");
        strb.append("    ").append("    ").append("return \"\"").append("\r\n");
        strb.append("\r\n");
        strb.append("    ").append("var strTemp = \"\";").append("\r\n");
        strb.append("    ").append("var iTemp = 0;").append("\r\n");
        strb.append("    ").append("while(iTemp < v_length)").append("\r\n");
        strb.append("    ").append("{").append("\r\n");
        strb.append("    ").append("    ").append("if(value.charAt(iTemp) != w_space)").append("\r\n");
        strb.append("    ").append("    ").append("{").append("\r\n");
        strb.append("    ").append("    ").append("    ").append("strTemp = value.substring(iTemp,v_length);").append("\r\n");
        strb.append("    ").append("    ").append("    ").append("break;").append("\r\n");
        strb.append("    ").append("    ").append("}").append("\r\n");
        strb.append("    ").append("    ").append("iTemp = iTemp + 1;").append("\r\n");
        strb.append("    ").append("}").append("\r\n");
        strb.append("    ").append("return strTemp;").append("\r\n");
        strb.append("}").append("\r\n");
        return strb.toString();
    }

    public static String rtrim() {
        StringBuilder strb = new StringBuilder();
        strb.append("function ").append("rtrim(value)").append("\r\n");
        strb.append("{//\u53bb\u9664\u53f3\u7a7a\u683c").append("\r\n");
        strb.append("    ").append("var w_space = String.fromCharCode(32);").append("\r\n");
        strb.append("    ").append("var v_length = value.length;").append("\r\n");
        strb.append("    ").append("if(v_length < 1)").append("\r\n");
        strb.append("    ").append("    ").append("return \"\"").append("\r\n");
        strb.append("\r\n");
        strb.append("    ").append("var strTemp = \"\";").append("\r\n");
        strb.append("    ").append("var iTemp = 0;").append("\r\n");
        strb.append("    ").append("while(iTemp < v_length)").append("\r\n");
        strb.append("    ").append("{").append("\r\n");
        strb.append("    ").append("    ").append("if(value.charAt(iTemp) != w_space)").append("\r\n");
        strb.append("    ").append("    ").append("{").append("\r\n");
        strb.append("    ").append("    ").append("    ").append("strTemp = value.substring(iTemp,v_length);").append("\r\n");
        strb.append("    ").append("    ").append("    ").append("break;").append("\r\n");
        strb.append("    ").append("    ").append("}").append("\r\n");
        strb.append("    ").append("    ").append("iTemp = iTemp + 1;").append("\r\n");
        strb.append("    ").append("}").append("\r\n");
        strb.append("    ").append("return strTemp;").append("\r\n");
        strb.append("}").append("\r\n");
        return strb.toString();
    }

    public static String trim() {
        StringBuilder strb = new StringBuilder();
        strb.append("function ").append("trim(value)").append("\r\n");
        strb.append("{//\u53bb\u9664\u4e24\u8fb9\u7a7a\u683c").append("\r\n");
        strb.append("    ").append("var w_space = String.fromCharCode(32);").append("\r\n");
        strb.append("    ").append("var v_length = value.length;").append("\r\n");
        strb.append("    ").append("if(v_length < 1)").append("\r\n");
        strb.append("    ").append("    ").append("return \"\"").append("\r\n");
        strb.append("\r\n");
        strb.append("    ").append("var strTemp = \"\";").append("\r\n");
        strb.append("    ").append("var iTemp = 0;").append("\r\n");
        strb.append("    ").append("while(iTemp < v_length)").append("\r\n");
        strb.append("    ").append("{").append("\r\n");
        strb.append("    ").append("    ").append("if(value.charAt(iTemp) != w_space)").append("\r\n");
        strb.append("    ").append("    ").append("{").append("\r\n");
        strb.append("    ").append("    ").append("    ").append("strTemp = value.substring(iTemp,v_length);").append("\r\n");
        strb.append("    ").append("    ").append("    ").append("break;").append("\r\n");
        strb.append("    ").append("    ").append("}").append("\r\n");
        strb.append("    ").append("    ").append("iTemp = iTemp + 1;").append("\r\n");
        strb.append("    ").append("}").append("\r\n");
        strb.append("\r\n");
        strb.append("    ").append("v_length = strTemp.length;").append("\r\n");
        strb.append("    ").append("if(v_length < 1)").append("\r\n");
        strb.append("    ").append("    ").append("return \"\"").append("\r\n");
        strb.append("\r\n");
        strb.append("    ").append("var strTemp2 = \"\";").append("\r\n");
        strb.append("    ").append("var iTemp2 = v_length;").append("\r\n");
        strb.append("    ").append("while(iTemp2 > 0)").append("\r\n");
        strb.append("    ").append("{").append("\r\n");
        strb.append("    ").append("    ").append("if(strTemp.charAt(iTemp2-1) != w_space)").append("\r\n");
        strb.append("    ").append("    ").append("{").append("\r\n");
        strb.append("    ").append("    ").append("    ").append("strTemp2 = strTemp.substring(0,iTemp2);").append("\r\n");
        strb.append("    ").append("    ").append("    ").append("break;").append("\r\n");
        strb.append("    ").append("    ").append("}").append("\r\n");
        strb.append("    ").append("    ").append("iTemp2 = iTemp2 + 1;").append("\r\n");
        strb.append("    ").append("}").append("\r\n");
        strb.append("    ").append("return strTemp2;").append("\r\n");
        strb.append("}").append("\r\n");
        return strb.toString();
    }

    public static String doSelectBox() {
        return "function doSelectBox(boxName)" + "\r\n" + "{//\u4eceRadio\u4e2d\u8bfb\u53d6\u9009\u4e2d\u7684\u4e00\u9879" + "\r\n" + "    " + "var obj = document.getElementsByName(boxName);" + "\r\n" + "    " + "for(var i=0;i<obj.length;i++)" + "\r\n" + "    " + "{" + "\r\n" + "    " + "    " + "if(obj[i].checked) " + "\r\n" + "    " + "    " + "    " + "return obj[i].value;" + "\r\n" + "    " + "}" + "\r\n" + "    " + "alert('\u8bf7\u9009\u62e9\u4e00\u4e2a\u9009\u9879');" + "\r\n" + "    " + "return false;" + "\r\n" + "}" + "\r\n";
    }

    public static String doClearForm() {
        return "function doClearForm(form)" + "\r\n" + "{" + "\r\n" + "    " + "form.reset();" + "\r\n" + "    " + "var length = form.elements.length;" + "\r\n" + "    " + "for (var i=0;i<length;i++)" + "\r\n" + "    " + "{" + "\r\n" + "    " + "    " + "var element = form.elements[i];" + "\r\n" + "    " + "    " + "if (element.type == \"text\" || element.type == \"textarea\")" + "\r\n" + "    " + "    " + "    " + "element.value = \"\";" + "\r\n" + "    " + "    " + "else if (element.type == \"select-one\")" + "\r\n" + "    " + "    " + "{" + "\r\n" + "    " + "    " + "    " + "if (element.options.length > 0)" + "\r\n" + "    " + "    " + "    " + "    " + "element.options[0].selected = true;" + "\r\n" + "    " + "    " + "}" + "\r\n" + "    " + "}" + "\r\n" + "}" + "\r\n";
    }

    public static String setFormButtonGray() {
        return "function setFormButtonGray(form)" + "\r\n" + "{//\u9a8c\u8bc1\u6309\u94ae\u53d8\u7070" + "\r\n" + "    " + "for (var i=0;i<form.length;i++)" + "\r\n" + "    " + "{//\u63d0\u4ea4\u540esubmit,reset\u4e3a\u7070\u8272" + "\r\n" + "    " + "    " + "var elem = form.elements[i];" + "\r\n" + "    " + "    " + "if(elem.type.toLowerCase() != \"submit\" && elem.type.toLowerCase() != \"reset\")" + "\r\n" + "    " + "    " + "    " + "continue;" + "\r\n" + "\r\n" + "    " + "    " + "if (typeof elem.getAttribute === undefined)" + "\r\n" + "    " + "    " + "    " + "elem[\"disabled\"]=true;" + "\r\n" + "    " + "    " + "else" + "\r\n" + "    " + "    " + "    " + "elem.setAttribute(\"disabled\", true);" + "\r\n" + "    " + "}" + "\r\n" + "\r\n" + "}" + "\r\n";
    }

    public static String setFormButtonResume() {
        return "function setFormButtonResume(param)" + "\r\n" + "{//\u4f20\u5165form\u8868\u5355\u5bf9\u8c61\u6216form\u7d22\u5f15\u53f7" + "\r\n" + "    " + "var form = (param instanceof HTMLFormElement)?param:document.forms[param];" + "\r\n" + "    " + "for (var i=0;i<form.length;i++)" + "\r\n" + "    " + "{" + "\r\n" + "    " + "    " + "var elem=form.elements[i];" + "\r\n" + "    " + "    " + "if(elem.type.toLowerCase()!=\"submit\" && elem.type.toLowerCase()!=\"reset\")" + "\r\n" + "    " + "    " + "    " + "continue;" + "\r\n" + "\r\n" + "    " + "    " + "if (\"disabled\" in elem)" + "\r\n" + "    " + "    " + "    " + "elem[\"disabled\"]=false;" + "\r\n" + "    " + "    " + "else" + "\r\n" + "    " + "    " + "    " + "elem.setAttribute(\"disabled\", false);" + "\r\n" + "    " + "}" + "\r\n" + "}" + "\r\n";
    }

    public static String setButtonGray() {
        return "function setFormButtonGray(form)" + "\r\n" + "{//\u9a8c\u8bc1\u6309\u94ae\u53d8\u7070" + "\r\n" + "    " + "for (var i=0;i<form.length;i++)" + "\r\n" + "    " + "{//\u63d0\u4ea4\u540esubmit,reset\u4e3a\u7070\u8272" + "\r\n" + "    " + "    " + "var elem = form.elements[i];" + "\r\n" + "    " + "    " + "if(elem.type.toLowerCase() != \"submit\" && elem.type.toLowerCase() != \"reset\")" + "\r\n" + "    " + "    " + "    " + "continue;" + "\r\n" + "\r\n" + "    " + "    " + "if (typeof elem.getAttribute === undefined)" + "\r\n" + "    " + "    " + "    " + "elem[\"disabled\"]=true;" + "\r\n" + "    " + "    " + "else" + "\r\n" + "    " + "    " + "    " + "elem.setAttribute(\"disabled\", true);" + "\r\n" + "    " + "}" + "\r\n" + "\r\n" + "}" + "\r\n";
    }

    public static String setButtonResume() {
        return "function setFormButtonResume(param)" + "\r\n" + "{//\u4f20\u5165form\u8868\u5355\u5bf9\u8c61\u6216form\u7d22\u5f15\u53f7" + "\r\n" + "    " + "var form = (param instanceof HTMLFormElement)?param:document.forms[param];" + "\r\n" + "    " + "for (var i=0;i<form.length;i++)" + "\r\n" + "    " + "{" + "\r\n" + "    " + "    " + "var elem=form.elements[i];" + "\r\n" + "    " + "    " + "if(elem.type.toLowerCase()!=\"submit\" && elem.type.toLowerCase()!=\"reset\")" + "\r\n" + "    " + "    " + "    " + "continue;" + "\r\n" + "\r\n" + "    " + "    " + "if (\"disabled\" in elem)" + "\r\n" + "    " + "    " + "    " + "elem[\"disabled\"]=false;" + "\r\n" + "    " + "    " + "else" + "\r\n" + "    " + "    " + "    " + "elem.setAttribute(\"disabled\", false);" + "\r\n" + "    " + "}" + "\r\n" + "}" + "\r\n";
    }

    public static String toFen() {
        return "function toFen(value)" + "\r\n" + "{//\u5c06\u5143\u8f6c\u6362\u6210\u5206" + "\r\n" + "    " + "var reg = /^(\\d+).?(\\d{0,2})$/;" + "\r\n" + "    " + "var r = value.match(reg);" + "\r\n" + "    " + "if (r == null)" + "\r\n" + "    " + "    " + "return -1;" + "\r\n" + "\r\n" + "    " + "if (r[2] == null || r[2] == '')" + "\r\n" + "    " + "    " + "return parseInt(r[1]) * 100;" + "\r\n" + "    " + "else if (r[2].length == 1)" + "\r\n" + "    " + "    " + "return parseInt(r[1]) * 100 + parseInt(r[2]) * 10;" + "\r\n" + "    " + "else" + "\r\n" + "    " + "    " + "return parseInt(r[1]) * 100 + parseInt(r[2]);" + "\r\n" + "}" + "\r\n";
    }

    public static String doPriceKeyUp() {
        return "function doPriceKeyUp(element)" + "\r\n" + "{//\u8f93\u5165\u91d1\u989d\u65f6\u8fdb\u884c\u63a7\u5236" + "\r\n" + "    " + "var value = element.value;" + "\r\n" + "    " + "if (value == null || value.length < 1)" + "\r\n" + "    " + "    " + "return;" + "\r\n" + "\r\n" + "    " + "var c = value.substr(value.length-1, 1);" + "\r\n" + "    " + "if (!(c=='0'||c=='1'||c=='2'||c=='3'||c=='4'||c=='5'||c=='6'||c=='7'||c=='8'||c=='9'||c=='.'))" + "\r\n" + "    " + "{//\u53ea\u5141\u8bb8\u8f93\u5165\u6570\u5b57\u548c\u70b9\u53f7\uff0c\u4e0d\u662f\u5373\u9000\u683c" + "\r\n" + "    " + "    " + "element.value = value.substr(0, value.length-1);" + "\r\n" + "    " + "    " + "return;" + "\r\n" + "    " + "}" + "\r\n" + "\r\n" + "    " + "if (c == '.' && value.indexOf(\".\") != value.length-1)" + "\r\n" + "    " + "{//\u5f53\u524d\u8f93\u5165\u662f\u70b9\u53f7\uff0c\u5982\u679c\u524d\u9762\u6709\u70b9\u53f7\uff0c\u5219\u9000\u683c" + "\r\n" + "    " + "    " + "element.value = value.substr(0, value.length-1);" + "\r\n" + "    " + "    " + "return;" + "\r\n" + "    " + "}" + "\r\n" + "\r\n" + "    " + "while (value.length > 1 && value.charAt(0) == '0' && value.charAt(1) != '.')" + "\r\n" + "    " + "{//\u53bb\u9664\u591a\u4f59\u7684\u524d\u7f000" + "\r\n" + "    " + "    " + "value = value.substr(1, value.length);" + "\r\n" + "    " + "}" + "\r\n" + "\r\n" + "    " + "if (value.charAt(0) == '.')" + "\r\n" + "    " + "{//\u5982\u679c\u7b2c\u4e00\u5b57\u7b26\u4e3a\u70b9\u53f7\uff0c\u5219\u524d\u88650" + "\r\n" + "    " + "    " + "value = \"0\"+value;" + "\r\n" + "    " + "}" + "\r\n" + "\r\n" + "    " + "//\u5c0f\u6570\u540e\u53ea\u4fdd\u7559\u6700\u591a\u4e24\u4f4d\uff0c\u591a\u4f59\u9000\u683c" + "\r\n" + "    " + "var ind = value.indexOf(\".\");" + "\r\n" + "    " + "if (ind != -1 && ind < value.length-2-1)" + "\r\n" + "    " + "    " + "element.value = value.substr(0, ind+2+1);" + "\r\n" + "    " + "else" + "\r\n" + "    " + "    " + "element.value = value" + "\r\n" + "}" + "\r\n";
    }

    public static String doCheckCounter(int len) {
        return "function doCheckCounter(checkId, remainId)" + "\r\n" + "{" + "\r\n" + "    " + "var content = document.getElementById(checkId).value;" + "\r\n" + "    " + "if(content.length == 0)" + "\r\n" + "    " + "    " + ("document.getElementById(remainId).innerHTML = \"" + len + "\";") + "\r\n" + "\r\n" + "    " + "var num = 0;//\u9884\u671f\u8ba1\u6570\uff1a\u4e2d\u65872\u5b57\u8282\uff0c\u82f1\u65871\u5b57\u8282" + "\r\n" + "    " + "var temp = '';//\u4e34\u65f6\u5b57\u7b26\u4e32" + "\r\n" + "    " + "for(var i=0;i<content.length;i++)" + "\r\n" + "    " + "{" + "\r\n" + "    " + "    " + "if(content.charCodeAt(i) > 127)" + "\r\n" + "    " + "    " + "    " + "num += 2;" + "\r\n" + "    " + "    " + "else" + "\r\n" + "    " + "    " + "    " + "num++;" + "\r\n" + "    " + "    " + ("if(num > " + len + ")") + "\r\n" + "    " + "    " + "{" + "\r\n" + "    " + "    " + "    " + "document.getElementById(checkId).value = temp;" + "\r\n" + "    " + "    " + "    " + "return;" + "\r\n" + "    " + "    " + "}" + "\r\n" + "    " + "    " + "temp += content.charAt(i);" + "\r\n" + "    " + "    " + ("document.getElementById(remainId).innerHTML = \"\"+(" + len + " - num);") + "\r\n" + "    " + "}" + "\r\n" + "}" + "\r\n";
    }

    public static String getConfirm(String message) {
        StringBuilder strb = new StringBuilder();
        strb.append("    ").append("if(!confirm(\"").append(message).append("\"))").append("\r\n").append("    ").append("    ").append("return false;").append("\r\n").append("\r\n");
        return strb.toString();
    }

    public static String getGraySubmit(boolean firefox) {
        StringBuilder strb = new StringBuilder();
        if (!firefox) {
            strb.append("    ").append("setFormButtonGray(form);").append("\r\n");
        } else {
            strb.append("    ").append("if (Z && Z.onload)").append("\r\n").append("    ").append("{//firefox\u8981\u6c42F && Z.onload\u65f6\u624d\u652f\u6301\u63d0\u4ea4\u53d8\u7070\u548c\u56de\u9000\u6062\u590d").append("\r\n").append("\r\n").append("    ").append("    ").append("setFormButtonGray(form);").append("\r\n").append("    ").append("    ").append("Z.onload(function(form){setFormButtonResume(form);}, form);").append("\r\n").append("    ").append("}").append("\r\n").append("\r\n");
        }
        return strb.toString();
    }

    public static String getFormIndexTarget() {
        StringBuilder strb = new StringBuilder();
        strb.append("    ").append("if (form.target === \"fCallFrame\")").append("\r\n").append("    ").append("{").append("\r\n");
        strb.append("    ").append("    ").append("if (!form.frameTarget)").append("\r\n").append("    ").append("    ").append("{").append("\r\n").append("    ").append("    ").append("    ").append("var frameTarget = document.createElement(\"input\");").append("\r\n").append("    ").append("    ").append("    ").append("frameTarget.name = \"frameTarget\";").append("\r\n").append("    ").append("    ").append("    ").append("frameTarget.type = \"hidden\";").append("\r\n").append("    ").append("    ").append("    ").append("form.appendChild(frameTarget);").append("\r\n").append("    ").append("    ").append("}").append("\r\n").append("    ").append("    ").append("form.frameTarget.value = \"frameTarget\";").append("\r\n").append("\r\n");
        strb.append("    ").append("    ").append("if (!form.formIndex)").append("\r\n").append("    ").append("    ").append("{").append("\r\n").append("    ").append("    ").append("    ").append("var formIndex = document.createElement(\"input\");").append("\r\n").append("    ").append("    ").append("    ").append("formIndex.name = \"formIndex\";").append("\r\n").append("    ").append("    ").append("    ").append("formIndex.type = \"hidden\";").append("\r\n").append("    ").append("    ").append("    ").append("form.appendChild(formIndex);").append("\r\n").append("    ").append("    ").append("}").append("\r\n");
        strb.append("    ").append("    ").append("var ind = -1;").append("\r\n").append("    ").append("    ").append("for (var i=0;i<document.forms.length;i++)").append("\r\n").append("    ").append("    ").append("{").append("\r\n").append("    ").append("    ").append("    ").append("if (form == document.forms[i])").append("\r\n").append("    ").append("    ").append("    ").append("{").append("\r\n").append("    ").append("    ").append("    ").append("    ").append("ind = i;").append("\r\n").append("    ").append("    ").append("    ").append("    ").append("break;").append("\r\n").append("    ").append("    ").append("    ").append("}").append("\r\n").append("    ").append("    ").append("}").append("\r\n");
        strb.append("    ").append("    ").append("form.formIndex.value = ind;").append("\r\n");
        strb.append("    ").append("}").append("\r\n").append("\r\n");
        return strb.toString();
    }

    public static String buildValidateScript(String name, String field, String alert, String elementId, boolean isFocus) {
        StringBuilder strb = new StringBuilder();
        strb.append("    ").append("if(!").append(name).append("(form.").append(field).append(".value))").append("\r\n");
        strb.append(Scripts.buildValidateScriptInner(field, alert, elementId, isFocus));
        return strb.toString();
    }

    public static String buildValidateScriptField(String name, String field, String alert, String elementId, boolean isFocus) {
        StringBuilder strb = new StringBuilder();
        strb.append("    ").append("if(!").append(name).append("(form, '").append(field).append("'))").append("\r\n");
        strb.append(Scripts.buildValidateScriptInner(field, alert, elementId, isFocus));
        return strb.toString();
    }

    public static String buildValidateScriptValue(String name, String field, String alert, String elementId, boolean isFocus, String value) {
        StringBuilder strb = new StringBuilder();
        strb.append("    ").append("if(!").append(name).append("(form.").append(field).append(".value, ").append(value).append("))").append("\r\n");
        strb.append(Scripts.buildValidateScriptInner(field, alert, elementId, isFocus));
        return strb.toString();
    }

    public static String buildValidateScriptTwo(String name, String field, String field2, String alert, String elementId, boolean isFocus) {
        StringBuilder strb = new StringBuilder();
        strb.append("    ").append("if(!").append(name).append("(form.").append(field).append(".value, form.").append(field2).append(".value))").append("\r\n");
        strb.append(Scripts.buildValidateScriptInner(field, alert, elementId, isFocus));
        return strb.toString();
    }

    public static String buildValidateScriptMinMax(String name, String field, String alert, String elementId, boolean isFocus, int min, int max) {
        StringBuilder strb = new StringBuilder();
        strb.append("    ").append("if(!").append(name).append("(form.").append(field).append(".value, ").append(min).append(", ").append(max).append("))").append("\r\n");
        strb.append(Scripts.buildValidateScriptInner(field, alert, elementId, isFocus));
        return strb.toString();
    }

    private static String buildValidateScriptInner(String field, String alert, String elementId, boolean isFocus) {
        StringBuilder strb = new StringBuilder();
        strb.append("    ").append("{").append("\r\n");
        if (elementId == null) {
            strb.append("    ").append("    ").append("(Z || window).failure('").append(alert).append("');").append("\r\n");
        } else {
            strb.append("    ").append("    ").append("document.getElementById(\"").append(elementId).append("\").innerHTML='").append(alert).append("';").append("\r\n");
        }
        if (isFocus) {
            strb.append("    ").append("    ").append("form.").append(field).append(".focus();").append("\r\n");
        }
        strb.append("    ").append("    ").append("return false;").append("\r\n");
        strb.append("    ").append("}").append("\r\n").append("\r\n");
        return strb.toString();
    }
}

