/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.context.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpExecutor;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.constants.HttpMimeType;
import org.zhiqim.httpd.context.ZmlContextConstants;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Resources;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;

public class ResourceService
implements HttpExecutor,
ZmlContextConstants {
    private static final Log log = LogFactory.getLog(ResourceService.class);
    private final HashMap<String, byte[]> resourceMap = new HashMap();
    private final String lastModifiedTime = DateTimes.getDateTimeHttp();

    public ResourceService() {
        try {
            List fileNameList = Resources.getResourceFileNameList(ResourceService.class, (String)"/org/zhiqim/httpd/context/service/resource/");
            List imageList = Resources.getResourceFileNameList(ResourceService.class, (String)"/org/zhiqim/httpd/context/service/resource/image/");
            for (String image : imageList) {
                fileNameList.add("image/" + image);
            }
            List fontList = Resources.getResourceFileNameList(ResourceService.class, (String)"/org/zhiqim/httpd/context/service/resource/font/");
            for (String font : fontList) {
                fileNameList.add("font/" + font);
            }
            List swfList = Resources.getResourceFileNameList(ResourceService.class, (String)"/org/zhiqim/httpd/context/service/resource/swf/");
            for (String swf : swfList) {
                fileNameList.add("swf/" + swf);
            }
            for (String fileName : fileNameList) {
                this.resourceMap.put(fileName, Streams.getBytesClassPath(ResourceService.class, (String)("/org/zhiqim/httpd/context/service/resource/" + fileName)));
            }
        }
        catch (IOException e) {
            log.error((Object)"\u521d\u59cb\u5316\u7cfb\u7edf\u8d44\u6e90\u6587\u4ef6\u65f6\u5931\u8d25", (Throwable)e, new Object[0]);
        }
    }

    @Override
    public boolean isMatch(String pathInContext) {
        return Validates.isMatch((String)pathInContext, (String)"/service/res/*");
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response) throws IOException {
        HttpContext context = request.getContext();
        String path = request.getPathInContext();
        String name = Strings.removeStartsWith((String)path, (String)"/service/res/");
        if (!this.resourceMap.containsKey(name)) {
            response.sendError(404);
            return;
        }
        String ifModifiedSince = request.getHeader("If-Modified-Since");
        if (ifModifiedSince != null && ifModifiedSince.indexOf(this.lastModifiedTime) != -1) {
            response.setHeader("Cache-Control", "max-age=" + context.getExpires());
            response.sendHeader(304);
            return;
        }
        String fileExt = Files.getFileExt((String)path);
        String mimeType = request.getMimeType();
        if (mimeType == null) {
            mimeType = HttpMimeType.getResourceMimeType(fileExt);
        }
        if (mimeType != null) {
            response.setContentType(String.valueOf(mimeType) + "; charset=" + "UTF-8");
        }
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Accept-Ranges", "bytes");
        response.setHeader("Last-Modified", this.lastModifiedTime);
        if (request.isMethodResponseContent()) {
            byte[] content = this.resourceMap.get(name);
            response.setHeader("Content-Length", content.length);
            response.setHeader("Cache-Control", "max-age=" + context.getExpires());
            response.write(content);
        }
        response.commit();
    }
}

