/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.context.returns;

import java.net.SocketException;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.context.core.Context;
import org.zhiqim.httpd.context.core.Return;
import org.zhiqim.httpd.context.returns.ReturnFrame;
import org.zhiqim.httpd.util.Responses;
import org.zhiqim.httpd.util.Scripts;
import org.zhiqim.httpd.util.Styles;
import org.zhiqim.kernel.util.Htmls;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.zml.ZmlEngine;

public class ReturnResult
implements Return {
    private ReturnFrame returnFrame = new ReturnFrame();

    @Override
    public void process(HttpRequest request) throws SocketException {
        if (request.getParameterBoolean("zCallFrame")) {
            this.returnFrame.process(request);
            return;
        }
        Context context = (Context)request.getContext();
        ZmlEngine engine = context.getZmlEngine();
        if (engine.hasZml("/conf/return/returnResult.zml")) {
            returnTemplate.process(request, "/conf/return/returnResult.zml", null);
            return;
        }
        HttpResponse response = request.getResponse();
        String encoding = response.getCharacterEncoding();
        String zhiqimCss = request.getContextAttributeString(request.isMobile() ? "zhiqim.mobile.css" : "zhiqim.css");
        String zhiqimJs = request.getContextAttributeString(request.isMobile() ? "zhiqim.mobile.js" : "zhiqim.js");
        boolean hasZhiqimCssJs = !Validates.isEmpty((String)zhiqimCss) && !Validates.isEmpty((String)zhiqimJs);
        StringBuilder strb = new StringBuilder();
        strb.append("<!DOCTYPE html>").append("\r\n");
        strb.append("<html>").append("\r\n");
        strb.append("<head>").append("\r\n");
        strb.append(Htmls.toTitle((String)request.getContextName()));
        strb.append(Htmls.toContentType((String)encoding));
        if (hasZhiqimCssJs) {
            strb.append(Styles.src(zhiqimCss)).append("\r\n");
            strb.append(Scripts.src(zhiqimJs)).append("\r\n");
        }
        strb.append("<script>\r\n");
        this.buildAlertMsgFunction(request, strb, hasZhiqimCssJs);
        this.buildCallbackFunction(request, strb);
        strb.append("</script>").append("\r\n");
        strb.append("</head>").append("\r\n");
        strb.append("</html>").append("\r\n");
        Responses.printAndCommit(response, strb, log);
    }

    private void buildAlertMsgFunction(HttpRequest request, StringBuilder strb, boolean hasZhiqimCssJs) {
        String message;
        if (hasZhiqimCssJs) {
            strb.append("Z.onload(function()").append("\r\n").append("{").append("\r\n");
        }
        if (Validates.isEmpty((String)(message = request.getAlertMsg()))) {
            if (hasZhiqimCssJs) {
                strb.append("    ").append("callback();").append("\r\n");
            } else {
                strb.append("callback();").append("\r\n").append("\r\n");
            }
        } else {
            message = Scripts.formatAlertMsg(message);
            if (hasZhiqimCssJs) {
                String func = request.isResponseSuccess() ? "success" : "failure";
                strb.append("    ").append("Z.alert(\"").append(message).append("\", callback, {type: \"").append(func).append("\"});").append("\r\n");
            } else {
                strb.append("alert(\"").append(message).append("\");").append("\r\n");
                strb.append("callback();").append("\r\n").append("\r\n");
            }
        }
        if (hasZhiqimCssJs) {
            strb.append("});").append("\r\n").append("\r\n");
        }
    }

    private void buildCallbackFunction(HttpRequest request, StringBuilder strb) {
        strb.append("function callback()").append("\r\n").append("{").append("\r\n");
        switch (request.getForceReturnType()) {
            case -1: {
                break;
            }
            case 1: {
                strb.append("    ").append("window.history.back();").append("\r\n");
                break;
            }
            case 2: {
                strb.append("    ").append("window.close();").append("\r\n");
                break;
            }
            case 3: {
                strb.append("    ").append("parent.Z.Dialog.close(location.hash, true);").append("\r\n");
                break;
            }
            case 4: {
                String redirect = request.getRedirect("UTF-8");
                strb.append("    ").append(redirect.substring("javascript:".length())).append("\r\n");
                break;
            }
            default: {
                String redirect = request.getRedirect("UTF-8");
                redirect = redirect.replaceAll("\r", "");
                redirect = redirect.replaceAll("\n", "");
                if (redirect.startsWith("/") && !redirect.startsWith("//")) {
                    redirect = request.getContext().getRootPath(redirect);
                }
                strb.append("    ");
                int target = request.getResponseStatus();
                if (target == 601) {
                    strb.append("parent.location.href=\"");
                } else if (target == 603) {
                    strb.append("top.location.href=\"");
                } else {
                    strb.append("window.location.href=\"");
                }
                strb.append(redirect).append("\";").append("\r\n");
            }
        }
        strb.append("}").append("\r\n");
    }
}

