/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.context.config;

import org.zhiqim.httpd.HttpWebsocket;
import org.zhiqim.httpd.context.ZmlBootstrap;
import org.zhiqim.httpd.context.ZmlConfig;
import org.zhiqim.httpd.context.ZmlContextConstants;
import org.zhiqim.httpd.context.config.ZAction;
import org.zhiqim.httpd.context.config.ZActionPackage;
import org.zhiqim.httpd.context.config.ZComponent;
import org.zhiqim.httpd.context.config.ZConfig;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Validates;

public class ZComponentWapper
implements ZmlContextConstants {
    private final ZComponent component;
    private final ZConfig config;
    private final ZActionPackage actionPackage;
    private HttpWebsocket websocket;
    private ZmlBootstrap bootstrap;

    public ZComponentWapper(ZmlConfig zmlConfig, ZComponent component) {
        this.component = component;
        this.config = new ZConfig(zmlConfig, false, "classpath", component.getPath(), component.getName(), "/conf/config.xml");
        this.actionPackage = this.config.getActionPackage(zmlConfig);
    }

    public void load() throws Exception {
        this.config.load();
        if (this.actionPackage != null) {
            this.actionPackage.load();
        }
    }

    public String getPath() {
        return this.component.getPath();
    }

    public HttpWebsocket getWebsocket() {
        if (this.websocket != null) {
            return this.websocket;
        }
        String cls = this.config.getWebsocketClass();
        if (Validates.isEmptyBlank((String)cls)) {
            return null;
        }
        Object instance = Classes.newInstance((String)cls.trim());
        Asserts.as(instance instanceof HttpWebsocket ? null : "\u7ec4\u4ef6[" + this.component.getName() + "]\u914d\u7f6e\u7684[websocket]\u4e0d\u662fHttpWebsocket\u5b9e\u73b0\u7c7b");
        this.websocket = (HttpWebsocket)instance;
        return this.websocket;
    }

    public ZmlBootstrap getBootstrap() {
        if (this.bootstrap != null) {
            return this.bootstrap;
        }
        String cls = this.config.getBootstrapClass();
        if (Validates.isEmptyBlank((String)cls)) {
            return null;
        }
        Object instance = Classes.newInstance((String)cls.trim());
        Asserts.as(instance instanceof ZmlBootstrap ? null : "\u7ec4\u4ef6[" + this.component.getName() + "]\u914d\u7f6e\u7684[bootstrap]\u4e0d\u662fZmlBootstrap\u6216\u5176\u5b50\u7c7b");
        this.bootstrap = (ZmlBootstrap)instance;
        this.bootstrap.setContext(this.config.getContext());
        return this.bootstrap;
    }

    public ZConfig getConfig() {
        return this.config;
    }

    public void addActionOnPackage(ZAction action) {
        if (this.actionPackage != null) {
            this.actionPackage.addActionOnPackage(action);
        }
    }

    public ZAction getActionInTurn(String path) {
        ZAction action = this.config.getInTurnAction(path);
        if (action != null) {
            return action;
        }
        if (this.actionPackage != null && (action = this.actionPackage.getInTurnAction(path)) != null) {
            return action;
        }
        return null;
    }

    public ZAction getExactAction(String path) {
        ZAction action = this.config.getExactAction(path);
        if (action != null) {
            return action;
        }
        if (this.actionPackage != null && (action = this.actionPackage.getExactAction(path)) != null) {
            return action;
        }
        return null;
    }

    public ZAction getFuzzyAction(String path) {
        ZAction action = this.config.getFuzzyAction(path);
        if (action != null) {
            return action;
        }
        if (this.actionPackage != null && (action = this.actionPackage.getFuzzyAction(path)) != null) {
            return action;
        }
        return null;
    }

    public ZAction getInTurnActionByClass(String clazz) {
        ZAction action = this.config.getInTurnActionByClass(clazz);
        if (action != null) {
            return action;
        }
        if (this.actionPackage != null && (action = this.actionPackage.getInTurnActionByClass(clazz)) != null) {
            return action;
        }
        return null;
    }

    public ZAction getExactActionByClass(String clazz) {
        ZAction action = this.config.getExactActionByClass(clazz);
        if (action != null) {
            return action;
        }
        if (this.actionPackage != null && (action = this.actionPackage.getExactActionByClass(clazz)) != null) {
            return action;
        }
        return null;
    }

    public ZAction getFuzzyActionByClass(String clazz) {
        ZAction action = this.config.getFuzzyActionByClass(clazz);
        if (action != null) {
            return action;
        }
        if (this.actionPackage != null && (action = this.actionPackage.getFuzzyActionByClass(clazz)) != null) {
            return action;
        }
        return null;
    }
}

