/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.context;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.zhiqim.httpd.HttpSessionManager;
import org.zhiqim.httpd.HttpWebsocketManager;
import org.zhiqim.httpd.context.ServiceExecutor;
import org.zhiqim.httpd.context.StaticContext;
import org.zhiqim.httpd.context.ZResExecutor;
import org.zhiqim.httpd.context.ZmlBootstrap;
import org.zhiqim.httpd.context.ZmlConfig;
import org.zhiqim.httpd.context.ZmlExecutor;
import org.zhiqim.httpd.context.ZmlWebsocketManager;
import org.zhiqim.httpd.context.config.ZAction;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.httpd.context.core.Context;
import org.zhiqim.httpd.context.core.Interceptor;
import org.zhiqim.kernel.config.Group;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.zml.ZmlEngine;
import org.zhiqim.zml.ZmlVarNotice;
import org.zhiqim.zml.ZmlVariable;

public class ZmlContext
extends StaticContext
implements Context {
    private static final Log log = LogFactory.getLog(ZmlContext.class);
    private ZmlConfig config;
    private HttpSessionManager sessionManager;
    private ZmlEngine engine;
    private ServiceExecutor serviceExecutor;
    private ZmlWebsocketManager websocketManager;

    public ZmlContext() {
        this.addFilter("/conf/*");
        this.addFilter("/zview/*");
        this.addFilter("/ztmpl/*.htm");
        this.addFilter("/ztmpl/*.zml");
    }

    @Override
    public boolean create(Group group) throws Exception {
        if (!super.create(group)) {
            return false;
        }
        if (!this.initConfig(group)) {
            return false;
        }
        if (!this.initZmlEngine()) {
            return false;
        }
        return this.initContext();
    }

    public boolean initConfig(Group group) {
        this.config = new ZmlConfig(this, this.resource, group.isTrue("pathExactPrior", true));
        this.serviceExecutor = new ServiceExecutor();
        super.addHandler(this.serviceExecutor);
        super.addHandler(new ZResExecutor());
        super.setDefaultHandler(new ZmlExecutor(group.getString("zml.pattern", "*.zml,*.htm")));
        super.setCookieUse(group.isTrue("cookie.use", true));
        super.setCookieDomain(group.getString("cookie.domain"));
        super.setCookiePort(group.getInt("cookie.port", 0));
        super.setCookiePath(group.getString("cookie.path"));
        String sessionManager = group.getString("session.manager", "org.zhiqim.httpd.sessioner.HashSessionManager");
        Object manager = Classes.newInstance((String)sessionManager);
        Asserts.as(manager instanceof HttpSessionManager ? null : "\u672a\u627e\u5230[" + group.getId() + "]\u7684[" + "session.manager" + "]\u6216\u4e0d\u662fHttpSessionManager\u5b9e\u73b0\u7c7b");
        HttpSessionManager httpSessionManager = (HttpSessionManager)manager;
        httpSessionManager.setContext(this);
        httpSessionManager.setSessionTimeout(group.getInt("session.timeout", 1800));
        httpSessionManager.setSessionIdName(group.getString("session.idName", "jsessionid"));
        httpSessionManager.setSessionParameter(group.getString("session.parameter", ""));
        httpSessionManager.open();
        this.sessionManager = httpSessionManager;
        this.websocketManager = new ZmlWebsocketManager(this);
        this.websocketManager.open();
        return true;
    }

    private boolean initZmlEngine() {
        String resourcePath = this.getResourcePath();
        if (Validates.isEmptyBlank((String)resourcePath)) {
            return true;
        }
        log.info((Object)"\u521d\u59cb\u5316[HTTP\u670d\u52a1:%s][ZML\u5f15\u64ce]\u5f00\u59cb...[%s]", new Object[]{this.getServerId(), DateTimes.getDateTimeSSSString()});
        try {
            this.engine = new ZmlEngine();
            this.engine.setZmlVarNotice((ZmlVarNotice)this.config);
            this.engine.setAscQuery(false);
            this.engine.setMaxKeepTime(this.getAttributeInt("zml.maxKeepTime", 86400));
            this.engine.setMaxIdleTime(this.getAttributeInt("zml.maxIdleTime", 3600));
            if (this.isClasspath()) {
                this.engine.setClassZmlLoader(ZmlContext.class, resourcePath);
            } else {
                this.engine.setFileZmlLoader(new File(resourcePath));
            }
            log.info((Object)"\u521d\u59cb\u5316[HTTP\u670d\u52a1:%s][ZML\u5f15\u64ce]\u7ed3\u675f!!![%s]", new Object[]{this.getServerId(), DateTimes.getDateTimeSSSString()});
            return true;
        }
        catch (Exception e) {
            log.error((Object)"\u521d\u59cb\u5316[ZML\u5f15\u64ce]\u9519\u8bef", (Throwable)e, new Object[0]);
            return false;
        }
    }

    private boolean initContext() {
        block3: {
            log.info((Object)"\u521d\u59cb\u5316[HTTP\u670d\u52a1:%s][Context:%s]\u5f00\u59cb...[%s]", new Object[]{this.getServerId(), this.getContextName(), DateTimes.getDateTimeSSSString()});
            try {
                if (this.config.create()) break block3;
                return false;
            }
            catch (Exception e) {
                log.error((Object)"\u521d\u59cb\u5316[HTTP\u670d\u52a1:%s][Context:%s]\u5931\u8d25!!!", (Throwable)e, new Object[]{this.getServerId(), this.getContextName()});
                return false;
            }
        }
        log.info((Object)"\u521d\u59cb\u5316[HTTP\u670d\u52a1:%s][Context:%s]\u5b8c\u6210!!![%s]", new Object[]{this.getServerId(), this.getContextName(), DateTimes.getDateTimeSSSString()});
        return true;
    }

    public void destory() {
        if (!this.isRunning) {
            return;
        }
        super.destroy();
        if (this.config != null) {
            this.config.destroy();
        }
        if (this.sessionManager != null) {
            this.sessionManager.close();
        }
        if (this.websocketManager != null) {
            this.websocketManager.close();
        }
    }

    @Override
    public boolean hasAttribute(String key) {
        return this.config.has(key);
    }

    @Override
    public Object getAttribute(String key) {
        return ZmlVariable.chkDynamicVar((Object)this.config.get(key));
    }

    @Override
    public boolean hasTopAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    @Override
    public Object getTopAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public String getTopAttributeString(String key) {
        return (String)this.attributes.get(key);
    }

    @Override
    public String getTopAttributeString(String key, String defaultValue) {
        return this.hasTopAttribute(key) ? this.getTopAttributeString(key) : defaultValue;
    }

    @Override
    public String getServerId() {
        return this.getServer().getId();
    }

    @Override
    public ZmlConfig getConfig() {
        return this.config;
    }

    @Override
    public ZmlBootstrap getBootstrap() {
        return this.config.getBootstrap();
    }

    @Override
    public ServiceExecutor getServiceExecutor() {
        return this.serviceExecutor;
    }

    @Override
    public ZmlEngine getZmlEngine() {
        return this.engine;
    }

    @Override
    public HttpSessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public void invalidateSession(String sessionId) {
        if (this.sessionManager != null) {
            this.sessionManager.invalidateSession(sessionId);
        }
    }

    @Override
    public ZAction getAction(String path) {
        return this.config.getAction(path);
    }

    @Override
    public Action getAction(ZAction fAction) {
        return this.config.getAction(fAction);
    }

    @Override
    public boolean hasActionInstance(String clazz) {
        return this.getActionInstance(clazz) != null;
    }

    @Override
    public Action getActionInstance(String clazz) {
        return this.config.getActionInstance(clazz);
    }

    @Override
    public boolean hasInterceptor(String interceptor) {
        return this.config.hasInterceptor(interceptor);
    }

    @Override
    public Interceptor getInterceptor(String interceptor) {
        return this.config.getInterceptor(interceptor);
    }

    @Override
    public List<Interceptor> getInterceptorList(String interceptors) {
        String[] interceptorArr;
        if (Validates.isEmpty((String)interceptors)) {
            return new ArrayList<Interceptor>(0);
        }
        ArrayList<Interceptor> interceptorList = new ArrayList<Interceptor>();
        String[] stringArray = interceptorArr = Arrays.toStringArray((String)interceptors);
        int n = interceptorArr.length;
        int n2 = 0;
        while (n2 < n) {
            String interceptor = stringArray[n2];
            Interceptor ic = this.getInterceptor(interceptor);
            if (ic != null) {
                interceptorList.add(ic);
            }
            ++n2;
        }
        return interceptorList;
    }

    @Override
    public HttpWebsocketManager getWebsocketManager() {
        return this.websocketManager;
    }
}

