/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd;

import java.io.IOException;
import java.io.InputStream;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Bytes;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.mutables.MInt;

public class HttpWebsocketMessage
implements CodeConstants {
    protected boolean fin;
    protected int opcode;
    protected boolean mask;
    protected byte[] masks;
    protected int length;
    protected byte[] content;
    protected int contentLen;
    protected String text;

    public HttpWebsocketMessage parse(InputStream in) throws IOException {
        byte[] buf;
        int first = in.read() & 0xFF;
        int second = in.read() & 0xFF;
        this.fin = (first & 0x80) != 0;
        this.opcode = first & 0xF;
        this.mask = (second & 0x80) != 0;
        this.contentLen = this.length = second & 0x7F;
        if (this.length == 126) {
            buf = Streams.getBytes((InputStream)in, (int)2);
            this.contentLen = Bytes.BU.getShortUnsigned(buf, 0);
        } else if (this.length == 127) {
            buf = Streams.getBytes((InputStream)in, (int)8);
            long len = Bytes.BU.getLong(buf, 0);
            if (len > Integer.MAX_VALUE) {
                throw Asserts.exception((String)"\u8d85\u51fa\u652f\u6301\u7684\u80fd\u529b");
            }
            this.contentLen = (int)len;
        }
        if (this.mask) {
            this.masks = Streams.getBytes((InputStream)in, (int)4);
        }
        if (this.contentLen > 0) {
            this.content = Streams.getBytes((InputStream)in, (int)this.contentLen);
            if (this.mask) {
                int i = 0;
                while (i < this.content.length) {
                    this.content[i] = (byte)(this.content[i] ^ this.masks[i % 4]);
                    ++i;
                }
            }
            if (this.isText()) {
                this.text = Strings.newStringUTF8((byte[])this.content);
            } else if (this.isClose()) {
                this.text = String.valueOf(Bytes.BU.getShortUnsigned(this.content, 0));
            }
        }
        return this;
    }

    public HttpWebsocketMessage build(String text) {
        this.fin = true;
        this.opcode = 1;
        this.mask = false;
        this.text = text;
        this.content = text.getBytes(_UTF_8_C_);
        this.contentLen = this.content.length;
        this.length = this.contentLen < 126 ? this.contentLen : (this.contentLen <= 65535 ? 126 : 127);
        return this;
    }

    public HttpWebsocketMessage buildPing() {
        this.fin = true;
        this.opcode = 9;
        this.mask = false;
        this.text = null;
        this.content = null;
        this.contentLen = 0;
        this.length = 0;
        return this;
    }

    public HttpWebsocketMessage buildPong() {
        this.fin = true;
        this.opcode = 10;
        this.mask = false;
        this.text = null;
        this.content = null;
        this.contentLen = 0;
        this.length = 0;
        return this;
    }

    public byte[] toBytes() {
        int len = 2 + (this.length == 126 ? 2 : (this.length == 127 ? 8 : 0)) + this.contentLen;
        byte[] buf = new byte[len];
        buf[0] = (byte)(this.fin ? 0x80 | this.opcode : this.opcode);
        buf[1] = (byte)this.length;
        MInt off = new MInt(2);
        if (this.length == 126) {
            Bytes.BU.putShort(buf, off, this.contentLen);
        } else if (this.length == 127) {
            Bytes.BU.putLong(buf, off, (long)this.contentLen);
        }
        if (this.contentLen > 0) {
            Bytes.putBytes((byte[])buf, (MInt)off, (byte[])this.content);
        }
        return buf;
    }

    public boolean isText() {
        return this.opcode == 1;
    }

    public boolean isBinary() {
        return this.opcode == 2;
    }

    public boolean isClose() {
        return this.opcode == 8;
    }

    public boolean isPing() {
        return this.opcode == 9;
    }

    public boolean isPong() {
        return this.opcode == 10;
    }

    public boolean isFin() {
        return this.fin;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public boolean isMask() {
        return this.mask;
    }

    public byte[] getMasks() {
        return this.masks;
    }

    public int getLength() {
        return this.length;
    }

    public String getText() {
        return this.text;
    }

    public int getContentLen() {
        return this.contentLen;
    }

    public byte[] getContent() {
        return this.contentLen == 0 ? new byte[]{} : this.content;
    }
}

