/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.xml;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.AsciiConstants;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.xml.Xml;
import org.zhiqim.kernel.xml.Xmlx;
import org.zhiqim.kernel.xml.annotation.XmlClassTag;
import org.zhiqim.kernel.xml.annotation.XmlFieldNoGroup;

@AnAlias(value={"Xmls"})
public class Xmls
extends Xmlx
implements AsciiConstants {
    public static String toString(Object obj) {
        return Xml.xml.toString(obj);
    }

    public static <T> T toObject(String str, Class<T> clazz) {
        return Xml.xml.toObject(str, clazz);
    }

    public static String getXmlClassTag(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        XmlClassTag xmlTag = clazz.getAnnotation(XmlClassTag.class);
        if (xmlTag != null && !Validates.isEmptyBlank(xmlTag.value())) {
            return xmlTag.value().trim();
        }
        AnAlias alias = clazz.getAnnotation(AnAlias.class);
        if (alias != null && !Validates.isEmptyBlank(alias.value()[0])) {
            return alias.value()[0].trim();
        }
        return Strings.lastIndexOfString(clazz.getName(), ".");
    }

    public static boolean hasXmlFieldGroup(Field field) {
        return !field.isAnnotationPresent(XmlFieldNoGroup.class);
    }

    public static List<String> getXmlFieldList(String xml, String name) {
        ArrayList<String> list = new ArrayList<String>();
        String lField = "<" + name + ">";
        String rField = "</" + name + ">";
        int rLen = rField.length();
        int iLeft = xml.indexOf(lField);
        while (iLeft != -1) {
            int iRight = xml.indexOf(rField, iLeft);
            if (iRight == -1) break;
            list.add(xml.substring(iLeft, iRight + rLen));
            xml = xml.substring(iRight + rLen);
            iLeft = xml.indexOf(lField);
        }
        return list;
    }

    public static String getXmlField(String xml, String field) {
        if (xml.length() < field.length() * 2 + 5) {
            return null;
        }
        String lField = "<" + field + ">";
        String rField = "</" + field + ">";
        int iLeft = xml.indexOf(lField);
        int iRight = xml.indexOf(rField);
        if (iLeft == -1 && iRight == -1) {
            return null;
        }
        if (iLeft == -1 && iRight != -1 || iLeft != -1 && iRight == -1) {
            return null;
        }
        int valueLen = iRight - iLeft - lField.length();
        if (valueLen <= 0) {
            return null;
        }
        return xml.substring(iLeft + lField.length(), iRight);
    }

    public static String chkXmlByTag(String xml, String tag) throws Exception {
        if (xml.length() < tag.length() * 2 + 5) {
            throw new Exception("xml tag #" + tag + "# format error");
        }
        String lField = "<" + tag + ">";
        String rField = "</" + tag + ">";
        String left = xml.substring(0, lField.length());
        String right = xml.substring(xml.length() - rField.length());
        if (!lField.equals(left) || !rField.equals(right)) {
            throw new Exception("xml tag #" + tag + "# format error");
        }
        xml = xml.substring(lField.length());
        xml = xml.substring(0, xml.length() - rField.length());
        return xml;
    }

    public static String chkXmlByField(String xml, String field, StringBuffer value, int len, boolean isFixed) throws Exception {
        if (xml.length() < field.length() * 2 + 5) {
            throw new Exception("xml tag #" + field + "# format error");
        }
        String lField = "<" + field + ">";
        String rField = "</" + field + ">";
        int iLeft = xml.indexOf(lField);
        int iRight = xml.indexOf(rField);
        if (iLeft == -1 || iRight == -1) {
            throw new Exception("xml tag #" + field + "# format error");
        }
        int valueLen = iRight - iLeft - lField.length();
        if (isFixed && valueLen != len || !isFixed && (valueLen > len || valueLen < 1)) {
            throw new Exception("xml tag #" + field + "# format error");
        }
        value.append(xml.substring(iLeft + lField.length(), iRight));
        return xml.substring(iRight + rField.length());
    }

    public static String chkXmlByFieldAllowEmpty(String xml, String field, StringBuffer value, int len, boolean isFixed) throws Exception {
        String lField = "<" + field + ">";
        String rField = "</" + field + ">";
        int iLeft = xml.indexOf(lField);
        int iRight = xml.indexOf(rField);
        if (iLeft == -1 && iRight == -1) {
            return xml;
        }
        if (iLeft == -1 && iRight != -1 || iLeft != -1 && iRight == -1) {
            throw new Exception("xml tag #" + field + "# format error");
        }
        int valueLen = iRight - iLeft - lField.length();
        if (valueLen == 0) {
            return xml.substring(iRight + rField.length());
        }
        if (isFixed && valueLen != len || !isFixed && (valueLen > len || valueLen < 1)) {
            throw new Exception("xml tag #" + field + "# format error");
        }
        value.append(xml.substring(iLeft + lField.length(), iRight));
        return xml.substring(iRight + rField.length());
    }

    public static String chkXmlByIntField(String xml, String field, StringBuffer value) throws Exception {
        if (xml.length() < field.length() * 2 + 5) {
            throw new Exception("xml tag #" + field + "# format error");
        }
        String lField = "<" + field + ">";
        String rField = "</" + field + ">";
        int iLeft = xml.indexOf(lField);
        int iRight = xml.indexOf(rField);
        if (iLeft == -1 || iRight == -1) {
            throw new Exception("xml tag #" + field + "# format error");
        }
        int valueLen = iRight - iLeft - lField.length();
        if (valueLen < 1) {
            throw new Exception("xml tag #" + field + "# format error");
        }
        String valueInt = xml.substring(iLeft + lField.length(), iRight);
        if (!Validates.isInteger(valueInt)) {
            throw new Exception("xml tag #" + field + "# format error");
        }
        value.append(valueInt);
        return xml.substring(iRight + rField.length());
    }

    public static String getXmlField(String xml, String field, int len, boolean isFixed) throws Exception {
        if (xml.length() < field.length() * 2 + 5) {
            throw new Exception("xml tag #" + field + "# format error");
        }
        String lField = "<" + field + ">";
        String rField = "</" + field + ">";
        int iLeft = xml.indexOf(lField);
        int iRight = xml.indexOf(rField);
        if (iLeft == -1 || iRight == -1) {
            throw new Exception("xml tag #" + field + "# format error");
        }
        int valueLen = iRight - iLeft - lField.length();
        if (isFixed && valueLen != len || !isFixed && (valueLen > len || valueLen < 1)) {
            throw new Exception("xml tag #" + field + "# format error");
        }
        return xml.substring(iLeft + lField.length(), iRight);
    }

    public static int getXmlInt(String xml, String field) throws Exception {
        if (xml.length() < field.length() * 2 + 5) {
            throw new Exception("xml tag #" + field + "# format error");
        }
        String lField = "<" + field + ">";
        String rField = "</" + field + ">";
        int iLeft = xml.indexOf(lField);
        int iRight = xml.indexOf(rField);
        if (iLeft == -1 || iRight == -1) {
            throw new Exception("xml tag #" + field + "# format error");
        }
        int valueLen = iRight - iLeft;
        if (valueLen < 1) {
            throw new Exception("xml tag #" + field + "# format error");
        }
        String valueInt = xml.substring(iLeft + lField.length(), iRight);
        if (!Validates.isInteger(valueInt)) {
            throw new Exception("xml tag #" + field + "# format error");
        }
        return Integer.parseInt(valueInt);
    }

    public static String getString(String xml, String name) throws Exception {
        String lField = String.valueOf(name) + "=\"";
        String rField = "\"";
        int iLeft = xml.indexOf(lField);
        if (iLeft == -1) {
            return null;
        }
        int iRight = xml.indexOf(rField, iLeft + lField.length());
        if (iRight == -1) {
            return null;
        }
        return xml.substring(iLeft + lField.length(), iRight);
    }

    public static int getInt(String xml, String name) throws Exception {
        String value = Xmls.getString(xml, name);
        if (value == null) {
            throw new Exception("\u672a\u627e\u5230\u5b57\u6bb5\u503c");
        }
        return Integer.parseInt(value);
    }

    public static long getLong(String xml, String name) throws Exception {
        String value = Xmls.getString(xml, name);
        if (value == null) {
            throw new Exception("\u672a\u627e\u5230\u5b57\u6bb5\u503c");
        }
        return Long.parseLong(value);
    }

    public static List<String> getList(String xml, String name) {
        ArrayList<String> list = new ArrayList<String>();
        String lField = "<" + name + " ";
        String rField = "</" + name + ">";
        String rField2 = "/>";
        int iLeft = xml.indexOf(lField);
        while (iLeft != -1) {
            int len = rField.length();
            int iRight = xml.indexOf(rField, iLeft);
            if (iRight == -1) {
                iRight = xml.indexOf(rField2, iLeft);
                len = rField2.length();
            }
            if (iRight == -1) break;
            String str = xml.substring(iLeft, iRight + len);
            list.add(str);
            xml = xml.substring(iRight + len);
            iLeft = xml.indexOf(lField);
        }
        return list;
    }
}

