/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util.codes;

import org.zhiqim.kernel.util.Validates;

public class URI {
    private static final String SESSION_KEY = ";jsessionid=";
    private static final String DOMAIN = ".:/0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String SESSION = "?0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private String uri;
    private String scheme = "http";
    private String host;
    private int port;
    private String path;
    private String sessionId;
    private String query;

    public String toString() {
        return this.uri;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getQuery() {
        return this.query;
    }

    public String getVirtualDirectory() {
        int ind = this.path.indexOf(47, 1);
        if (ind != -1) {
            return this.path.substring(0, ind);
        }
        return "/";
    }

    public String getRootUrl() {
        if (this.port == 80) {
            return String.valueOf(this.scheme) + "://" + this.host;
        }
        return String.valueOf(this.scheme) + "://" + this.host + ":" + this.port;
    }

    public String getRootUrlSlash() {
        if (this.port == 80) {
            return String.valueOf(this.scheme) + "://" + this.host + "/";
        }
        return String.valueOf(this.scheme) + "://" + this.host + ":" + this.port + "/";
    }

    public boolean parseUri(String uri) {
        char c;
        char c2;
        StringBuilder strb;
        int i;
        this.uri = uri;
        boolean hasHost = true;
        if (uri.startsWith("http://")) {
            uri = uri.substring(7);
        } else if (uri.startsWith("https://")) {
            uri = uri.substring(8);
        } else {
            hasHost = false;
            this.port = 80;
        }
        if (hasHost) {
            i = 0;
            strb = new StringBuilder();
            while (i < uri.length()) {
                c2 = uri.charAt(i);
                if (!Validates.isCharInString(c2, DOMAIN)) {
                    return false;
                }
                if (c2 == ':') break;
                if (c2 == '/') {
                    this.port = 80;
                    break;
                }
                strb.append(c2);
                ++i;
            }
            if (strb.length() == 0) {
                return false;
            }
            this.host = strb.toString().toLowerCase();
            if ((uri = uri.substring(i)).length() <= 0) {
                this.port = 80;
            }
        }
        if (this.port == 0 && uri.length() > 0) {
            if (!uri.startsWith(":")) {
                return false;
            }
            uri = uri.substring(1);
            i = 0;
            strb = new StringBuilder();
            while (i < uri.length()) {
                c2 = uri.charAt(i);
                if (!Validates.isCharInString(c2, "/0123456789")) {
                    return false;
                }
                if (c2 == '/') break;
                strb.append(c2);
                ++i;
            }
            if (strb.length() == 0) {
                return false;
            }
            this.port = Integer.parseInt(strb.toString());
            uri = uri.substring(i);
        }
        boolean hasSessionId = false;
        if (uri.length() > 0) {
            if (!uri.startsWith("/")) {
                return false;
            }
            int i2 = 0;
            StringBuilder strb2 = new StringBuilder();
            while (i2 < uri.length()) {
                c = uri.charAt(i2);
                if (c == '?') break;
                if (c == ';') {
                    hasSessionId = true;
                    break;
                }
                strb2.append(c);
                ++i2;
            }
            if (strb2.length() > 0) {
                this.path = strb2.toString();
                uri = uri.substring(i2);
            }
        }
        if (hasSessionId && uri.length() > 0) {
            if (!uri.startsWith(SESSION_KEY)) {
                return false;
            }
            uri = uri.substring(SESSION_KEY.length());
            int i3 = 0;
            StringBuilder strb3 = new StringBuilder();
            while (i3 < uri.length()) {
                c = uri.charAt(i3);
                if (!Validates.isCharInString(c, SESSION)) {
                    return false;
                }
                if (c == '?') break;
                strb3.append(c);
                ++i3;
            }
            if (strb3.length() > 0) {
                this.sessionId = strb3.toString();
                uri = uri.substring(i3);
            }
        }
        if (uri.length() > 0) {
            if (!uri.startsWith("?")) {
                return false;
            }
            this.query = uri.substring(1);
        }
        return true;
    }
}

