/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util.codes;

import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.util.Bytes;

public class Base64Decoder
implements CodeConstants {
    private static byte[] BASE64_BYTE = new byte[256];

    static {
        int i = 0;
        while (i < BASE64_BYTE.length) {
            Base64Decoder.BASE64_BYTE[i] = -1;
            ++i;
        }
        i = 0;
        while (i < _BASE64_BS_.length) {
            byte b = _BASE64_BS_[i];
            Base64Decoder.BASE64_BYTE[b] = (byte)i;
            ++i;
        }
    }

    public static byte[] decode(byte[] src) {
        byte s2;
        byte s1;
        if ((src = Base64Decoder.removeNonBase64(src)).length == 0) {
            return new byte[0];
        }
        int i = 0;
        while (i < src.length) {
            src[i] = BASE64_BYTE[src[i]];
            ++i;
        }
        int length = src.length / 4;
        int remainderLen = src.length % 4;
        int destLen = length * 3 + (remainderLen == 0 ? 0 : (remainderLen == 2 ? 1 : 2));
        byte[] dest = new byte[destLen];
        int i2 = 0;
        while (i2 < length) {
            int srcIndex = i2 * 4;
            int destIndex = i2 * 3;
            byte s12 = src[srcIndex];
            byte s22 = src[srcIndex + 1];
            byte s3 = src[srcIndex + 2];
            byte s4 = src[srcIndex + 3];
            int d = (s12 & 0xFF) << 18 | (s22 & 0xFF) << 12 | (s3 & 0xFF) << 6 | s4 & 0xFF;
            dest[destIndex] = (byte)(d >> 16);
            dest[destIndex + 1] = (byte)(d >> 8);
            dest[destIndex + 2] = (byte)d;
            ++i2;
        }
        if (remainderLen == 0) {
            return dest;
        }
        int srcIndex = length * 4;
        int destIndex = length * 3;
        if (remainderLen == 2) {
            s1 = src[srcIndex];
            s2 = src[srcIndex + 1];
            int s = (s1 & 0xFF) << 6 | s2 & 0xFF;
            dest[destIndex] = (byte)(s >> 4);
        } else {
            s1 = src[srcIndex];
            s2 = src[srcIndex + 1];
            byte s3 = src[srcIndex + 2];
            int s = (s1 & 0xFF) << 12 | (s2 & 0xFF) << 6 | s3 & 0xFF;
            dest[destIndex] = (byte)(s >> 10);
            dest[destIndex + 1] = (byte)(s >> 2);
        }
        return dest;
    }

    private static byte[] removeNonBase64(byte[] src) {
        int validLen = 0;
        byte[] valid = new byte[src.length];
        byte[] byArray = src;
        int n = src.length;
        int n2 = 0;
        while (n2 < n) {
            byte v;
            byte b = byArray[n2];
            if (b >= 43 && b <= 122 && (v = BASE64_BYTE[b]) != -1) {
                valid[validLen++] = b;
            }
            ++n2;
        }
        return Bytes.getBytes(valid, 0, validLen);
    }
}

