/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import org.zhiqim.kernel.annotation.AnAlias;

@AnAlias(value={"Types"})
public class Types {
    public static boolean isPrimitive(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return true;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return true;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return true;
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return true;
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return true;
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return true;
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return true;
        }
        return clazz == Double.TYPE || clazz == Double.class;
    }

    public static boolean isPrimitiveBase(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz == Integer.TYPE) {
            return true;
        }
        if (clazz == Long.TYPE) {
            return true;
        }
        if (clazz == Boolean.TYPE) {
            return true;
        }
        if (clazz == Byte.TYPE) {
            return true;
        }
        if (clazz == Short.TYPE) {
            return true;
        }
        if (clazz == Character.TYPE) {
            return true;
        }
        if (clazz == Float.TYPE) {
            return true;
        }
        return clazz == Double.TYPE;
    }

    public static Class<?> toObjectClass(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        return clazz;
    }

    public static boolean isNumber(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return true;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return true;
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return true;
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return true;
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return true;
        }
        return clazz == Double.TYPE || clazz == Double.class;
    }

    public static boolean isInteger(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return true;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return true;
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return true;
        }
        return clazz == Short.TYPE || clazz == Short.class;
    }

    public static boolean isDecimal(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return true;
        }
        return clazz == Double.TYPE || clazz == Double.class;
    }

    public static boolean isInt(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz == Integer.TYPE || clazz == Integer.class;
    }

    public static boolean isLong(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz == Long.TYPE || clazz == Long.class;
    }

    public static boolean isShort(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz == Short.TYPE || clazz == Short.class;
    }

    public static boolean isChar(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz == Character.TYPE || clazz == Character.class;
    }

    public static boolean isByte(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz == Byte.TYPE || clazz == Byte.class;
    }

    public static boolean isFloat(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz == Float.TYPE || clazz == Float.class;
    }

    public static boolean isDouble(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz == Double.TYPE || clazz == Double.class;
    }

    public static boolean isBoolean(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz == Boolean.TYPE || clazz == Boolean.class;
    }

    public static boolean isSingle(Object obj) {
        if (obj == null) {
            return true;
        }
        if (Types.isInt(obj)) {
            return true;
        }
        if (Types.isLong(obj)) {
            return true;
        }
        if (Types.isBoolean(obj)) {
            return true;
        }
        if (Types.isByte(obj)) {
            return true;
        }
        if (Types.isShort(obj)) {
            return true;
        }
        if (Types.isChar(obj)) {
            return true;
        }
        if (Types.isFloat(obj)) {
            return true;
        }
        if (Types.isDouble(obj)) {
            return true;
        }
        return Types.isString(obj);
    }

    public static boolean isPrimitive(Object obj) {
        if (obj == null) {
            return false;
        }
        if (Types.isInt(obj)) {
            return true;
        }
        if (Types.isLong(obj)) {
            return true;
        }
        if (Types.isBoolean(obj)) {
            return true;
        }
        if (Types.isByte(obj)) {
            return true;
        }
        if (Types.isShort(obj)) {
            return true;
        }
        if (Types.isChar(obj)) {
            return true;
        }
        if (Types.isFloat(obj)) {
            return true;
        }
        return Types.isDouble(obj);
    }

    public static boolean isNumber(Object obj) {
        if (Types.isInt(obj)) {
            return true;
        }
        if (Types.isLong(obj)) {
            return true;
        }
        if (Types.isByte(obj)) {
            return true;
        }
        if (Types.isShort(obj)) {
            return true;
        }
        if (Types.isFloat(obj)) {
            return true;
        }
        return Types.isDouble(obj);
    }

    public static boolean isInteger(Object obj) {
        if (Types.isInt(obj)) {
            return true;
        }
        if (Types.isLong(obj)) {
            return true;
        }
        if (Types.isByte(obj)) {
            return true;
        }
        return Types.isShort(obj);
    }

    public static boolean isDecimal(Object obj) {
        if (Types.isFloat(obj)) {
            return true;
        }
        return Types.isDouble(obj);
    }

    public static boolean isNull(Object obj) {
        return obj == null;
    }

    public static boolean isString(Object obj) {
        return obj == null ? false : obj instanceof String;
    }

    public static boolean isInt(Object obj) {
        return obj == null ? false : obj instanceof Integer;
    }

    public static boolean isLong(Object obj) {
        return obj == null ? false : obj instanceof Long;
    }

    public static boolean isShort(Object obj) {
        return obj == null ? false : obj instanceof Short;
    }

    public static boolean isByte(Object obj) {
        return obj == null ? false : obj instanceof Byte;
    }

    public static boolean isChar(Object obj) {
        return obj == null ? false : obj instanceof Character;
    }

    public static boolean isBoolean(Object obj) {
        return obj == null ? false : obj instanceof Boolean;
    }

    public static boolean isFloat(Object obj) {
        return obj == null ? false : obj instanceof Float;
    }

    public static boolean isDouble(Object obj) {
        return obj == null ? false : obj instanceof Double;
    }

    public static boolean isArray(Object obj) {
        return obj == null ? false : obj.getClass().isArray();
    }

    public static boolean isArray(Class<?> clazz) {
        return clazz == null ? false : clazz.isArray();
    }

    public static boolean isPrimitiveArray(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz == int[].class) {
            return true;
        }
        if (clazz == long[].class) {
            return true;
        }
        if (clazz == boolean[].class) {
            return true;
        }
        if (clazz == byte[].class) {
            return true;
        }
        if (clazz == char[].class) {
            return true;
        }
        if (clazz == short[].class) {
            return true;
        }
        if (clazz == float[].class) {
            return true;
        }
        return clazz == double[].class;
    }

    public static boolean isPrimitiveArray(Object obj) {
        return obj == null ? false : Types.isPrimitiveArray(obj.getClass());
    }

    public static boolean isIntArray(Object obj) {
        return obj == null ? false : obj.getClass() == int[].class;
    }

    public static boolean isLongArray(Object obj) {
        return obj == null ? false : obj.getClass() == long[].class;
    }

    public static boolean isShortArray(Object obj) {
        return obj == null ? false : obj.getClass() == short[].class;
    }

    public static boolean isByteArray(Object obj) {
        return obj == null ? false : obj.getClass() == byte[].class;
    }

    public static boolean isCharArray(Object obj) {
        return obj == null ? false : obj.getClass() == char[].class;
    }

    public static boolean isFloatArray(Object obj) {
        return obj == null ? false : obj.getClass() == float[].class;
    }

    public static boolean isDoubleArray(Object obj) {
        return obj == null ? false : obj.getClass() == double[].class;
    }

    public static boolean isBooleanArray(Object obj) {
        return obj == null ? false : obj.getClass() == boolean[].class;
    }
}

