/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Bits;
import org.zhiqim.kernel.util.Bytes;
import org.zhiqim.kernel.util.Resources;
import org.zhiqim.kernel.util.Systems;

@AnAlias(value={"Streams"})
public class Streams
implements CodeConstants,
SignConstants {
    public static BufferedReader toReader(InputStream input, String encoding) throws UnsupportedEncodingException {
        return new BufferedReader(new InputStreamReader(input, encoding));
    }

    public static BufferedReader toReader(InputStream input, Charset charset) throws UnsupportedEncodingException {
        return new BufferedReader(new InputStreamReader(input, charset));
    }

    public static BufferedReader toReaderUTF8(InputStream input) {
        return new BufferedReader(new InputStreamReader(input, _UTF_8_C_));
    }

    public static String getStringUTF8(InputStream stream) throws IOException {
        return Streams.getString(stream, _UTF_8_C_);
    }

    public static String getStringGBK(InputStream stream) throws IOException {
        return Streams.getString(stream, _GBK_C_);
    }

    public static String getString(InputStream input, String encoding) throws IOException {
        Charset charset = Charset.forName(encoding);
        return Streams.getString(input, charset);
    }

    public static String getString(InputStream input, Charset charset) throws IOException {
        Asserts.notNull(input, "input");
        Asserts.notNull(charset, "charset");
        try {
            BufferedReader reader = Streams.toReader(input, charset);
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            int len = 0;
            while ((len = reader.read(buffer)) > 0) {
                writer.write(buffer, 0, len);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            input.close();
        }
    }

    public static String getStringGzip(InputStream input, String encoding) throws IOException {
        Asserts.notNull(input, "input");
        GZIPInputStream gzip = new GZIPInputStream(input);
        try {
            String string = Streams.getString((InputStream)gzip, encoding);
            return string;
        }
        finally {
            gzip.close();
            input.close();
        }
    }

    public static ByteArrayInputStream toStreamGBK(String content) {
        return Streams.toStream(content, _GBK_C_);
    }

    public static ByteArrayInputStream toStreamUTF8(String content) {
        return Streams.toStream(content, _UTF_8_C_);
    }

    public static ByteArrayInputStream toStream(String content, String encoding) {
        if (content == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(content.getBytes(encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw Asserts.exception("\u975e\u6cd5\u7684\u5b57\u7b26\u7f16\u7801[" + encoding + "]", e);
        }
    }

    public static ByteArrayInputStream toStream(String content, Charset charset) {
        Asserts.notNull(content, "content");
        Asserts.notNull(charset, "charset");
        return new ByteArrayInputStream(content.getBytes(charset));
    }

    public static void skip(InputStream input, long len) throws IOException {
        while (len > 0L) {
            long count = input.skip(len);
            if (count < 0L) {
                throw new EOFException("\u6309\u957f\u5ea6\u8df3\u8fc7\u6d41\u65f6,\u957f\u5ea6\u4e0d\u591f\u5373\u5230\u8fbe\u6d41\u5c3e\u7aef");
            }
            len -= count;
        }
    }

    public static void putBytes(InputStream input, byte[] buffer, int off, int len) throws IOException {
        while (len > 0) {
            int count = input.read(buffer, off, len);
            if (count < 0) {
                throw new EOFException("\u6309\u957f\u5ea6\u8bfb\u6d41\u65f6,\u957f\u5ea6\u4e0d\u591f\u5373\u5230\u8fbe\u6d41\u5c3e\u7aef");
            }
            off += count;
            len -= count;
        }
    }

    public static long putBytes(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        long count = 0L;
        while ((len = input.read(buffer)) != -1) {
            output.write(buffer, 0, len);
            count += (long)len;
        }
        return count;
    }

    public static long putBytesClassPath(Class<?> clazz, String path, OutputStream output) throws IOException {
        return Streams.putBytes(clazz.getResourceAsStream(path), output);
    }

    public static byte[] getBytes(InputStream input, int len) throws IOException {
        byte[] buffer = new byte[len];
        Streams.putBytes(input, buffer, 0, len);
        return buffer;
    }

    public static byte[] getBytesFilePath(File file) throws IOException {
        if (file == null || !file.isFile() || !file.canRead()) {
            return null;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream input = new FileInputStream(file);){
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Streams.putBytes(input, output);
            return output.toByteArray();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] getBytesClassPath(String path) throws IOException {
        InputStream input = Resources.getResourceStream(path);
        if (input == null) {
            return null;
        }
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Streams.putBytes(input, output);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        finally {
            input.close();
        }
    }

    public static byte[] getBytesClassPath(Class<?> clazz, String path) throws IOException {
        InputStream input = clazz.getResourceAsStream(path);
        if (input == null) {
            input = Resources.getResourceStream(path);
        }
        if (input == null) {
            return null;
        }
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Streams.putBytes(input, output);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        finally {
            input.close();
        }
    }

    public static int readLine(InputStream input, byte[] b, int len) throws IOException {
        return Streams.readLine(input, b, 0, len);
    }

    public static int readLine(InputStream input, byte[] b, int off, int len) throws IOException {
        int c;
        if (len <= 0) {
            return 0;
        }
        int count = 0;
        while ((c = input.read()) != -1) {
            b[off++] = (byte)c;
            if (c == 10 || ++count == len) break;
        }
        return count > 0 ? count : -1;
    }

    public static String getStreamEncoding(byte[] bytes, int len) {
        return Streams.getStreamEncoding(bytes, len, Systems.getSystemEncoding());
    }

    public static String getStreamEncoding(byte[] bytes, int len, String defaultEncoding) {
        if (bytes == null || bytes.length < 2 || len < 2) {
            return "UTF-8";
        }
        String encoding = Streams.getStreamEncodingBOM(bytes);
        if (encoding != null) {
            return encoding;
        }
        if (bytes.length < len) {
            len = bytes.length;
        }
        encoding = defaultEncoding == null ? Systems.getSystemEncoding() : defaultEncoding;
        byte firstChar = 0;
        int hasNum = 0;
        int num = 0;
        int i = 0;
        while (i < len) {
            byte b = bytes[i];
            if (Bits.isZero(b, 1)) {
                if (firstChar != 0 && hasNum != 0 && hasNum != num) {
                    return encoding;
                }
                firstChar = 0;
                hasNum = 0;
                num = 0;
            } else if (Bits.isZero(b, 2)) {
                if (firstChar == 0) {
                    return encoding;
                }
                ++num;
            } else {
                if (firstChar != 0 && hasNum != 0 && hasNum != num) {
                    return encoding;
                }
                firstChar = b;
                hasNum = Bits.isZero(b, 3) ? 1 : 2;
                num = 0;
            }
            ++i;
        }
        if (firstChar != 0 && hasNum != 0 && hasNum != num) {
            return encoding;
        }
        return "UTF-8";
    }

    public static String getStreamEncodingBOM(byte[] b) {
        if (b == null || b.length < 2) {
            return null;
        }
        if (Bytes.isUTF8BOM(b)) {
            return "UTF-8";
        }
        if (Bytes.isUTF16BEBOM(b)) {
            return "UTF-16BE";
        }
        if (Bytes.isUTF16LEBOM(b)) {
            return "UTF-16LE";
        }
        if (Bytes.isUTF32BEBOM(b)) {
            return "UTF-32BE";
        }
        if (Bytes.isUTF32LEBOM(b)) {
            return "UTF-32LE";
        }
        return null;
    }
}

