/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Strings;

@AnAlias(value={"RAFiles"})
public class RAFiles
implements SignConstants,
CodeConstants {
    public static RandomAccessFile newFile(File file, String mode) {
        try {
            return new RandomAccessFile(file, mode);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static RandomAccessFile newFileR(File file) {
        try {
            return new RandomAccessFile(file, "r");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static RandomAccessFile newFileRW(File file) {
        try {
            return new RandomAccessFile(file, "rw");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static RandomAccessFile newFile(String filePath, String mode) {
        try {
            return new RandomAccessFile(filePath, mode);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static RandomAccessFile newFileR(String filePath) {
        try {
            return new RandomAccessFile(filePath, "r");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static RandomAccessFile newFileRW(String filePath) {
        try {
            return new RandomAccessFile(filePath, "rw");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static void close(RandomAccessFile file) {
        if (file == null) {
            return;
        }
        try {
            file.close();
        }
        catch (Throwable throwable) {}
    }

    public static String readUTF8(RandomAccessFile file, long pos, int len) {
        try {
            byte[] b = RAFiles.read(file, pos, len);
            return Strings.newStringUTF8(b);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static byte[] read(RandomAccessFile file, long pos, int len) throws IOException {
        byte[] b = new byte[len];
        file.seek(pos);
        file.read(b);
        return b;
    }

    public static int readMaybe(RandomAccessFile file, long pos, byte[] buf, int off, int len) throws IOException {
        return Files.readMaybe(file.getChannel(), pos, buf, off, len);
    }

    public static void write(RandomAccessFile file, long pos, byte[] b) throws IOException {
        file.seek(pos);
        file.write(b);
    }

    public static void write(RandomAccessFile file, byte[] b) throws IOException {
        file.seek(file.length());
        file.write(b);
    }

    public static boolean writeUTF8(RandomAccessFile file, long pos, String content) {
        try {
            file.seek(pos);
            file.write(content.getBytes("UTF-8"));
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

