/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.text.DecimalFormat;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.util.Strings;

@AnAlias(value={"Maths"})
public class Maths
implements SignConstants {
    public static String division(String dividend, long divisor, int radixLen) {
        long dividendLong = Long.parseLong(dividend);
        return Maths.division(dividendLong, divisor, radixLen);
    }

    public static String division(long dividend, long divisor, int radixLen) {
        String ret;
        block5: {
            int ind;
            block6: {
                if (radixLen <= 0) {
                    return String.valueOf(dividend / divisor);
                }
                double result = (double)dividend / (double)divisor;
                StringBuilder radix = new StringBuilder("#");
                if (radixLen > 0) {
                    radix.append(".");
                    int i = 0;
                    while (i < radixLen) {
                        radix.append("#");
                        ++i;
                    }
                }
                DecimalFormat df = new DecimalFormat(radix.toString());
                ret = df.format(result);
                if (radixLen <= 0) break block5;
                ind = ret.indexOf(46);
                if (ind != -1) break block6;
                ret = String.valueOf(ret) + ".";
                int i = 0;
                while (i < radixLen) {
                    ret = String.valueOf(ret) + "0";
                    ++i;
                }
                break block5;
            }
            if (ind <= ret.length() - radixLen - 1) break block5;
            int zeroNum = ind - (ret.length() - radixLen - 1);
            int i = 0;
            while (i < zeroNum) {
                ret = String.valueOf(ret) + "0";
                ++i;
            }
        }
        return ret;
    }

    public static String permil(long value) {
        StringBuilder strb = new StringBuilder();
        while (value >= 1000L) {
            long remainder = value % 1000L;
            value /= 1000L;
            strb.insert(0, Strings.prefixZero(remainder, 3));
            strb.insert(0, ",");
        }
        strb.insert(0, value);
        return strb.toString();
    }

    public static String size(long value, int radixLen) {
        if (value < 1024L) {
            return String.valueOf(value) + "B";
        }
        if (value < 0x100000L) {
            return String.valueOf(Maths.division(value, 1024L, radixLen)) + "K";
        }
        if (value < 0x40000000L) {
            return String.valueOf(Maths.division(value, 0x100000L, radixLen)) + "M";
        }
        return String.valueOf(Maths.division(value, 0x40000000L, radixLen)) + "G";
    }
}

