/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.zhiqim.kernel.annotation.AnNullable;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Runtimes;
import org.zhiqim.kernel.util.Systems;
import org.zhiqim.kernel.util.Validates;

public class Linux {
    public static void shell(String cmd) throws IOException {
        Asserts.as(Systems.isLinux() ? null : "\u4e0d\u662fLinux\u7cfb\u7edf\uff0c\u4e0d\u652f\u6301\u8c03\u7528shell\u547d\u4ee4");
        Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
    }

    public static String shell(String cmd, String encoding) throws IOException {
        Asserts.as(Systems.isLinux() ? null : "\u4e0d\u662fLinux\u7cfb\u7edf\uff0c\u4e0d\u652f\u6301\u8c03\u7528shell\u547d\u4ee4");
        return Runtimes.exec(new String[]{"/bin/sh", "-c", cmd}, Charset.forName(encoding));
    }

    public static List<String> shell(String cmd, String encoding, int maxLineNum) throws IOException {
        Asserts.as(Systems.isLinux() ? null : "\u4e0d\u662fLinux\u7cfb\u7edf\uff0c\u4e0d\u652f\u6301\u8c03\u7528shell\u547d\u4ee4");
        return Runtimes.exec(new String[]{"/bin/sh", "-c", cmd}, encoding, maxLineNum);
    }

    public static String ifconfig(String encoding) throws IOException {
        return Linux.shell("ifconfig", encoding);
    }

    public static String ifconfig(String arguments, String encoding) throws IOException {
        return Linux.shell(Validates.isEmpty(arguments) ? "ifconfig" : "ifconfig " + arguments, encoding);
    }

    @AnNullable
    public static String getFirstMacAddress(String encoding) throws IOException {
        String[] lines;
        String result = Linux.ifconfig(encoding);
        if (Validates.isEmptyBlank(result)) {
            return null;
        }
        String[] stringArray = lines = Arrays.toStringArray(result, "\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((line = line.trim()).indexOf("HWaddr") >= 0) {
                String mac = line.substring(line.length() - 17);
                return mac.replaceAll("-", ":");
            }
            ++n2;
        }
        return null;
    }
}

