/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.EnumConstants;
import org.zhiqim.kernel.util.Arrays;

@AnAlias(value={"IPs"})
public class IPs
implements EnumConstants {
    public static final String IP_MIN_STR = "0.0.0.0";
    public static final String IP_MAX_STR = "255.255.255.255";
    public static final long IP_MIN = 0L;
    public static final long IP_MAX = 0xFFFFFFFFL;

    public static String byteToIp(byte[] value) {
        StringBuilder strb = new StringBuilder();
        strb.append(value[0] & 0xFF).append(".");
        strb.append(value[1] & 0xFF).append(".");
        strb.append(value[2] & 0xFF).append(".");
        strb.append(value[3] & 0xFF);
        return strb.toString();
    }

    public static long byteToLong(byte[] value) {
        int i0 = value[0] & 0xFF;
        int i1 = value[1] & 0xFF;
        int i2 = value[2] & 0xFF;
        int i3 = value[3] & 0xFF;
        int ipInt = (i0 << 24) + (i1 << 16) + (i2 << 8) + i3;
        return (long)ipInt & 0xFFFFFFFFL;
    }

    public static long ipToLong(String ip) {
        int[] ints = Arrays.toIntArray(ip, "\\.");
        if (ints.length != 4) {
            return -1L;
        }
        int ipInt = (ints[0] << 24) + (ints[1] << 16) + (ints[2] << 8) + ints[3];
        long ipLong = (long)ipInt & Integer.MAX_VALUE;
        if (ipInt < 0) {
            ipLong |= 0x80000000L;
        }
        return ipLong;
    }

    public static String longToIp(long ip) {
        int[] b = new int[]{(int)(ip >> 24 & 0xFFL), (int)(ip >> 16 & 0xFFL), (int)(ip >> 8 & 0xFFL), (int)(ip & 0xFFL)};
        return Arrays.toString(b, ".");
    }

    public static String trim(String ip) {
        int[] values = Arrays.toIntArray(ip, "\\.");
        return Arrays.toString(values, "\\.");
    }

    public static int ipMaskToInt(String ipMask) {
        ipMask = IPs.trim(ipMask);
        int i = 0;
        while (i < _IP_MASK_.length) {
            if (ipMask.equals(_IP_MASK_[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String intToIpMask(int i) {
        if (i > 32) {
            return IP_MAX_STR;
        }
        if (i < 0) {
            return IP_MIN_STR;
        }
        return _IP_MASK_[i];
    }

    public static long[] calcIpMaskMinMax(String ip, int mask) {
        long cur = IPs.ipToLong(ip);
        long min = 0L;
        long max = 0xFFFFFFFFL;
        int i = 0;
        while (i <= 32) {
            if (mask == i) break;
            long half = (max - min - 1L) / 2L + 1L;
            if (cur >= min + half) {
                min += half;
            } else {
                max -= half;
            }
            ++i;
        }
        return new long[]{min, max};
    }
}

