/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNullable;
import org.zhiqim.kernel.constants.TypeConstants;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.HashMapSS;
import org.zhiqim.kernel.extend.LinkedMapSO;
import org.zhiqim.kernel.extend.LinkedMapSS;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.extend.TreeMapSO;
import org.zhiqim.kernel.extend.TreeMapSS;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Types;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"Classes"})
public class Classes
implements TypeConstants {
    public static Class<?> forName(String className) {
        try {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception exception) {
            try {
                return Class.forName(className);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Object newInstance(String className) {
        try {
            Class<?> cls = Classes.forName(className);
            return cls == null ? null : cls.newInstance();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static <T> T newInstance(Class<T> cls) {
        try {
            return cls.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object[] newInstance(Class<?> cls, int length) {
        Object obj = Array.newInstance(cls, length);
        return Arrays.toArray(obj);
    }

    public static Collection<Object> newList(Class<?> cls) {
        Collection<Object> list = null;
        if (cls == Collection.class || cls == List.class || cls == ArrayList.class) {
            return new ArrayList<Object>();
        }
        if (cls == LinkedList.class) {
            return new LinkedList<Object>();
        }
        if (cls == Set.class || cls == HashSet.class) {
            return new HashSet<Object>();
        }
        return list;
    }

    public static Map<String, Object> newMap(Class<?> cls) {
        Map<String, Object> map = null;
        if (cls == Map.class || cls == HashMap.class) {
            return new HashMap<String, Object>();
        }
        if (cls == ConcurrentMap.class || cls == ConcurrentHashMap.class) {
            return new ConcurrentHashMap<String, Object>();
        }
        if (cls == Hashtable.class) {
            return new Hashtable<String, Object>();
        }
        if (cls == LinkedHashMap.class) {
            return new LinkedHashMap<String, Object>();
        }
        if (cls == TreeMap.class) {
            return new TreeMap<String, Object>();
        }
        return map;
    }

    public static MapSO newMapSO(Class<?> cls) {
        MapSO map = null;
        if (cls == MapSO.class || cls == HashMapSO.class) {
            return new HashMapSO();
        }
        if (cls == LinkedMapSO.class) {
            return new LinkedMapSO();
        }
        if (cls == TreeMapSO.class) {
            return new TreeMapSO();
        }
        return map;
    }

    public static MapSS newMapSS(Class<?> cls) {
        if (cls == MapSS.class || cls == HashMapSS.class) {
            return new HashMapSS();
        }
        if (cls == LinkedMapSS.class) {
            return new LinkedMapSS();
        }
        if (cls == TreeMapSS.class) {
            return new TreeMapSS();
        }
        return null;
    }

    public static <T> T newInstance(Class<T> cls, Map<String, String> paramMap) throws IllegalAccessException {
        T obj = null;
        try {
            obj = cls.newInstance();
        }
        catch (Exception exception) {
            throw Asserts.exception("\u7c7b[" + cls + "]\u4e0d\u652f\u6301\u65e0\u53c2\u6570\u5b9e\u4f8b\u5316");
        }
        List<Field> fields = Classes.getFieldListDeep(cls);
        block22: for (Field field : fields) {
            Class<?> type;
            String value = paramMap.get(field.getName());
            if (value == null || !Types.isPrimitive(type = field.getType()) && !Types.isPrimitiveArray(type) && type != String.class && type != String[].class) continue;
            field.setAccessible(true);
            switch (type.getName().hashCode()) {
                case 64711720: 
                case 344809556: {
                    if ("true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value)) {
                        field.setBoolean(obj, true);
                        break;
                    }
                    field.setBoolean(obj, false);
                    break;
                }
                case 3039496: 
                case 398507100: {
                    if (!Validates.isInteger(value) && !Validates.isNumeric(value)) continue block22;
                    field.setByte(obj, Byte.parseByte(value));
                    break;
                }
                case 3052374: 
                case 155276373: {
                    if (value.length() != 1) break;
                    field.setChar(obj, value.charAt(0));
                    break;
                }
                case -515992664: 
                case 109413500: {
                    if (!Validates.isInteger(value) && !Validates.isNumeric(value)) continue block22;
                    field.setShort(obj, Short.parseShort(value));
                    break;
                }
                case -2056817302: 
                case 104431: {
                    if (!Validates.isInteger(value) && !Validates.isNumeric(value)) continue block22;
                    field.setInt(obj, Integer.parseInt(value));
                    break;
                }
                case 3327612: 
                case 398795216: {
                    if (!Validates.isInteger(value) && !Validates.isNumeric(value)) continue block22;
                    field.setLong(obj, Long.parseLong(value));
                    break;
                }
                case 97526364: 
                case 527879800: {
                    if (!Validates.isFloat(value)) break;
                    field.setFloat(obj, Float.parseFloat(value));
                    break;
                }
                case -1325958191: 
                case 761287205: {
                    if (!Validates.isFloat(value)) break;
                    field.setDouble(obj, Double.parseDouble(value));
                    break;
                }
                case 1195259493: {
                    field.set(obj, value);
                    break;
                }
                case 2911: {
                    boolean[] values = Arrays.toBooleanArrayForm(value, ",");
                    field.set(obj, values);
                    break;
                }
                case 2887: {
                    if (value.length() <= 0) break;
                    field.set(obj, Strings.getBytesUTF8(value));
                    break;
                }
                case 2888: {
                    if (value.length() <= 0) break;
                    field.set(obj, value.toCharArray());
                    break;
                }
                case 2904: {
                    if (!Validates.isInteger(value)) break;
                    field.set(obj, Arrays.toShortArray(value));
                    break;
                }
                case 2894: {
                    if (!Validates.isInteger(value)) break;
                    field.set(obj, Arrays.toIntArray(value));
                    break;
                }
                case 2895: {
                    if (!Validates.isInteger(value)) break;
                    field.set(obj, Arrays.toLongArray(value));
                    break;
                }
                case 2891: {
                    if (!Validates.isFloat(value)) break;
                    field.set(obj, Arrays.toFloatArray(value));
                    break;
                }
                case 2889: {
                    if (!Validates.isFloat(value)) break;
                    field.set(obj, Arrays.toDoubleArray(value));
                    break;
                }
                case 392722245: {
                    field.set(obj, Arrays.toStringArray(value));
                }
            }
        }
        return obj;
    }

    public static boolean isExtends(Class<?> cls, Class<?> superClass) {
        return superClass == cls || superClass.isAssignableFrom(cls);
    }

    public static boolean isImplement(Class<?> cls, Class<?> iface) {
        Class<?> c;
        if (iface == null || cls == null || cls == Object.class || Types.isPrimitiveBase(cls) || !iface.isInterface()) {
            return false;
        }
        if (cls == iface) {
            return true;
        }
        Class<?>[] classArray = cls.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            c = classArray[n2];
            while (c != iface) {
                Class<?>[] cs = c.getInterfaces();
                if (cs.length == 0) break;
                c = cs[0];
            }
            if (c == iface) {
                return true;
            }
            ++n2;
        }
        c = cls.getSuperclass();
        while (c != null && c != Object.class) {
            if (Classes.isImplement(c, iface)) {
                return true;
            }
            c = c.getSuperclass();
        }
        return false;
    }

    public static boolean isCollection(Class<?> clazz) {
        return Classes.isImplement(clazz, Collection.class);
    }

    public static boolean isMap(Class<?> clazz) {
        return Classes.isImplement(clazz, Map.class);
    }

    public static boolean isStaticMethod(Method method) {
        return (method.getModifiers() & 8) != 0;
    }

    public static boolean isStaticField(Field field) {
        return (field.getModifiers() & 8) != 0;
    }

    public static boolean isTransientField(Field field) {
        return (field.getModifiers() & 0x80) != 0;
    }

    public static boolean isStaticTransientField(Field field) {
        return (field.getModifiers() & 8) != 0 || (field.getModifiers() & 0x80) != 0;
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Method getMethodDeep(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        Method method = Classes.getMethod(clazz, name, parameterTypes);
        while (method == null) {
            if (clazz == Object.class || clazz.getSuperclass() == Object.class) break;
            clazz = clazz.getSuperclass();
            method = Classes.getMethod(clazz, name, parameterTypes);
        }
        return method;
    }

    @AnNullable
    public static Field getField(Class<?> clazz, String name) {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Field getFieldDeep(Class<?> clazz, String name) {
        return Classes.getFieldDeep(clazz, name, 0);
    }

    public static Field getFieldStaticDeep(Class<?> cls, String name) {
        return Classes.getFieldDeep(cls, name, 2);
    }

    public static Field getFieldDeep(Class<?> clazz, String name, int type) {
        Asserts.as((String)(type >= 0 && type <= 2 ? null : "\u67e5\u8be2\u5c5e\u6027\u7c7b\u578b\uff0c\u4ec5\u652f\u63010,1,2\u8bf7\u67e5\u770b\u8bf4\u660e"));
        do {
            Field field;
            if ((field = Classes.getField(clazz, name)) != null) {
                if (type == 0) {
                    return field;
                }
                if (type == 1 && !Classes.isStaticTransientField(field)) {
                    return field;
                }
                if (type == 2 && Classes.isStaticField(field)) {
                    return field;
                }
            }
            if (type != 1) {
                Class<?>[] classes;
                Class<?>[] classArray = classes = clazz.getInterfaces();
                int n = classes.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> cls = classArray[n2];
                    field = Classes.getFieldDeep(cls, name, type);
                    if (field != null) {
                        return field;
                    }
                    ++n2;
                }
            }
            if (clazz != Object.class) continue;
            return null;
        } while ((clazz = clazz.getSuperclass()) != null && clazz != Object.class);
        return null;
    }

    public static Object getFieldValue(Object obj, String field) {
        Asserts.notNull(field, "field");
        Field f = Classes.getField(obj.getClass(), field);
        return Classes.getFieldValue(obj, f);
    }

    public static Object getFieldValue(Object obj, Field field) {
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field.get(obj);
        }
        catch (Exception e) {
            throw Asserts.exception(e);
        }
    }

    public static void setFieldValue(Object obj, Field field, Object value) {
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(obj, value);
        }
        catch (Exception e) {
            throw Asserts.exception(e);
        }
    }

    public static List<Field> getFieldListDeep(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        Classes.getFieldListDeep(clazz, fieldList);
        return fieldList;
    }

    public static void getFieldListDeep(Class<?> clazz, List<Field> fieldList) {
        Field[] fieldArr;
        Field[] fieldArray = fieldArr = clazz.getDeclaredFields();
        int n = fieldArr.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int mod = field.getModifiers();
            if (!(Modifier.isStatic(mod) || Modifier.isTransient(mod) || "this$0".equals(field.getName()))) {
                fieldList.add(field);
            }
            ++n2;
        }
        Class<?> superSrcClass = clazz.getSuperclass();
        if (superSrcClass != null && superSrcClass != Object.class) {
            Classes.getFieldListDeep(superSrcClass, fieldList);
        }
    }

    public static boolean isMethodLastParamArray(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        return paramTypes.length > 0 && Types.isArray(paramTypes[paramTypes.length - 1]);
    }

    public static boolean isMethodParamMatch(Class<?>[] paramTypes, Object[] paramArray) {
        if (paramTypes.length != paramArray.length) {
            return false;
        }
        int i = 0;
        while (i < paramTypes.length) {
            Class<?> clazz = paramTypes[i];
            Object param = paramArray[i];
            if (param == null ? Types.isPrimitive(clazz) : (Types.isPrimitive(clazz) ? Types.isInteger(clazz) && !Types.isInteger(param) || Types.isDecimal(clazz) && !Types.isDecimal(param) || Types.isBoolean(clazz) && !Types.isBoolean(param) || Types.isChar(clazz) && !Types.isChar(param) : (i == paramTypes.length - 1 && Types.isArray(clazz) ? clazz != param.getClass() && !clazz.getComponentType().isAssignableFrom(param.getClass()) : clazz != param.getClass() && !clazz.isAssignableFrom(param.getClass())))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

