/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.io.FileNotFoundException;
import java.util.Collection;
import org.zhiqim.kernel.ZhiqimI18n;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Stringx;
import org.zhiqim.kernel.util.Threads;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"Asserts"})
public class Asserts {
    public static void as(String exception) {
        if (exception == null) {
            return;
        }
        throw new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + exception);
    }

    public static void as(String exception, Object ... arguments) {
        if (exception == null) {
            return;
        }
        exception = Strings.formatTwo(exception, arguments);
        throw new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + exception);
    }

    public static void asState(String exception) {
        if (exception == null) {
            return;
        }
        throw new IllegalStateException(String.valueOf(Threads.getInvokerAbbr()) + exception);
    }

    public static void asState(String exception, Object ... arguments) {
        if (exception == null) {
            return;
        }
        exception = Strings.formatTwo(exception, arguments);
        throw new IllegalStateException(String.valueOf(Threads.getInvokerAbbr()) + exception);
    }

    public static void notNull(Object param) {
        if (param == null) {
            throw new NullPointerException(String.valueOf(Threads.getInvokerAbbr()) + ZhiqimI18n.parameterCannotBeNull);
        }
    }

    public static void notNull(Object param, String paramName) {
        if (param == null) {
            String exception = Strings.formatTwo(ZhiqimI18n.parameterCannotBeNull1, paramName);
            throw new NullPointerException(String.valueOf(Threads.getInvokerAbbr()) + exception);
        }
    }

    public static void notEmpty(String param) {
        if (Validates.isEmpty(param)) {
            throw new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + ZhiqimI18n.parameterCannotBeNullOrEmpty);
        }
    }

    public static void notEmpty(String param, String paramName) {
        if (Validates.isEmpty(param)) {
            String exception = Strings.formatTwo(ZhiqimI18n.parameterCannotBeNullOrEmpty1, paramName);
            throw new NullPointerException(String.valueOf(Threads.getInvokerAbbr()) + exception);
        }
    }

    public static void notEmpty(Object param) {
        if (Validates.isEmpty(param)) {
            throw new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + ZhiqimI18n.parameterCannotBeNullOrEmpty);
        }
    }

    public static void notEmpty(Object param, String paramName) {
        if (Validates.isEmpty(param)) {
            String exception = Strings.formatTwo(ZhiqimI18n.parameterCannotBeNullOrEmpty1, paramName);
            throw new NullPointerException(String.valueOf(Threads.getInvokerAbbr()) + exception);
        }
    }

    public static void notEmptyBlank(String param) {
        if (Validates.isEmptyBlank(param)) {
            throw new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + ZhiqimI18n.parameterCannotBeNullOrEmptyBlank);
        }
    }

    public static void notEmptyBlank(String param, String paramName) {
        if (Validates.isEmptyBlank(param)) {
            String exception = Strings.formatTwo(ZhiqimI18n.parameterCannotBeNullOrEmptyBlank1, paramName);
            throw new NullPointerException(String.valueOf(Threads.getInvokerAbbr()) + exception);
        }
    }

    public static void asInteger(String param) {
        if (!Validates.isInteger(param)) {
            throw new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + ZhiqimI18n.parameterMustBeInteger);
        }
    }

    public static void asInteger(String param, String paramName) {
        if (!Validates.isInteger(param)) {
            String exception = Strings.formatTwo(ZhiqimI18n.parameterMustBeInteger, paramName);
            throw new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + exception);
        }
    }

    public static void asserts(boolean param, String exception) {
        if (!param) {
            throw new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + exception);
        }
    }

    public static void asserts(boolean param, String exception, Object ... arguments) {
        if (!param) {
            exception = Strings.formatTwo(exception, arguments);
            throw new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + exception);
        }
    }

    public static void assertState(boolean param, String exception) {
        if (!param) {
            throw new IllegalStateException(String.valueOf(Threads.getInvokerAbbr()) + exception);
        }
    }

    public static void assertState(boolean param, String exception, Object ... arguments) {
        if (!param) {
            exception = Strings.formatTwo(exception, arguments);
            throw new IllegalStateException(String.valueOf(Threads.getInvokerAbbr()) + exception);
        }
    }

    public static void assertNotNull(Object param, String exception) {
        if (param == null) {
            throw new NullPointerException(String.valueOf(Threads.getInvokerAbbr()) + exception);
        }
    }

    public static void assertNotNull(Object param, String exception, Object ... arguments) {
        if (param == null) {
            exception = Strings.formatTwo(exception, arguments);
            throw new NullPointerException(String.valueOf(Threads.getInvokerAbbr()) + exception);
        }
    }

    public static void assertNotEmpty(String param, String exception) {
        if (Validates.isEmpty(param)) {
            throw new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + exception);
        }
    }

    public static void assertNotEmpty(String param, String exception, Object ... arguments) {
        if (Validates.isEmpty(param)) {
            exception = Strings.formatTwo(exception, arguments);
            throw new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + exception);
        }
    }

    public static void assertNotEmpty(Collection<?> param, String exception, Object ... arguments) {
        if (Validates.isEmpty(param)) {
            exception = Strings.formatTwo(exception, arguments);
            throw new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + exception);
        }
    }

    public static void assertNotEmpty(Object[] param, String exception, Object ... arguments) {
        if (Validates.isEmpty(param)) {
            exception = Strings.formatTwo(exception, arguments);
            throw new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + exception);
        }
    }

    public static void assertNotEmptyBlank(String param, String exception) {
        if (Validates.isEmptyBlank(param)) {
            throw new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + exception);
        }
    }

    public static void assertNotEmptyBlank(String param, String exception, Object ... arguments) {
        if (Validates.isEmptyBlank(param)) {
            exception = Strings.formatTwo(exception, arguments);
            throw new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + exception);
        }
    }

    public static void assertInteger(String param, String exception) {
        if (!Validates.isInteger(param)) {
            throw new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + exception);
        }
    }

    public static void assertInteger(String param, String exception, Object ... arguments) {
        if (!Validates.isInteger(param)) {
            exception = Strings.formatTwo(exception, arguments);
            throw new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + exception);
        }
    }

    public static void assertStartsWith(String str, String prefix, String exception) {
        if (!Stringx.startsWith(str, prefix)) {
            throw new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + exception);
        }
    }

    public static void assertStartsWith(String str, String prefix, String exception, Object ... arguments) {
        if (!Stringx.startsWith(str, prefix)) {
            exception = Strings.formatTwo(exception, arguments);
            throw new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + exception);
        }
    }

    public static IllegalArgumentException exception(String message) {
        return new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + message);
    }

    public static IllegalArgumentException exception(Exception e) {
        return new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + e.getMessage(), e);
    }

    public static IllegalArgumentException exception(String message, Object ... arguments) {
        message = Strings.formatTwo(message, arguments);
        return new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + message);
    }

    public static IllegalArgumentException exception(String message, Exception e) {
        return new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + message, e);
    }

    public static IllegalArgumentException exception(String message, Exception e, Object ... arguments) {
        message = Strings.formatTwo(message, arguments);
        return new IllegalArgumentException(String.valueOf(Threads.getInvokerAbbr()) + message, e);
    }

    public static FileNotFoundException notFound(String message) {
        return new FileNotFoundException(String.valueOf(Threads.getInvokerAbbr()) + message);
    }

    public static FileNotFoundException notFound(String message, Object ... arguments) {
        message = Strings.formatTwo(message, arguments);
        return new FileNotFoundException(String.valueOf(Threads.getInvokerAbbr()) + message);
    }
}

