/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnGenerics;
import org.zhiqim.kernel.util.Types;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"Annotations"})
public class Annotations {
    public static String getClassAlias(Class<?> clazz) {
        AnAlias alias = clazz.getAnnotation(AnAlias.class);
        if (alias != null && !Validates.isEmptyBlank(alias.value()[0])) {
            return alias.value()[0].trim();
        }
        return null;
    }

    public static String getFieldName(Field field) {
        AnAlias alias = field.getAnnotation(AnAlias.class);
        if (alias != null && Validates.isNotEmptyBlank(alias.value()[0])) {
            return alias.value()[0].trim();
        }
        return field.getName();
    }

    public static Class<?> getGenericsClass(Field field) {
        if (Types.isArray(field.getType())) {
            return field.getType().getComponentType();
        }
        AnGenerics generics = field.getAnnotation(AnGenerics.class);
        return generics == null ? null : generics.value();
    }

    public static String getMethodName(Method method) {
        AnAlias alias = method.getAnnotation(AnAlias.class);
        if (alias != null && Validates.isNotEmptyBlank(alias.value()[0])) {
            return alias.value()[0].trim();
        }
        return method.getName();
    }

    public static String getMethodAlias(Method method) {
        AnAlias alias = method.getAnnotation(AnAlias.class);
        if (alias == null || Validates.isEmptyBlank(alias.value()[0])) {
            return null;
        }
        return alias.value()[0].trim();
    }

    public boolean isMethodNameOrAlias(Method method, String name) {
        if (Validates.isEmptyBlank(name)) {
            return false;
        }
        if (name.equals(method.getName())) {
            return true;
        }
        AnAlias alias = method.getAnnotation(AnAlias.class);
        return alias != null && name.equals(alias.value()[0].trim());
    }
}

