/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.schedule;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.schedule.Task;
import org.zhiqim.kernel.schedule.TaskThreader;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Longs;
import org.zhiqim.kernel.util.Strings;

@AnAlias(value={"Week"})
public final class Week
extends TaskThreader {
    private int taskWeek = 1;
    private int taskHour = 0;
    private int taskMinute = 0;
    private int taskSecond = 0;

    public Week() {
    }

    public Week(Task task, int week, int hour, int minute, int second) {
        this.schedule(task, new int[]{week, hour, minute, second});
    }

    @Override
    public String getName() {
        return "Week";
    }

    @Override
    public String getTime() {
        return this.taskWeek + "/" + this.taskHour + "/" + this.taskMinute + "/" + this.taskSecond;
    }

    @Override
    protected TaskThreader schedule(Task task, int[] time) {
        if (task == null || time == null || time.length != 4) {
            throw new RuntimeException("Week\u4f20\u5165\u7684\u53c2\u6570\u4e3a\u7a7a\u6216\u6570\u7ec4\u957f\u5ea6\u4e0d\u5bf9");
        }
        if (time[0] < 0 || time[0] > 7 || time[1] < 0 || time[1] > 23 || time[2] < 0 || time[2] > 59 || time[3] < 0 || time[3] > 59) {
            throw new RuntimeException("Week\u4f20\u65f6\u7684\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        this.task = task;
        this.taskWeek = time[0];
        this.taskHour = time[1];
        this.taskMinute = time[2];
        this.taskSecond = time[3];
        return this;
    }

    @Override
    protected long calcLastTime(int curYearMonth, int curMonthMaxDay, int curDay, int curHour, int curMinute, int curSecond, int curWeek) {
        int weekDiffDays = curWeek - this.taskWeek;
        if (weekDiffDays == 0) {
            return (long)curYearMonth * 100L + (long)curDay;
        }
        if (weekDiffDays < 0) {
            weekDiffDays += 7;
        }
        String curDate = String.valueOf(curYearMonth / 100) + "-" + Strings.prefixZero(curYearMonth % 100, 2) + "-" + Strings.prefixZero(curDay, 2);
        String lastWeekDate = DateTimes.getPreviousDateString(curDate, weekDiffDays);
        return Longs.toLong(lastWeekDate.replaceAll("-", ""));
    }

    @Override
    protected long calcLastTimeNextTime() {
        String lastWeekDate = String.valueOf(this.lastTime / 10000L) + "-" + Strings.prefixZero(this.lastTime / 100L % 100L, 2) + "-" + Strings.prefixZero(this.lastTime % 100L, 2);
        String nextWeekDate = DateTimes.getNextDateString(lastWeekDate, 7);
        return Longs.toLong(nextWeekDate.replaceAll("-", ""));
    }

    @Override
    protected final boolean isArrive(int curYearMonth, int curMonthMaxDay, int curDay, int curHour, int curMinute, int curSecond, int curWeek) {
        if (curHour < this.taskHour) {
            return false;
        }
        if (curHour > this.taskHour) {
            return true;
        }
        if (curMinute < this.taskMinute) {
            return false;
        }
        if (curMinute > this.taskMinute) {
            return true;
        }
        return curSecond >= this.taskSecond;
    }

    public int getTaskWeek() {
        return this.taskWeek;
    }

    public int getTaskHour() {
        return this.taskHour;
    }

    public int getTaskMinute() {
        return this.taskMinute;
    }

    public int getTaskSecond() {
        return this.taskSecond;
    }
}

