/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.schedule;

import org.zhiqim.kernel.control.ThreadLock;
import org.zhiqim.kernel.control.Threadx;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.schedule.Scheduler;
import org.zhiqim.kernel.schedule.Task;
import org.zhiqim.kernel.schedule.TaskLoad;

public abstract class TaskThreader
extends Threadx
implements Runnable {
    private static final Log log = LogFactory.getLog(TaskThreader.class);
    private final ThreadLock lock = new ThreadLock();
    private Scheduler scheduler;
    private int taskId;
    protected Task task = null;
    protected boolean isImmediateExecute;
    protected boolean isFirstExecute;
    protected long curTime;
    protected long lastTime;

    @Override
    protected ThreadGroup getThreadGroup() {
        return this.scheduler.getThreadGroup();
    }

    @Override
    public final String getThreadName() {
        return String.valueOf(this.scheduler.getThreadName()) + "-" + this.task.getClass().getName();
    }

    public final Scheduler getScheduler() {
        return this.scheduler;
    }

    public final int getTaskId() {
        return this.taskId;
    }

    public final TaskThreader setImmediateExecuteOnce() {
        this.isImmediateExecute = true;
        return this;
    }

    public final TaskThreader setFirstPreviousExecute() {
        this.isFirstExecute = true;
        return this;
    }

    public final long getLastTime() {
        return this.lastTime;
    }

    public abstract String getName();

    public abstract String getTime();

    protected abstract TaskThreader schedule(Task var1, int[] var2);

    protected abstract long calcLastTime(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected abstract long calcLastTimeNextTime();

    protected abstract boolean isArrive(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    final void setScheduleAndTaskId(Scheduler scheduler, int taskId) {
        this.scheduler = scheduler;
        this.taskId = taskId;
    }

    final void process(int curYearMonth, int curMonthMaxDay, int curDay, int curHour, int curMinute, int curSecond, int curWeek) {
        if (!this.lock.isLocked()) {
            return;
        }
        this.curTime = this.calcLastTime(curYearMonth, curMonthMaxDay, curDay, curHour, curMinute, curSecond, curWeek);
        if (this.isImmediateExecute) {
            this.isImmediateExecute = false;
            this.lock.unlock();
            return;
        }
        if (this.lastTime == 0L) {
            if (this.isFirstExecute) {
                this.lock.unlock();
            } else {
                this.lastTime = this.curTime;
            }
            return;
        }
        if (this.curTime <= this.lastTime) {
            return;
        }
        if (this.curTime > this.calcLastTimeNextTime()) {
            this.lock.unlock();
            return;
        }
        if (this.isArrive(curYearMonth, curMonthMaxDay, curDay, curHour, curMinute, curSecond, curWeek)) {
            this.lock.unlock();
            return;
        }
    }

    @Override
    protected void first() {
        if (this.task instanceof TaskLoad) {
            ((TaskLoad)this.task).load();
        }
    }

    @Override
    protected void loop() {
        this.lock.lock();
        if (!this.isRunning()) {
            return;
        }
        try {
            try {
                this.task.execute();
            }
            catch (Exception e) {
                log.error(e);
                this.lastTime = this.curTime;
            }
        }
        finally {
            this.lastTime = this.curTime;
        }
    }

    public String toString() {
        return "{" + "name:" + this.getName() + ", " + "time:" + this.getTime() + ", " + "first:" + this.isFirstExecute + "}";
    }
}

